/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.asm.ASMException;
import com.alibaba.fastjson.asm.ClassWriter;
import com.alibaba.fastjson.asm.FieldVisitor;
import com.alibaba.fastjson.asm.Label;
import com.alibaba.fastjson.asm.MethodVisitor;
import com.alibaba.fastjson.asm.Opcodes;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONScanner;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.ParseContext;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.SymbolTable;
import com.alibaba.fastjson.parser.deserializer.ASMJavaBeanDeserializer;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.IntegerFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.JavaBeanDeserializer;
import com.alibaba.fastjson.parser.deserializer.LongFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.StringFieldDeserializer;
import com.alibaba.fastjson.util.ASMClassLoader;
import com.alibaba.fastjson.util.ASMUtils;
import com.alibaba.fastjson.util.DeserializeBeanInfo;
import com.alibaba.fastjson.util.FieldInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASMDeserializerFactory
implements Opcodes {
    private static final ASMDeserializerFactory instance = new ASMDeserializerFactory();
    private ASMClassLoader classLoader = new ASMClassLoader();
    private final AtomicLong seed = new AtomicLong();

    public String getGenClassName(Class<?> clazz) {
        return "Fastjson_ASM_" + clazz.getSimpleName() + "_" + this.seed.incrementAndGet();
    }

    public String getGenFieldDeserializer(Class<?> clazz, FieldInfo fieldInfo) {
        String name = "Fastjson_ASM__Field_" + clazz.getSimpleName();
        name = name + "_" + fieldInfo.getName() + "_" + this.seed.incrementAndGet();
        return name;
    }

    public static final ASMDeserializerFactory getInstance() {
        return instance;
    }

    public ObjectDeserializer createJavaBeanDeserializer(ParserConfig config, Class<?> clazz, Type type) throws Exception {
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException("not support type :" + clazz.getName());
        }
        String className = this.getGenClassName(clazz);
        ClassWriter cw = new ClassWriter();
        cw.visit(49, 33, className, ASMUtils.getType(ASMJavaBeanDeserializer.class), null);
        DeserializeBeanInfo beanInfo = DeserializeBeanInfo.computeSetters(clazz, type);
        this._init(cw, new Context(className, config, beanInfo, 3));
        this._createInstance(cw, new Context(className, config, beanInfo, 3));
        this._deserialze(cw, new Context(className, config, beanInfo, 4));
        byte[] code = cw.toByteArray();
        Class<?> exampleClass = this.classLoader.defineClassPublic(className, code, 0, code.length);
        Constructor<?> constructor = exampleClass.getConstructor(ParserConfig.class, Class.class);
        Object instance = constructor.newInstance(config, clazz);
        return (ObjectDeserializer)instance;
    }

    /*
     * Enabled aggressive block sorting
     */
    void _deserialze(ClassWriter cw, Context context) {
        int maxStack;
        MethodVisitor mw;
        block52: {
            int len$;
            Class<?>[] arr$;
            int paramStacks;
            block53: {
                int len$2;
                Class<?>[] arr$2;
                int constructorTypeStack;
                block51: {
                    block50: {
                        if (context.getFieldInfoList().size() == 0) {
                            return;
                        }
                        for (FieldInfo fieldInfo : context.getFieldInfoList()) {
                            Class<?> fieldClass = fieldInfo.getFieldClass();
                            Type fieldType = fieldInfo.getFieldType();
                            if (fieldClass == Character.TYPE) {
                                return;
                            }
                            if (!Collection.class.isAssignableFrom(fieldClass)) continue;
                            if (!(fieldType instanceof ParameterizedType)) {
                                return;
                            }
                            Type itemType = ((ParameterizedType)fieldType).getActualTypeArguments()[0];
                            if (itemType instanceof Class) continue;
                            return;
                        }
                        Collections.sort(context.getFieldInfoList());
                        mw = cw.visitMethod(1, "deserialze", "(" + ASMUtils.getDesc(DefaultJSONParser.class) + ASMUtils.getDesc(Type.class) + "Ljava/lang/Object;)Ljava/lang/Object;", null, null);
                        Label reset_ = new Label();
                        Label super_ = new Label();
                        Label return_ = new Label();
                        Label end_ = new Label();
                        mw.visitVarInsn(25, 1);
                        mw.visitMethodInsn(182, ASMUtils.getType(DefaultJSONParser.class), "getLexer", "()" + ASMUtils.getDesc(JSONLexer.class));
                        mw.visitTypeInsn(192, ASMUtils.getType(JSONScanner.class));
                        mw.visitVarInsn(58, context.var("lexer"));
                        mw.visitVarInsn(25, context.var("lexer"));
                        mw.visitFieldInsn(178, ASMUtils.getType(Feature.class), "SortFeidFastMatch", "L" + ASMUtils.getType(Feature.class) + ";");
                        mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "isEnabled", "(L" + ASMUtils.getType(Feature.class) + ";" + ")Z");
                        mw.visitJumpInsn(153, super_);
                        mw.visitVarInsn(25, context.var("lexer"));
                        mw.visitLdcInsn(context.getClazz().getName());
                        mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "scanType", "(Ljava/lang/String;)I");
                        mw.visitFieldInsn(178, ASMUtils.getType(JSONScanner.class), "NOT_MATCH", "I");
                        mw.visitJumpInsn(159, super_);
                        mw.visitVarInsn(25, context.var("lexer"));
                        mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "getBufferPosition", "()I");
                        mw.visitVarInsn(54, context.var("mark"));
                        mw.visitVarInsn(25, context.var("lexer"));
                        mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "getCurrent", "()C");
                        mw.visitVarInsn(54, context.var("mark_ch"));
                        mw.visitVarInsn(25, context.var("lexer"));
                        mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "token", "()I");
                        mw.visitVarInsn(54, context.var("mark_token"));
                        Constructor<?> defaultConstructor = context.getBeanInfo().getDefaultConstructor();
                        if (context.getClazz().isInterface()) {
                            mw.visitVarInsn(25, 0);
                            mw.visitVarInsn(25, 1);
                            mw.visitMethodInsn(183, ASMUtils.getType(ASMJavaBeanDeserializer.class), "createInstance", "(" + ASMUtils.getDesc(DefaultJSONParser.class) + ")Ljava/lang/Object;");
                            mw.visitTypeInsn(192, ASMUtils.getType(context.getClazz()));
                            mw.visitVarInsn(58, context.var("instance"));
                        } else if (defaultConstructor != null) {
                            if (Modifier.isPublic(defaultConstructor.getModifiers())) {
                                mw.visitTypeInsn(187, ASMUtils.getType(context.getClazz()));
                                mw.visitInsn(89);
                                mw.visitMethodInsn(183, ASMUtils.getType(context.getClazz()), "<init>", "()V");
                                mw.visitVarInsn(58, context.var("instance"));
                            } else {
                                mw.visitVarInsn(25, 0);
                                mw.visitVarInsn(25, 1);
                                mw.visitMethodInsn(183, ASMUtils.getType(ASMJavaBeanDeserializer.class), "createInstance", "(" + ASMUtils.getDesc(DefaultJSONParser.class) + ")Ljava/lang/Object;");
                                mw.visitTypeInsn(192, ASMUtils.getType(context.getClazz()));
                                mw.visitVarInsn(58, context.var("instance"));
                            }
                        } else {
                            mw.visitInsn(1);
                            mw.visitTypeInsn(192, ASMUtils.getType(context.getClazz()));
                            mw.visitVarInsn(58, context.var("instance"));
                        }
                        mw.visitVarInsn(25, 1);
                        mw.visitMethodInsn(182, ASMUtils.getType(DefaultJSONParser.class), "getContext", "()Lcom/alibaba/fastjson/parser/ParseContext;");
                        mw.visitVarInsn(58, context.var("context"));
                        mw.visitVarInsn(25, 1);
                        mw.visitVarInsn(25, context.var("context"));
                        mw.visitVarInsn(25, context.var("instance"));
                        mw.visitVarInsn(25, 3);
                        mw.visitMethodInsn(182, ASMUtils.getType(DefaultJSONParser.class), "setContext", "(Lcom/alibaba/fastjson/parser/ParseContext;Ljava/lang/Object;Ljava/lang/Object;)Lcom/alibaba/fastjson/parser/ParseContext;");
                        mw.visitVarInsn(58, context.var("childContext"));
                        mw.visitVarInsn(25, context.var("lexer"));
                        mw.visitFieldInsn(180, ASMUtils.getType(JSONScanner.class), "matchStat", "I");
                        mw.visitFieldInsn(178, ASMUtils.getType(JSONScanner.class), "END", "I");
                        mw.visitJumpInsn(159, return_);
                        int size = context.getFieldInfoList().size();
                        for (int i = 0; i < size; ++i) {
                            block49: {
                                FieldInfo fieldInfo = context.getFieldInfoList().get(i);
                                Class<?> fieldClass = fieldInfo.getFieldClass();
                                Type fieldType = fieldInfo.getFieldType();
                                mw.visitVarInsn(25, context.var("lexer"));
                                mw.visitVarInsn(25, 0);
                                mw.visitFieldInsn(180, context.getClassName(), fieldInfo.getName() + "_asm_prefix__", "[C");
                                if (fieldClass == Boolean.TYPE) {
                                    mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "scanFieldBoolean", "([C)Z");
                                    mw.visitVarInsn(54, context.var(fieldInfo.getName() + "_asm"));
                                } else if (fieldClass == Byte.TYPE) {
                                    mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "scanFieldInt", "([C)I");
                                    mw.visitVarInsn(54, context.var(fieldInfo.getName() + "_asm"));
                                } else if (fieldClass == Short.TYPE) {
                                    mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "scanFieldInt", "([C)I");
                                    mw.visitVarInsn(54, context.var(fieldInfo.getName() + "_asm"));
                                } else if (fieldClass == Integer.TYPE) {
                                    mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "scanFieldInt", "([C)I");
                                    mw.visitVarInsn(54, context.var(fieldInfo.getName() + "_asm"));
                                } else if (fieldClass == Long.TYPE) {
                                    mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "scanFieldLong", "([C)J");
                                    mw.visitVarInsn(55, context.var(fieldInfo.getName() + "_asm", 2));
                                } else if (fieldClass == Float.TYPE) {
                                    mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "scanFieldFloat", "([C)F");
                                    mw.visitVarInsn(56, context.var(fieldInfo.getName() + "_asm"));
                                } else if (fieldClass == Double.TYPE) {
                                    mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "scanFieldDouble", "([C)D");
                                    mw.visitVarInsn(57, context.var(fieldInfo.getName() + "_asm", 2));
                                } else if (fieldClass == String.class) {
                                    mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "scanFieldString", "([C)Ljava/lang/String;");
                                    mw.visitInsn(89);
                                    Label endCheck_ = new Label();
                                    mw.visitJumpInsn(199, endCheck_);
                                    mw.visitVarInsn(25, 1);
                                    mw.visitFieldInsn(178, ASMUtils.getType(Feature.class), "InitStringFieldAsEmpty", "L" + ASMUtils.getType(Feature.class) + ";");
                                    mw.visitMethodInsn(182, ASMUtils.getType(DefaultJSONParser.class), "isEnabled", "(L" + ASMUtils.getType(Feature.class) + ";" + ")Z");
                                    mw.visitJumpInsn(153, endCheck_);
                                    mw.visitInsn(87);
                                    mw.visitLdcInsn("");
                                    mw.visitLabel(endCheck_);
                                    mw.visitVarInsn(58, context.var(fieldInfo.getName() + "_asm"));
                                } else if (fieldClass == byte[].class) {
                                    mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "scanFieldByteArray", "([C)[B");
                                    mw.visitVarInsn(58, context.var(fieldInfo.getName() + "_asm"));
                                } else if (fieldClass.isEnum()) {
                                    Label enumNull_ = new Label();
                                    mw.visitInsn(1);
                                    mw.visitTypeInsn(192, ASMUtils.getType(fieldClass));
                                    mw.visitVarInsn(58, context.var(fieldInfo.getName() + "_asm"));
                                    mw.visitVarInsn(25, 1);
                                    mw.visitMethodInsn(182, ASMUtils.getType(DefaultJSONParser.class), "getSymbolTable", "()" + ASMUtils.getDesc(SymbolTable.class));
                                    mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "scanFieldSymbol", "([C" + ASMUtils.getDesc(SymbolTable.class) + ")Ljava/lang/String;");
                                    mw.visitInsn(89);
                                    mw.visitVarInsn(58, context.var(fieldInfo.getName() + "_asm_enumName"));
                                    mw.visitJumpInsn(198, enumNull_);
                                    mw.visitVarInsn(25, context.var(fieldInfo.getName() + "_asm_enumName"));
                                    mw.visitMethodInsn(184, ASMUtils.getType(fieldClass), "valueOf", "(Ljava/lang/String;)" + ASMUtils.getDesc(fieldClass));
                                    mw.visitVarInsn(58, context.var(fieldInfo.getName() + "_asm"));
                                    mw.visitLabel(enumNull_);
                                } else {
                                    if (Collection.class.isAssignableFrom(fieldClass)) {
                                        Type actualTypeArgument = ((ParameterizedType)fieldType).getActualTypeArguments()[0];
                                        if (!(actualTypeArgument instanceof Class)) {
                                            throw new ASMException("can not create ASMParser");
                                        }
                                        Class itemClass = (Class)actualTypeArgument;
                                        if (!Modifier.isPublic(itemClass.getModifiers())) {
                                            throw new ASMException("can not create ASMParser");
                                        }
                                        if (itemClass == String.class) {
                                            mw.visitLdcInsn(com.alibaba.fastjson.asm.Type.getType(ASMUtils.getDesc(fieldClass)));
                                            mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "scanFieldStringArray", "([CLjava/lang/Class;)" + ASMUtils.getDesc(Collection.class));
                                            mw.visitVarInsn(58, context.var(fieldInfo.getName() + "_asm"));
                                            break block49;
                                        } else {
                                            this._deserialze_list_obj(context, mw, reset_, fieldInfo, fieldClass, itemClass);
                                            if (i != size - 1) continue;
                                            this._deserialize_endCheck(context, mw, reset_);
                                            continue;
                                        }
                                    }
                                    this._deserialze_obj(context, mw, reset_, fieldInfo, fieldClass);
                                    if (i != size - 1) continue;
                                    this._deserialize_endCheck(context, mw, reset_);
                                    continue;
                                }
                            }
                            mw.visitVarInsn(25, context.var("lexer"));
                            mw.visitFieldInsn(180, ASMUtils.getType(JSONScanner.class), "matchStat", "I");
                            mw.visitFieldInsn(178, ASMUtils.getType(JSONScanner.class), "NOT_MATCH", "I");
                            mw.visitJumpInsn(159, reset_);
                            if (i != size - 1) continue;
                            mw.visitVarInsn(25, context.var("lexer"));
                            mw.visitFieldInsn(180, ASMUtils.getType(JSONScanner.class), "matchStat", "I");
                            mw.visitFieldInsn(178, ASMUtils.getType(JSONScanner.class), "END", "I");
                            mw.visitJumpInsn(160, reset_);
                        }
                        mw.visitLabel(end_);
                        if (!context.getClazz().isInterface() && !Modifier.isAbstract(context.getClazz().getModifiers())) {
                            if (defaultConstructor != null) {
                                this._batchSet(context, mw);
                            } else {
                                Constructor<?> creatorConstructor = context.getBeanInfo().getCreatorConstructor();
                                if (creatorConstructor != null) {
                                    mw.visitTypeInsn(187, ASMUtils.getType(context.getClazz()));
                                    mw.visitInsn(89);
                                    this._loadCreatorParameters(context, mw);
                                    mw.visitMethodInsn(183, ASMUtils.getType(context.getClazz()), "<init>", ASMUtils.getDesc(creatorConstructor));
                                    mw.visitVarInsn(58, context.var("instance"));
                                } else {
                                    Method factoryMethod = context.getBeanInfo().getFactoryMethod();
                                    if (factoryMethod == null) {
                                        throw new JSONException("TODO");
                                    }
                                    this._loadCreatorParameters(context, mw);
                                    mw.visitMethodInsn(184, ASMUtils.getType(factoryMethod.getDeclaringClass()), factoryMethod.getName(), ASMUtils.getDesc(factoryMethod));
                                    mw.visitVarInsn(58, context.var("instance"));
                                }
                            }
                        }
                        mw.visitLabel(return_);
                        this._setContext(context, mw, true);
                        mw.visitVarInsn(25, context.var("instance"));
                        mw.visitInsn(176);
                        mw.visitLabel(reset_);
                        mw.visitVarInsn(25, context.var("lexer"));
                        mw.visitVarInsn(21, context.var("mark"));
                        mw.visitVarInsn(21, context.var("mark_ch"));
                        mw.visitVarInsn(21, context.var("mark_token"));
                        mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "reset", "(ICI)V");
                        this._setContext(context, mw, false);
                        mw.visitLabel(super_);
                        mw.visitVarInsn(25, 0);
                        mw.visitVarInsn(25, 1);
                        mw.visitVarInsn(25, 2);
                        mw.visitVarInsn(25, 3);
                        mw.visitMethodInsn(183, ASMUtils.getType(ASMJavaBeanDeserializer.class), "deserialze", "(" + ASMUtils.getDesc(DefaultJSONParser.class) + ASMUtils.getDesc(Type.class) + "Ljava/lang/Object;)Ljava/lang/Object;");
                        mw.visitInsn(176);
                        maxStack = 4;
                        Constructor<?> creatorConstructor = context.getBeanInfo().getCreatorConstructor();
                        if (creatorConstructor == null) break block50;
                        constructorTypeStack = 2;
                        arr$2 = creatorConstructor.getParameterTypes();
                        len$2 = arr$2.length;
                        break block51;
                    }
                    Method factoryMethod = context.getBeanInfo().getFactoryMethod();
                    if (factoryMethod == null) break block52;
                    paramStacks = 2;
                    arr$ = factoryMethod.getParameterTypes();
                    len$ = arr$.length;
                    break block53;
                }
                for (int i$ = 0; i$ < len$2; ++i$) {
                    Class<?> type = arr$2[i$];
                    if (type == Long.TYPE || type == Double.TYPE) {
                        constructorTypeStack += 2;
                        continue;
                    }
                    ++constructorTypeStack;
                }
                if (maxStack < constructorTypeStack) {
                    maxStack = constructorTypeStack;
                }
                break block52;
            }
            for (int i$ = 0; i$ < len$; ++i$) {
                Class<?> type = arr$[i$];
                if (type == Long.TYPE || type == Double.TYPE) {
                    paramStacks += 2;
                    continue;
                }
                ++paramStacks;
            }
            if (maxStack < paramStacks) {
                maxStack = paramStacks;
            }
        }
        mw.visitMaxs(maxStack, context.getVariantCount());
        mw.visitEnd();
    }

    private void _loadCreatorParameters(Context context, MethodVisitor mw) {
        List<FieldInfo> fieldInfoList = context.getBeanInfo().getFieldList();
        int size = fieldInfoList.size();
        for (int i = 0; i < size; ++i) {
            FieldInfo fieldInfo = fieldInfoList.get(i);
            Class<?> fieldClass = fieldInfo.getFieldClass();
            Type fieldType = fieldInfo.getFieldType();
            if (fieldClass == Boolean.TYPE) {
                mw.visitVarInsn(21, context.var(fieldInfo.getName() + "_asm"));
                continue;
            }
            if (fieldClass == Byte.TYPE) {
                mw.visitVarInsn(21, context.var(fieldInfo.getName() + "_asm"));
                continue;
            }
            if (fieldClass == Short.TYPE) {
                mw.visitVarInsn(21, context.var(fieldInfo.getName() + "_asm"));
                continue;
            }
            if (fieldClass == Integer.TYPE) {
                mw.visitVarInsn(21, context.var(fieldInfo.getName() + "_asm"));
                continue;
            }
            if (fieldClass == Long.TYPE) {
                mw.visitVarInsn(22, context.var(fieldInfo.getName() + "_asm", 2));
                continue;
            }
            if (fieldClass == Float.TYPE) {
                mw.visitVarInsn(23, context.var(fieldInfo.getName() + "_asm"));
                continue;
            }
            if (fieldClass == Double.TYPE) {
                mw.visitVarInsn(24, context.var(fieldInfo.getName() + "_asm", 2));
                continue;
            }
            if (fieldClass == String.class) {
                mw.visitVarInsn(25, context.var(fieldInfo.getName() + "_asm"));
                continue;
            }
            if (fieldClass.isEnum()) {
                mw.visitVarInsn(25, context.var(fieldInfo.getName() + "_asm"));
                continue;
            }
            if (Collection.class.isAssignableFrom(fieldClass)) {
                Type itemType = ((ParameterizedType)fieldType).getActualTypeArguments()[0];
                if (itemType == String.class) {
                    mw.visitVarInsn(25, context.var(fieldInfo.getName() + "_asm"));
                    mw.visitTypeInsn(192, ASMUtils.getType(fieldClass));
                    continue;
                }
                mw.visitVarInsn(25, context.var(fieldInfo.getName() + "_asm"));
                continue;
            }
            mw.visitVarInsn(25, context.var(fieldInfo.getName() + "_asm"));
        }
    }

    private void _batchSet(Context context, MethodVisitor mw) {
        int size = context.getFieldInfoList().size();
        for (int i = 0; i < size; ++i) {
            FieldInfo fieldInfo = context.getFieldInfoList().get(i);
            Class<?> fieldClass = fieldInfo.getFieldClass();
            Type fieldType = fieldInfo.getFieldType();
            mw.visitVarInsn(25, context.var("instance"));
            if (fieldClass == Boolean.TYPE) {
                mw.visitVarInsn(21, context.var(fieldInfo.getName() + "_asm"));
            } else if (fieldClass == Byte.TYPE) {
                mw.visitVarInsn(21, context.var(fieldInfo.getName() + "_asm"));
            } else if (fieldClass == Short.TYPE) {
                mw.visitVarInsn(21, context.var(fieldInfo.getName() + "_asm"));
            } else if (fieldClass == Integer.TYPE) {
                mw.visitVarInsn(21, context.var(fieldInfo.getName() + "_asm"));
            } else {
                if (fieldClass == Long.TYPE) {
                    mw.visitVarInsn(22, context.var(fieldInfo.getName() + "_asm", 2));
                    mw.visitMethodInsn(182, ASMUtils.getType(context.getClazz()), fieldInfo.getMethod().getName(), "(J)V");
                    continue;
                }
                if (fieldClass == Float.TYPE) {
                    mw.visitVarInsn(23, context.var(fieldInfo.getName() + "_asm"));
                } else if (fieldClass == Double.TYPE) {
                    mw.visitVarInsn(24, context.var(fieldInfo.getName() + "_asm", 2));
                } else if (fieldClass == String.class) {
                    mw.visitVarInsn(25, context.var(fieldInfo.getName() + "_asm"));
                } else if (fieldClass.isEnum()) {
                    mw.visitVarInsn(25, context.var(fieldInfo.getName() + "_asm"));
                } else if (Collection.class.isAssignableFrom(fieldClass)) {
                    Type itemType = ((ParameterizedType)fieldType).getActualTypeArguments()[0];
                    if (itemType == String.class) {
                        mw.visitVarInsn(25, context.var(fieldInfo.getName() + "_asm"));
                        mw.visitTypeInsn(192, ASMUtils.getType(fieldClass));
                    } else {
                        mw.visitVarInsn(25, context.var(fieldInfo.getName() + "_asm"));
                    }
                } else {
                    mw.visitVarInsn(25, context.var(fieldInfo.getName() + "_asm"));
                }
            }
            int INVAKE_TYPE = context.getClazz().isInterface() ? 185 : 182;
            if (fieldInfo.getMethod() != null) {
                mw.visitMethodInsn(INVAKE_TYPE, ASMUtils.getType(fieldInfo.getDeclaringClass()), fieldInfo.getMethod().getName(), ASMUtils.getDesc(fieldInfo.getMethod()));
                if (fieldInfo.getMethod().getReturnType().equals(Void.TYPE)) continue;
                mw.visitInsn(87);
                continue;
            }
            mw.visitFieldInsn(181, ASMUtils.getType(fieldInfo.getDeclaringClass()), fieldInfo.getField().getName(), ASMUtils.getDesc(fieldInfo.getFieldClass()));
        }
    }

    private void _setContext(Context context, MethodVisitor mw, boolean setObject) {
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, context.var("context"));
        mw.visitMethodInsn(182, ASMUtils.getType(DefaultJSONParser.class), "setContext", "(Lcom/alibaba/fastjson/parser/ParseContext;)V");
        if (setObject) {
            Label endIf_ = new Label();
            mw.visitVarInsn(25, context.var("childContext"));
            mw.visitJumpInsn(198, endIf_);
            mw.visitVarInsn(25, context.var("childContext"));
            mw.visitVarInsn(25, context.var("instance"));
            mw.visitMethodInsn(182, ASMUtils.getType(ParseContext.class), "setObject", "(Ljava/lang/Object;)V");
            mw.visitLabel(endIf_);
        }
    }

    private void _deserialize_endCheck(Context context, MethodVisitor mw, Label reset_) {
        mw.visitVarInsn(25, context.var("lexer"));
        mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "token", "()I");
        mw.visitFieldInsn(178, ASMUtils.getType(JSONToken.class), "RBRACE", "I");
        mw.visitJumpInsn(160, reset_);
        mw.visitVarInsn(25, context.var("lexer"));
        mw.visitFieldInsn(178, ASMUtils.getType(JSONToken.class), "COMMA", "I");
        mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "nextToken", "(I)V");
    }

    private void _deserialze_list_obj(Context context, MethodVisitor mw, Label reset_, FieldInfo fieldInfo, Class<?> fieldClass, Class<?> itemType) {
        mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "matchField", "([C)Z");
        mw.visitJumpInsn(153, reset_);
        Label notNull_ = new Label();
        mw.visitVarInsn(25, 0);
        mw.visitFieldInsn(180, context.getClassName(), fieldInfo.getName() + "_asm_list_item_deser__", ASMUtils.getDesc(ObjectDeserializer.class));
        mw.visitJumpInsn(199, notNull_);
        mw.visitVarInsn(25, 0);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, ASMUtils.getType(DefaultJSONParser.class), "getConfig", "()" + ASMUtils.getDesc(ParserConfig.class));
        mw.visitLdcInsn(com.alibaba.fastjson.asm.Type.getType(ASMUtils.getDesc(itemType)));
        mw.visitMethodInsn(182, ASMUtils.getType(ParserConfig.class), "getDeserializer", "(" + ASMUtils.getDesc(Type.class) + ")" + ASMUtils.getDesc(ObjectDeserializer.class));
        mw.visitFieldInsn(181, context.getClassName(), fieldInfo.getName() + "_asm_list_item_deser__", ASMUtils.getDesc(ObjectDeserializer.class));
        mw.visitLabel(notNull_);
        mw.visitVarInsn(25, context.var("lexer"));
        mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "token", "()I");
        mw.visitFieldInsn(178, ASMUtils.getType(JSONToken.class), "LBRACKET", "I");
        mw.visitJumpInsn(160, reset_);
        mw.visitVarInsn(25, 0);
        mw.visitFieldInsn(180, context.getClassName(), fieldInfo.getName() + "_asm_list_item_deser__", ASMUtils.getDesc(ObjectDeserializer.class));
        mw.visitMethodInsn(185, ASMUtils.getType(ObjectDeserializer.class), "getFastMatchToken", "()I");
        mw.visitVarInsn(54, context.var("fastMatchToken"));
        mw.visitVarInsn(25, context.var("lexer"));
        mw.visitVarInsn(21, context.var("fastMatchToken"));
        mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "nextToken", "(I)V");
        if (fieldClass.isAssignableFrom(ArrayList.class)) {
            mw.visitTypeInsn(187, ASMUtils.getType(ArrayList.class));
            mw.visitInsn(89);
            mw.visitMethodInsn(183, ASMUtils.getType(ArrayList.class), "<init>", "()V");
        } else if (fieldClass.isAssignableFrom(LinkedList.class)) {
            mw.visitTypeInsn(187, ASMUtils.getType(LinkedList.class));
            mw.visitInsn(89);
            mw.visitMethodInsn(183, ASMUtils.getType(LinkedList.class), "<init>", "()V");
        } else if (fieldClass.isAssignableFrom(HashSet.class)) {
            mw.visitTypeInsn(187, ASMUtils.getType(HashSet.class));
            mw.visitInsn(89);
            mw.visitMethodInsn(183, ASMUtils.getType(HashSet.class), "<init>", "()V");
        } else if (fieldClass.isAssignableFrom(TreeSet.class)) {
            mw.visitTypeInsn(187, ASMUtils.getType(TreeSet.class));
            mw.visitInsn(89);
            mw.visitMethodInsn(183, ASMUtils.getType(TreeSet.class), "<init>", "()V");
        } else {
            mw.visitTypeInsn(187, ASMUtils.getType(fieldClass));
            mw.visitInsn(89);
            mw.visitMethodInsn(183, ASMUtils.getType(fieldClass), "<init>", "()V");
        }
        mw.visitTypeInsn(192, ASMUtils.getType(fieldClass));
        mw.visitVarInsn(58, context.var(fieldInfo.getName() + "_asm"));
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, ASMUtils.getType(DefaultJSONParser.class), "getContext", "()Lcom/alibaba/fastjson/parser/ParseContext;");
        mw.visitVarInsn(58, context.var("listContext"));
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, context.var(fieldInfo.getName() + "_asm"));
        mw.visitLdcInsn(fieldInfo.getName());
        mw.visitMethodInsn(182, ASMUtils.getType(DefaultJSONParser.class), "setContext", "(Ljava/lang/Object;Ljava/lang/Object;)Lcom/alibaba/fastjson/parser/ParseContext;");
        mw.visitInsn(87);
        Label loop_ = new Label();
        Label loop_end_ = new Label();
        mw.visitInsn(3);
        mw.visitVarInsn(54, context.var("i"));
        mw.visitLabel(loop_);
        mw.visitVarInsn(25, context.var("lexer"));
        mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "token", "()I");
        mw.visitFieldInsn(178, ASMUtils.getType(JSONToken.class), "RBRACKET", "I");
        mw.visitJumpInsn(159, loop_end_);
        mw.visitVarInsn(25, 0);
        mw.visitFieldInsn(180, context.getClassName(), fieldInfo.getName() + "_asm_list_item_deser__", ASMUtils.getDesc(ObjectDeserializer.class));
        mw.visitVarInsn(25, 1);
        mw.visitInsn(1);
        mw.visitVarInsn(21, context.var("i"));
        mw.visitMethodInsn(184, ASMUtils.getType(Integer.class), "valueOf", "(I)Ljava/lang/Integer;");
        mw.visitMethodInsn(185, ASMUtils.getType(ObjectDeserializer.class), "deserialze", "(Lcom/alibaba/fastjson/parser/DefaultJSONParser;Ljava/lang/reflect/Type;Ljava/lang/Object;)Ljava/lang/Object;");
        mw.visitVarInsn(58, context.var("list_item_value"));
        mw.visitIincInsn(context.var("i"), 1);
        mw.visitVarInsn(25, context.var(fieldInfo.getName() + "_asm"));
        mw.visitVarInsn(25, context.var("list_item_value"));
        if (fieldClass.isInterface()) {
            mw.visitMethodInsn(185, ASMUtils.getType(fieldClass), "add", "(Ljava/lang/Object;)Z");
        } else {
            mw.visitMethodInsn(182, ASMUtils.getType(fieldClass), "add", "(Ljava/lang/Object;)Z");
        }
        mw.visitInsn(87);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, context.var(fieldInfo.getName() + "_asm"));
        mw.visitMethodInsn(182, ASMUtils.getType(DefaultJSONParser.class), "checkListResolve", "(Ljava/util/Collection;)V");
        mw.visitVarInsn(25, context.var("lexer"));
        mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "token", "()I");
        mw.visitFieldInsn(178, ASMUtils.getType(JSONToken.class), "COMMA", "I");
        mw.visitJumpInsn(160, loop_);
        mw.visitVarInsn(25, context.var("lexer"));
        mw.visitVarInsn(21, context.var("fastMatchToken"));
        mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "nextToken", "(I)V");
        mw.visitJumpInsn(167, loop_);
        mw.visitLabel(loop_end_);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, context.var("listContext"));
        mw.visitMethodInsn(182, ASMUtils.getType(DefaultJSONParser.class), "setContext", "(Lcom/alibaba/fastjson/parser/ParseContext;)V");
        mw.visitVarInsn(25, context.var("lexer"));
        mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "token", "()I");
        mw.visitFieldInsn(178, ASMUtils.getType(JSONToken.class), "RBRACKET", "I");
        mw.visitJumpInsn(160, reset_);
        mw.visitVarInsn(25, context.var("lexer"));
        mw.visitFieldInsn(178, ASMUtils.getType(JSONToken.class), "COMMA", "I");
        mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "nextToken", "(I)V");
    }

    private void _deserialze_obj(Context context, MethodVisitor mw, Label reset_, FieldInfo fieldInfo, Class<?> fieldClass) {
        mw.visitMethodInsn(182, ASMUtils.getType(JSONScanner.class), "matchField", "([C)Z");
        mw.visitJumpInsn(153, reset_);
        Label notNull_ = new Label();
        mw.visitVarInsn(25, 0);
        mw.visitFieldInsn(180, context.getClassName(), fieldInfo.getName() + "_asm_deser__", ASMUtils.getDesc(ObjectDeserializer.class));
        mw.visitJumpInsn(199, notNull_);
        mw.visitVarInsn(25, 0);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, ASMUtils.getType(DefaultJSONParser.class), "getConfig", "()" + ASMUtils.getDesc(ParserConfig.class));
        mw.visitLdcInsn(com.alibaba.fastjson.asm.Type.getType(ASMUtils.getDesc(fieldInfo.getFieldClass())));
        mw.visitMethodInsn(182, ASMUtils.getType(ParserConfig.class), "getDeserializer", "(" + ASMUtils.getDesc(Type.class) + ")" + ASMUtils.getDesc(ObjectDeserializer.class));
        mw.visitFieldInsn(181, context.getClassName(), fieldInfo.getName() + "_asm_deser__", ASMUtils.getDesc(ObjectDeserializer.class));
        mw.visitLabel(notNull_);
        mw.visitVarInsn(25, 0);
        mw.visitFieldInsn(180, context.getClassName(), fieldInfo.getName() + "_asm_deser__", ASMUtils.getDesc(ObjectDeserializer.class));
        mw.visitVarInsn(25, 1);
        if (fieldInfo.getFieldType() instanceof Class) {
            mw.visitLdcInsn(com.alibaba.fastjson.asm.Type.getType(ASMUtils.getDesc(fieldInfo.getFieldClass())));
        } else {
            mw.visitVarInsn(25, 0);
            mw.visitLdcInsn(fieldInfo.getName());
            mw.visitMethodInsn(182, ASMUtils.getType(ASMJavaBeanDeserializer.class), "getFieldType", "(Ljava/lang/String;)Ljava/lang/reflect/Type;");
        }
        mw.visitLdcInsn(fieldInfo.getName());
        mw.visitMethodInsn(185, ASMUtils.getType(ObjectDeserializer.class), "deserialze", "(" + ASMUtils.getDesc(DefaultJSONParser.class) + ASMUtils.getDesc(Type.class) + "Ljava/lang/Object;)Ljava/lang/Object;");
        mw.visitTypeInsn(192, ASMUtils.getType(fieldClass));
        mw.visitVarInsn(58, context.var(fieldInfo.getName() + "_asm"));
        Label _end_if = new Label();
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, ASMUtils.getType(DefaultJSONParser.class), "getResolveStatus", "()I");
        mw.visitFieldInsn(178, ASMUtils.getType(DefaultJSONParser.class), "NeedToResolve", "I");
        mw.visitJumpInsn(160, _end_if);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, ASMUtils.getType(DefaultJSONParser.class), "getLastResolveTask", "()" + ASMUtils.getDesc(DefaultJSONParser.ResolveTask.class));
        mw.visitVarInsn(58, context.var("resolveTask"));
        mw.visitVarInsn(25, context.var("resolveTask"));
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, ASMUtils.getType(DefaultJSONParser.class), "getContext", "()" + ASMUtils.getDesc(ParseContext.class));
        mw.visitMethodInsn(182, ASMUtils.getType(DefaultJSONParser.ResolveTask.class), "setOwnerContext", "(" + ASMUtils.getDesc(ParseContext.class) + ")V");
        mw.visitVarInsn(25, context.var("resolveTask"));
        mw.visitVarInsn(25, 0);
        mw.visitLdcInsn(fieldInfo.getName());
        mw.visitMethodInsn(182, ASMUtils.getType(ASMJavaBeanDeserializer.class), "getFieldDeserializer", "(Ljava/lang/String;)" + ASMUtils.getDesc(FieldDeserializer.class));
        mw.visitMethodInsn(182, ASMUtils.getType(DefaultJSONParser.ResolveTask.class), "setFieldDeserializer", "(" + ASMUtils.getDesc(FieldDeserializer.class) + ")V");
        mw.visitVarInsn(25, 1);
        mw.visitFieldInsn(178, ASMUtils.getType(DefaultJSONParser.class), "NONE", "I");
        mw.visitMethodInsn(182, ASMUtils.getType(DefaultJSONParser.class), "setResolveStatus", "(I)V");
        mw.visitLabel(_end_if);
    }

    public FieldDeserializer createFieldDeserializer(ParserConfig mapping, Class<?> clazz, FieldInfo fieldInfo) throws Exception {
        Class<?> fieldClass = fieldInfo.getFieldClass();
        if (fieldClass == Integer.TYPE || fieldClass == Long.TYPE || fieldClass == String.class) {
            return this.createStringFieldDeserializer(mapping, clazz, fieldInfo);
        }
        FieldDeserializer fieldDeserializer = mapping.createFieldDeserializerWithoutASM(mapping, clazz, fieldInfo);
        return fieldDeserializer;
    }

    public FieldDeserializer createStringFieldDeserializer(ParserConfig mapping, Class<?> clazz, FieldInfo fieldInfo) throws Exception {
        Class<?> fieldClass = fieldInfo.getFieldClass();
        Method method = fieldInfo.getMethod();
        String className = this.getGenFieldDeserializer(clazz, fieldInfo);
        ClassWriter cw = new ClassWriter();
        Class superClass = fieldClass == Integer.TYPE ? IntegerFieldDeserializer.class : (fieldClass == Long.TYPE ? LongFieldDeserializer.class : StringFieldDeserializer.class);
        int INVAKE_TYPE = clazz.isInterface() ? 185 : 182;
        cw.visit(49, 33, className, ASMUtils.getType(superClass), null);
        MethodVisitor mw = cw.visitMethod(1, "<init>", "(" + ASMUtils.getDesc(ParserConfig.class) + ASMUtils.getDesc(Class.class) + ASMUtils.getDesc(FieldInfo.class) + ")V", null, null);
        mw.visitVarInsn(25, 0);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, 2);
        mw.visitVarInsn(25, 3);
        mw.visitMethodInsn(183, ASMUtils.getType(superClass), "<init>", "(" + ASMUtils.getDesc(ParserConfig.class) + ASMUtils.getDesc(Class.class) + ASMUtils.getDesc(FieldInfo.class) + ")V");
        mw.visitInsn(177);
        mw.visitMaxs(4, 6);
        mw.visitEnd();
        if (method != null) {
            if (fieldClass == Integer.TYPE) {
                mw = cw.visitMethod(1, "setValue", "(" + ASMUtils.getDesc(Object.class) + "I)V", null, null);
                mw.visitVarInsn(25, 1);
                mw.visitTypeInsn(192, ASMUtils.getType(method.getDeclaringClass()));
                mw.visitVarInsn(21, 2);
                mw.visitMethodInsn(INVAKE_TYPE, ASMUtils.getType(method.getDeclaringClass()), method.getName(), ASMUtils.getDesc(method));
                mw.visitInsn(177);
                mw.visitMaxs(3, 3);
                mw.visitEnd();
            } else if (fieldClass == Long.TYPE) {
                mw = cw.visitMethod(1, "setValue", "(" + ASMUtils.getDesc(Object.class) + "J)V", null, null);
                mw.visitVarInsn(25, 1);
                mw.visitTypeInsn(192, ASMUtils.getType(method.getDeclaringClass()));
                mw.visitVarInsn(22, 2);
                mw.visitMethodInsn(INVAKE_TYPE, ASMUtils.getType(method.getDeclaringClass()), method.getName(), ASMUtils.getDesc(method));
                mw.visitInsn(177);
                mw.visitMaxs(3, 4);
                mw.visitEnd();
            } else {
                mw = cw.visitMethod(1, "setValue", "(" + ASMUtils.getDesc(Object.class) + ASMUtils.getDesc(Object.class) + ")V", null, null);
                mw.visitVarInsn(25, 1);
                mw.visitTypeInsn(192, ASMUtils.getType(method.getDeclaringClass()));
                mw.visitVarInsn(25, 2);
                mw.visitTypeInsn(192, ASMUtils.getType(fieldClass));
                mw.visitMethodInsn(INVAKE_TYPE, ASMUtils.getType(method.getDeclaringClass()), method.getName(), ASMUtils.getDesc(method));
                mw.visitInsn(177);
                mw.visitMaxs(3, 3);
                mw.visitEnd();
            }
        }
        byte[] code = cw.toByteArray();
        Class<?> exampleClass = this.classLoader.defineClassPublic(className, code, 0, code.length);
        Constructor<?> constructor = exampleClass.getConstructor(ParserConfig.class, Class.class, FieldInfo.class);
        Object instance = constructor.newInstance(mapping, clazz, fieldInfo);
        return (FieldDeserializer)instance;
    }

    private void _init(ClassWriter cw, Context context) {
        FieldInfo fieldInfo;
        int i;
        int size = context.getFieldInfoList().size();
        for (i = 0; i < size; ++i) {
            fieldInfo = context.getFieldInfoList().get(i);
            FieldVisitor fw = cw.visitField(1, fieldInfo.getName() + "_asm_prefix__", "[C");
            fw.visitEnd();
        }
        size = context.getFieldInfoList().size();
        for (i = 0; i < size; ++i) {
            FieldVisitor fw;
            fieldInfo = context.getFieldInfoList().get(i);
            Class<?> fieldClass = fieldInfo.getFieldClass();
            if (fieldClass.isPrimitive() || fieldClass.isEnum()) continue;
            if (Collection.class.isAssignableFrom(fieldClass)) {
                fw = cw.visitField(1, fieldInfo.getName() + "_asm_list_item_deser__", ASMUtils.getDesc(ObjectDeserializer.class));
                fw.visitEnd();
                continue;
            }
            fw = cw.visitField(1, fieldInfo.getName() + "_asm_deser__", ASMUtils.getDesc(ObjectDeserializer.class));
            fw.visitEnd();
        }
        MethodVisitor mw = cw.visitMethod(1, "<init>", "(" + ASMUtils.getDesc(ParserConfig.class) + ASMUtils.getDesc(Class.class) + ")V", null, null);
        mw.visitVarInsn(25, 0);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, 2);
        mw.visitMethodInsn(183, ASMUtils.getType(ASMJavaBeanDeserializer.class), "<init>", "(" + ASMUtils.getDesc(ParserConfig.class) + ASMUtils.getDesc(Class.class) + ")V");
        mw.visitVarInsn(25, 0);
        mw.visitFieldInsn(180, ASMUtils.getType(ASMJavaBeanDeserializer.class), "serializer", ASMUtils.getDesc(ASMJavaBeanDeserializer.InnerJavaBeanDeserializer.class));
        mw.visitMethodInsn(182, ASMUtils.getType(JavaBeanDeserializer.class), "getFieldDeserializerMap", "()" + ASMUtils.getDesc(Map.class));
        mw.visitInsn(87);
        int size2 = context.getFieldInfoList().size();
        for (int i2 = 0; i2 < size2; ++i2) {
            FieldInfo fieldInfo2 = context.getFieldInfoList().get(i2);
            mw.visitVarInsn(25, 0);
            mw.visitLdcInsn("\"" + fieldInfo2.getName() + "\":");
            mw.visitMethodInsn(182, ASMUtils.getType(String.class), "toCharArray", "()" + ASMUtils.getDesc(char[].class));
            mw.visitFieldInsn(181, context.getClassName(), fieldInfo2.getName() + "_asm_prefix__", "[C");
        }
        mw.visitInsn(177);
        mw.visitMaxs(4, 4);
        mw.visitEnd();
    }

    private void _createInstance(ClassWriter cw, Context context) {
        MethodVisitor mw = cw.visitMethod(1, "createInstance", "(" + ASMUtils.getDesc(DefaultJSONParser.class) + ASMUtils.getDesc(Type.class) + ")Ljava/lang/Object;", null, null);
        mw.visitTypeInsn(187, ASMUtils.getType(context.getClazz()));
        mw.visitInsn(89);
        mw.visitMethodInsn(183, ASMUtils.getType(context.getClazz()), "<init>", "()V");
        mw.visitInsn(176);
        mw.visitMaxs(3, 3);
        mw.visitEnd();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Context {
        private int variantIndex = 5;
        private Map<String, Integer> variants = new HashMap<String, Integer>();
        private Class<?> clazz;
        private final DeserializeBeanInfo beanInfo;
        private String className;
        private List<FieldInfo> fieldInfoList;

        public Context(String className, ParserConfig config, DeserializeBeanInfo beanInfo, int initVariantIndex) {
            this.className = className;
            this.clazz = beanInfo.getClazz();
            this.variantIndex = initVariantIndex;
            this.beanInfo = beanInfo;
            this.fieldInfoList = new ArrayList<FieldInfo>(beanInfo.getFieldList());
        }

        public String getClassName() {
            return this.className;
        }

        public List<FieldInfo> getFieldInfoList() {
            return this.fieldInfoList;
        }

        public DeserializeBeanInfo getBeanInfo() {
            return this.beanInfo;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public int getVariantCount() {
            return this.variantIndex;
        }

        public int var(String name, int increment) {
            Integer i = this.variants.get(name);
            if (i == null) {
                this.variants.put(name, this.variantIndex);
                this.variantIndex += increment;
            }
            i = this.variants.get(name);
            return i;
        }

        public int var(String name) {
            Integer i = this.variants.get(name);
            if (i == null) {
                this.variants.put(name, this.variantIndex++);
            }
            i = this.variants.get(name);
            return i;
        }
    }
}

