/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.SymbolTable;
import com.alibaba.fastjson.parser.deserializer.ASMDeserializerFactory;
import com.alibaba.fastjson.parser.deserializer.ArrayListTypeFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.AutowiredObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.DefaultFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.EnumDeserializer;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.JavaBeanDeserializer;
import com.alibaba.fastjson.parser.deserializer.JavaObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.Jdk8DateCodec;
import com.alibaba.fastjson.parser.deserializer.MapDeserializer;
import com.alibaba.fastjson.parser.deserializer.NumberDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.OptionalCodec;
import com.alibaba.fastjson.parser.deserializer.SqlDateDeserializer;
import com.alibaba.fastjson.parser.deserializer.StackTraceElementDeserializer;
import com.alibaba.fastjson.parser.deserializer.ThrowableDeserializer;
import com.alibaba.fastjson.parser.deserializer.TimeDeserializer;
import com.alibaba.fastjson.serializer.AtomicCodec;
import com.alibaba.fastjson.serializer.AwtCodec;
import com.alibaba.fastjson.serializer.BigDecimalCodec;
import com.alibaba.fastjson.serializer.BigIntegerCodec;
import com.alibaba.fastjson.serializer.BooleanCodec;
import com.alibaba.fastjson.serializer.CalendarCodec;
import com.alibaba.fastjson.serializer.CharArrayCodec;
import com.alibaba.fastjson.serializer.CharacterCodec;
import com.alibaba.fastjson.serializer.CollectionCodec;
import com.alibaba.fastjson.serializer.DateCodec;
import com.alibaba.fastjson.serializer.FloatCodec;
import com.alibaba.fastjson.serializer.IntegerCodec;
import com.alibaba.fastjson.serializer.LongCodec;
import com.alibaba.fastjson.serializer.MiscCodec;
import com.alibaba.fastjson.serializer.ObjectArrayCodec;
import com.alibaba.fastjson.serializer.ReferenceCodec;
import com.alibaba.fastjson.serializer.StringCodec;
import com.alibaba.fastjson.util.ASMClassLoader;
import com.alibaba.fastjson.util.ASMUtils;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.IOUtils;
import com.alibaba.fastjson.util.IdentityHashMap;
import com.alibaba.fastjson.util.JavaBeanInfo;
import com.alibaba.fastjson.util.ServiceLoader;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.AccessControlException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserConfig {
    public static final String DENY_PROPERTY = "fastjson.parser.deny";
    public static final String[] DENYS = ParserConfig.readSystemDenyPropety();
    public static ParserConfig global = new ParserConfig();
    private final IdentityHashMap<Type, ObjectDeserializer> derializers = new IdentityHashMap();
    private boolean asmEnable = !ASMUtils.IS_ANDROID;
    public final SymbolTable symbolTable = new SymbolTable(4096);
    protected ClassLoader defaultClassLoader;
    protected ASMDeserializerFactory asmFactory;
    private static boolean awtError = false;
    private static boolean jdk8Error = false;
    private String[] denyList = new String[]{"java.lang.Thread"};

    public static ParserConfig getGlobalInstance() {
        return global;
    }

    public ParserConfig() {
        this(null, null);
    }

    public ParserConfig(ClassLoader parentClassLoader) {
        this(null, parentClassLoader);
    }

    public ParserConfig(ASMDeserializerFactory asmFactory) {
        this(asmFactory, null);
    }

    private ParserConfig(ASMDeserializerFactory asmFactory, ClassLoader parentClassLoader) {
        if (asmFactory == null && !ASMUtils.IS_ANDROID) {
            try {
                asmFactory = parentClassLoader == null ? new ASMDeserializerFactory(new ASMClassLoader()) : new ASMDeserializerFactory(parentClassLoader);
            }
            catch (ExceptionInInitializerError error) {
            }
            catch (AccessControlException error) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        this.asmFactory = asmFactory;
        if (asmFactory == null) {
            this.asmEnable = false;
        }
        this.derializers.put((Type)((Object)SimpleDateFormat.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)Timestamp.class), SqlDateDeserializer.instance_timestamp);
        this.derializers.put((Type)((Object)java.sql.Date.class), SqlDateDeserializer.instance);
        this.derializers.put((Type)((Object)Time.class), TimeDeserializer.instance);
        this.derializers.put((Type)((Object)Date.class), DateCodec.instance);
        this.derializers.put((Type)((Object)Calendar.class), CalendarCodec.instance);
        this.derializers.put((Type)((Object)JSONObject.class), MapDeserializer.instance);
        this.derializers.put((Type)((Object)JSONArray.class), CollectionCodec.instance);
        this.derializers.put((Type)((Object)Map.class), MapDeserializer.instance);
        this.derializers.put((Type)((Object)HashMap.class), MapDeserializer.instance);
        this.derializers.put((Type)((Object)LinkedHashMap.class), MapDeserializer.instance);
        this.derializers.put((Type)((Object)TreeMap.class), MapDeserializer.instance);
        this.derializers.put((Type)((Object)ConcurrentMap.class), MapDeserializer.instance);
        this.derializers.put((Type)((Object)ConcurrentHashMap.class), MapDeserializer.instance);
        this.derializers.put((Type)((Object)Collection.class), CollectionCodec.instance);
        this.derializers.put((Type)((Object)List.class), CollectionCodec.instance);
        this.derializers.put((Type)((Object)ArrayList.class), CollectionCodec.instance);
        this.derializers.put((Type)((Object)Object.class), JavaObjectDeserializer.instance);
        this.derializers.put((Type)((Object)String.class), StringCodec.instance);
        this.derializers.put((Type)((Object)StringBuffer.class), StringCodec.instance);
        this.derializers.put((Type)((Object)StringBuilder.class), StringCodec.instance);
        this.derializers.put(Character.TYPE, CharacterCodec.instance);
        this.derializers.put((Type)((Object)Character.class), CharacterCodec.instance);
        this.derializers.put(Byte.TYPE, NumberDeserializer.instance);
        this.derializers.put((Type)((Object)Byte.class), NumberDeserializer.instance);
        this.derializers.put(Short.TYPE, NumberDeserializer.instance);
        this.derializers.put((Type)((Object)Short.class), NumberDeserializer.instance);
        this.derializers.put(Integer.TYPE, IntegerCodec.instance);
        this.derializers.put((Type)((Object)Integer.class), IntegerCodec.instance);
        this.derializers.put(Long.TYPE, LongCodec.instance);
        this.derializers.put((Type)((Object)Long.class), LongCodec.instance);
        this.derializers.put((Type)((Object)BigInteger.class), BigIntegerCodec.instance);
        this.derializers.put((Type)((Object)BigDecimal.class), BigDecimalCodec.instance);
        this.derializers.put(Float.TYPE, FloatCodec.instance);
        this.derializers.put((Type)((Object)Float.class), FloatCodec.instance);
        this.derializers.put(Double.TYPE, NumberDeserializer.instance);
        this.derializers.put((Type)((Object)Double.class), NumberDeserializer.instance);
        this.derializers.put(Boolean.TYPE, BooleanCodec.instance);
        this.derializers.put((Type)((Object)Boolean.class), BooleanCodec.instance);
        this.derializers.put((Type)((Object)Class.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)char[].class), new CharArrayCodec());
        this.derializers.put((Type)((Object)AtomicBoolean.class), BooleanCodec.instance);
        this.derializers.put((Type)((Object)AtomicInteger.class), IntegerCodec.instance);
        this.derializers.put((Type)((Object)AtomicLong.class), LongCodec.instance);
        this.derializers.put((Type)((Object)AtomicReference.class), ReferenceCodec.instance);
        this.derializers.put((Type)((Object)WeakReference.class), ReferenceCodec.instance);
        this.derializers.put((Type)((Object)SoftReference.class), ReferenceCodec.instance);
        this.derializers.put((Type)((Object)UUID.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)TimeZone.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)Locale.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)Currency.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)InetAddress.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)Inet4Address.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)Inet6Address.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)InetSocketAddress.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)File.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)URI.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)URL.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)Pattern.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)Charset.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)JSONPath.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)Number.class), NumberDeserializer.instance);
        this.derializers.put((Type)((Object)AtomicIntegerArray.class), AtomicCodec.instance);
        this.derializers.put((Type)((Object)AtomicLongArray.class), AtomicCodec.instance);
        this.derializers.put((Type)((Object)StackTraceElement.class), StackTraceElementDeserializer.instance);
        this.derializers.put((Type)((Object)Serializable.class), JavaObjectDeserializer.instance);
        this.derializers.put((Type)((Object)Cloneable.class), JavaObjectDeserializer.instance);
        this.derializers.put((Type)((Object)Comparable.class), JavaObjectDeserializer.instance);
        this.derializers.put((Type)((Object)Closeable.class), JavaObjectDeserializer.instance);
        this.addDeny("java.lang.Thread");
        this.addItemsToDeny(DENYS);
    }

    private static String[] splitItemsFormProperty(String property) {
        if (property != null && property.length() > 0) {
            return property.split(",");
        }
        return null;
    }

    public void configFromPropety(Properties properties) {
        String property = properties.getProperty(DENY_PROPERTY);
        String[] items = ParserConfig.splitItemsFormProperty(property);
        this.addItemsToDeny(items);
    }

    private void addItemsToDeny(String[] items) {
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                String item = items[i];
                this.addDeny(item);
            }
        }
    }

    public static String[] readSystemDenyPropety() {
        String property = IOUtils.getStringProperty(DENY_PROPERTY);
        return ParserConfig.splitItemsFormProperty(property);
    }

    public boolean isAsmEnable() {
        return this.asmEnable;
    }

    public void setAsmEnable(boolean asmEnable) {
        this.asmEnable = asmEnable;
    }

    public IdentityHashMap<Type, ObjectDeserializer> getDerializers() {
        return this.derializers;
    }

    public ObjectDeserializer getDeserializer(Type type) {
        ObjectDeserializer derializer = this.derializers.get(type);
        if (derializer != null) {
            return derializer;
        }
        if (type instanceof Class) {
            return this.getDeserializer((Class)type, type);
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            if (rawType instanceof Class) {
                return this.getDeserializer((Class)rawType, type);
            }
            return this.getDeserializer(rawType);
        }
        return JavaObjectDeserializer.instance;
    }

    public ObjectDeserializer getDeserializer(Class<?> clazz, Type type) {
        Class<?> mappingTo;
        ObjectDeserializer derializer = this.derializers.get(type);
        if (derializer != null) {
            return derializer;
        }
        if (type == null) {
            type = clazz;
        }
        if ((derializer = this.derializers.get(type)) != null) {
            return derializer;
        }
        JSONType annotation = clazz.getAnnotation(JSONType.class);
        if (annotation != null && (mappingTo = annotation.mappingTo()) != Void.class) {
            return this.getDeserializer(mappingTo, mappingTo);
        }
        if (type instanceof WildcardType || type instanceof TypeVariable || type instanceof ParameterizedType) {
            derializer = this.derializers.get(clazz);
        }
        if (derializer != null) {
            return derializer;
        }
        String className = clazz.getName();
        className = className.replace('$', '.');
        for (int i = 0; i < this.denyList.length; ++i) {
            String deny = this.denyList[i];
            if (!className.startsWith(deny)) continue;
            throw new JSONException("parser deny : " + className);
        }
        if (className.startsWith("java.awt.") && AwtCodec.support(clazz) && !awtError) {
            try {
                this.derializers.put(Class.forName("java.awt.Point"), AwtCodec.instance);
                this.derializers.put(Class.forName("java.awt.Font"), AwtCodec.instance);
                this.derializers.put(Class.forName("java.awt.Rectangle"), AwtCodec.instance);
                this.derializers.put(Class.forName("java.awt.Color"), AwtCodec.instance);
            }
            catch (Throwable e) {
                awtError = true;
            }
            derializer = AwtCodec.instance;
        }
        if (!jdk8Error) {
            try {
                if (className.startsWith("java.time.")) {
                    this.derializers.put(Class.forName("java.time.LocalDateTime"), Jdk8DateCodec.instance);
                    this.derializers.put(Class.forName("java.time.LocalDate"), Jdk8DateCodec.instance);
                    this.derializers.put(Class.forName("java.time.LocalTime"), Jdk8DateCodec.instance);
                    this.derializers.put(Class.forName("java.time.ZonedDateTime"), Jdk8DateCodec.instance);
                    this.derializers.put(Class.forName("java.time.OffsetDateTime"), Jdk8DateCodec.instance);
                    this.derializers.put(Class.forName("java.time.OffsetTime"), Jdk8DateCodec.instance);
                    this.derializers.put(Class.forName("java.time.ZoneOffset"), Jdk8DateCodec.instance);
                    this.derializers.put(Class.forName("java.time.ZoneRegion"), Jdk8DateCodec.instance);
                    this.derializers.put(Class.forName("java.time.ZoneId"), Jdk8DateCodec.instance);
                    this.derializers.put(Class.forName("java.time.Period"), Jdk8DateCodec.instance);
                    this.derializers.put(Class.forName("java.time.Duration"), Jdk8DateCodec.instance);
                    this.derializers.put(Class.forName("java.time.Instant"), Jdk8DateCodec.instance);
                    derializer = this.derializers.get(clazz);
                } else if (className.startsWith("java.util.Optional")) {
                    this.derializers.put(Class.forName("java.util.Optional"), OptionalCodec.instance);
                    this.derializers.put(Class.forName("java.util.OptionalDouble"), OptionalCodec.instance);
                    this.derializers.put(Class.forName("java.util.OptionalInt"), OptionalCodec.instance);
                    this.derializers.put(Class.forName("java.util.OptionalLong"), OptionalCodec.instance);
                    derializer = this.derializers.get(clazz);
                }
            }
            catch (Throwable e) {
                jdk8Error = true;
            }
        }
        if (className.equals("java.nio.file.Path")) {
            this.derializers.put(clazz, MiscCodec.instance);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            for (AutowiredObjectDeserializer autowired : ServiceLoader.load(AutowiredObjectDeserializer.class, classLoader)) {
                for (Type forType : autowired.getAutowiredFor()) {
                    this.derializers.put(forType, autowired);
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (derializer == null) {
            derializer = this.derializers.get(type);
        }
        if (derializer != null) {
            return derializer;
        }
        derializer = clazz.isEnum() ? new EnumDeserializer(clazz) : (clazz.isArray() ? ObjectArrayCodec.instance : (clazz == Set.class || clazz == HashSet.class || clazz == Collection.class || clazz == List.class || clazz == ArrayList.class ? CollectionCodec.instance : (Collection.class.isAssignableFrom(clazz) ? CollectionCodec.instance : (Map.class.isAssignableFrom(clazz) ? MapDeserializer.instance : (Throwable.class.isAssignableFrom(clazz) ? new ThrowableDeserializer(this, clazz) : this.createJavaBeanDeserializer(clazz, type))))));
        this.putDeserializer(type, derializer);
        return derializer;
    }

    public ObjectDeserializer createJavaBeanDeserializer(Class<?> clazz, Type type) {
        JavaBeanInfo beanInfo;
        boolean asmEnable = this.asmEnable;
        if (asmEnable) {
            JSONType jsonType = clazz.getAnnotation(JSONType.class);
            if (jsonType != null && !jsonType.asm()) {
                asmEnable = false;
            }
            if (asmEnable) {
                Class<?> superClass = JavaBeanInfo.getBuilderClass(jsonType);
                if (superClass == null) {
                    superClass = clazz;
                }
                do {
                    if (Modifier.isPublic(superClass.getModifiers())) continue;
                    asmEnable = false;
                    break;
                } while ((superClass = superClass.getSuperclass()) != Object.class && superClass != null);
            }
        }
        if (clazz.getTypeParameters().length != 0) {
            asmEnable = false;
        }
        if (asmEnable && this.asmFactory != null && this.asmFactory.classLoader.isExternalClass(clazz)) {
            asmEnable = false;
        }
        if (asmEnable) {
            asmEnable = ASMUtils.checkName(clazz.getName());
        }
        if (asmEnable) {
            if (clazz.isInterface()) {
                asmEnable = false;
            }
            beanInfo = JavaBeanInfo.build(clazz, type);
            if (asmEnable && beanInfo.fields.length > 200) {
                asmEnable = false;
            }
            Constructor<?> defaultConstructor = beanInfo.defaultConstructor;
            if (asmEnable && defaultConstructor == null && !clazz.isInterface()) {
                asmEnable = false;
            }
            for (FieldInfo fieldInfo : beanInfo.fields) {
                ObjectDeserializer fieldDeser;
                if (fieldInfo.getOnly) {
                    asmEnable = false;
                    break;
                }
                Class<?> fieldClass = fieldInfo.fieldClass;
                if (!Modifier.isPublic(fieldClass.getModifiers())) {
                    asmEnable = false;
                    break;
                }
                if (fieldClass.isMemberClass() && !Modifier.isStatic(fieldClass.getModifiers())) {
                    asmEnable = false;
                    break;
                }
                if (fieldInfo.getMember() != null && !ASMUtils.checkName(fieldInfo.getMember().getName())) {
                    asmEnable = false;
                    break;
                }
                JSONField annotation = fieldInfo.getAnnotation();
                if (!(annotation == null || ASMUtils.checkName(annotation.name()) && annotation.format().length() == 0)) {
                    asmEnable = false;
                    break;
                }
                if (!fieldClass.isEnum() || (fieldDeser = this.getDeserializer(fieldClass)) instanceof EnumDeserializer) continue;
                asmEnable = false;
                break;
            }
        }
        if (asmEnable && clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers())) {
            asmEnable = false;
        }
        if (!asmEnable) {
            return new JavaBeanDeserializer(this, clazz, type);
        }
        beanInfo = JavaBeanInfo.build(clazz, type);
        try {
            return this.asmFactory.createJavaBeanDeserializer(this, beanInfo);
        }
        catch (NoSuchMethodException ex) {
            return new JavaBeanDeserializer(this, clazz, type);
        }
        catch (JSONException asmError) {
            return new JavaBeanDeserializer(this, beanInfo);
        }
        catch (Exception e) {
            throw new JSONException("create asm deserializer error, " + clazz.getName(), e);
        }
    }

    public FieldDeserializer createFieldDeserializer(ParserConfig mapping, JavaBeanInfo beanInfo, FieldInfo fieldInfo) {
        Class<?> clazz = beanInfo.clazz;
        Class<?> fieldClass = fieldInfo.fieldClass;
        if (fieldClass == List.class || fieldClass == ArrayList.class) {
            return new ArrayListTypeFieldDeserializer(mapping, clazz, fieldInfo);
        }
        return new DefaultFieldDeserializer(mapping, clazz, fieldInfo);
    }

    public void putDeserializer(Type type, ObjectDeserializer deserializer) {
        this.derializers.put(type, deserializer);
    }

    public ObjectDeserializer getDeserializer(FieldInfo fieldInfo) {
        return this.getDeserializer(fieldInfo.fieldClass, fieldInfo.fieldType);
    }

    public static boolean isPrimitive(Class<?> clazz) {
        return clazz.isPrimitive() || clazz == Boolean.class || clazz == Character.class || clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == BigInteger.class || clazz == BigDecimal.class || clazz == String.class || clazz == Date.class || clazz == java.sql.Date.class || clazz == Time.class || clazz == Timestamp.class || clazz.isEnum();
    }

    public static void parserAllFieldToCache(Class<?> clazz, Map<String, Field> fieldCacheMap) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            String fieldName = field.getName();
            if (fieldCacheMap.containsKey(fieldName)) continue;
            fieldCacheMap.put(fieldName, field);
        }
        if (clazz.getSuperclass() != null && clazz.getSuperclass() != Object.class) {
            ParserConfig.parserAllFieldToCache(clazz.getSuperclass(), fieldCacheMap);
        }
    }

    public static Field getFieldFromCache(String fieldName, Map<String, Field> fieldCacheMap) {
        Field field = fieldCacheMap.get(fieldName);
        if (field == null) {
            field = fieldCacheMap.get("_" + fieldName);
        }
        if (field == null) {
            field = fieldCacheMap.get("m_" + fieldName);
        }
        return field;
    }

    public ClassLoader getDefaultClassLoader() {
        return this.defaultClassLoader;
    }

    public void setDefaultClassLoader(ClassLoader defaultClassLoader) {
        this.defaultClassLoader = defaultClassLoader;
    }

    public void addDeny(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        String[] denyList = new String[this.denyList.length + 1];
        System.arraycopy(this.denyList, 0, denyList, 0, this.denyList.length);
        denyList[denyList.length - 1] = name;
        this.denyList = denyList;
    }
}

