/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.spring.data.mongodb;

import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.annotation.JSONCreator;
import com.alibaba.fastjson2.annotation.JSONField;
import com.alibaba.fastjson2.annotation.JSONType;
import com.alibaba.fastjson2.modules.ObjectReaderModule;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.support.spring.data.mongodb.GeoJsonPointReader;
import com.alibaba.fastjson2.support.spring.data.mongodb.GeoJsonPolygonReader;
import java.util.List;
import org.springframework.data.geo.Point;
import org.springframework.data.mongodb.core.geo.GeoJsonLineString;
import org.springframework.data.mongodb.core.geo.GeoJsonMultiPoint;
import org.springframework.data.mongodb.core.geo.GeoJsonPoint;
import org.springframework.data.mongodb.core.geo.GeoJsonPolygon;

public class GeoJsonReaderModule
implements ObjectReaderModule {
    public static final GeoJsonReaderModule INSTANCE = new GeoJsonReaderModule();

    public void init(ObjectReaderProvider provider) {
        provider.mixIn(Point.class, PointMixin.class);
        provider.mixIn(GeoJsonLineString.class, GeoJsonLineStringMixin.class);
        provider.mixIn(GeoJsonMultiPoint.class, GeoJsonMultiPointMixin.class);
        provider.register(GeoJsonPoint.class, (ObjectReader)GeoJsonPointReader.INSTANCE);
        provider.register(GeoJsonPolygon.class, (ObjectReader)GeoJsonPolygonReader.INSTANCE);
    }

    @JSONType(deserializeFeatures={JSONReader.Feature.SupportArrayToBean})
    static class PointMixin {
        @JSONCreator(parameterNames={"x", "y"})
        public PointMixin(double x, double y) {
        }
    }

    @JSONType(typeKey="type", typeName="LineString", deserializeFeatures={JSONReader.Feature.SupportArrayToBean})
    static abstract class GeoJsonLineStringMixin {
        @JSONCreator(parameterNames={"coordinates"})
        public GeoJsonLineStringMixin(List<Point> points) {
        }

        @JSONField(deserialize=false)
        public abstract List<Point> getCoordinates();
    }

    @JSONType(typeKey="type", typeName="MultiPoint", deserializeFeatures={JSONReader.Feature.SupportArrayToBean})
    static abstract class GeoJsonMultiPointMixin {
        @JSONCreator(parameterNames={"coordinates"})
        public GeoJsonMultiPointMixin(List<Point> points) {
        }

        @JSONField(deserialize=false)
        public abstract List<Point> getCoordinates();
    }
}

