/*
 *  Copyright 1999-2018 Alibaba Group Holding Ltd.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package com.alibaba.fescar.discovery.loadbalance;

import java.util.List;
import java.util.Random;

import com.alibaba.fescar.common.loader.LoadLevel;

/**
 * The type Random load balance.
 *
 * @author yuoyao
 * @date 2019 /02/14
 */
@LoadLevel(name = "RandomLoadBalance", order = 2)
public class RandomLoadBalance extends AbstractLoadBalance {

    private final Random random = new Random();

    @Override
    protected <T> T doSelect(List<T> invokers) {
        int length = invokers.size();
        return invokers.get(random.nextInt(length));
    }
}
