/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.rm;

import com.alibaba.fescar.common.exception.FrameworkException;
import com.alibaba.fescar.common.loader.EnhancedServiceLoader;
import com.alibaba.fescar.common.util.CollectionUtils;
import com.alibaba.fescar.core.exception.TransactionException;
import com.alibaba.fescar.core.model.BranchStatus;
import com.alibaba.fescar.core.model.BranchType;
import com.alibaba.fescar.core.model.Resource;
import com.alibaba.fescar.core.model.ResourceManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultResourceManager
implements ResourceManager {
    protected static Map<BranchType, ResourceManager> resourceManagers = new ConcurrentHashMap<BranchType, ResourceManager>();

    private DefaultResourceManager() {
        this.initResourceManagers();
    }

    public static DefaultResourceManager get() {
        return SingletonHolder.INSTANCE;
    }

    public static void mockResourceManager(BranchType branchType, ResourceManager rm) {
        resourceManagers.put(branchType, rm);
    }

    protected void initResourceManagers() {
        List allResourceManagers = EnhancedServiceLoader.loadAll(ResourceManager.class);
        if (CollectionUtils.isNotEmpty((Collection)allResourceManagers)) {
            for (ResourceManager rm : allResourceManagers) {
                resourceManagers.put(rm.getBranchType(), rm);
            }
        }
    }

    public BranchStatus branchCommit(BranchType branchType, String xid, long branchId, String resourceId, String applicationData) throws TransactionException {
        return this.getResourceManager(branchType).branchCommit(branchType, xid, branchId, resourceId, applicationData);
    }

    public BranchStatus branchRollback(BranchType branchType, String xid, long branchId, String resourceId, String applicationData) throws TransactionException {
        return this.getResourceManager(branchType).branchRollback(branchType, xid, branchId, resourceId, applicationData);
    }

    public Long branchRegister(BranchType branchType, String resourceId, String clientId, String xid, String applicationData, String lockKeys) throws TransactionException {
        return this.getResourceManager(branchType).branchRegister(branchType, resourceId, clientId, xid, applicationData, lockKeys);
    }

    public void branchReport(BranchType branchType, String xid, long branchId, BranchStatus status, String applicationData) throws TransactionException {
        this.getResourceManager(branchType).branchReport(branchType, xid, branchId, status, applicationData);
    }

    public boolean lockQuery(BranchType branchType, String resourceId, String xid, String lockKeys) throws TransactionException {
        return this.getResourceManager(branchType).lockQuery(branchType, resourceId, xid, lockKeys);
    }

    public void registerResource(Resource resource) {
        this.getResourceManager(resource.getBranchType()).registerResource(resource);
    }

    public void unregisterResource(Resource resource) {
        this.getResourceManager(resource.getBranchType()).unregisterResource(resource);
    }

    public Map<String, Resource> getManagedResources() {
        HashMap<String, Resource> allResource = new HashMap<String, Resource>();
        for (ResourceManager rm : resourceManagers.values()) {
            Map tempResources = rm.getManagedResources();
            if (tempResources == null) continue;
            allResource.putAll(tempResources);
        }
        return allResource;
    }

    public ResourceManager getResourceManager(BranchType branchType) {
        ResourceManager rm = resourceManagers.get(branchType);
        if (rm == null) {
            throw new FrameworkException("No ResourceManager for BranchType:" + branchType.name());
        }
        return rm;
    }

    public BranchType getBranchType() {
        throw new FrameworkException("DefaultResourceManager isn't a real ResourceManager");
    }

    private static class SingletonHolder {
        private static DefaultResourceManager INSTANCE = new DefaultResourceManager();

        private SingletonHolder() {
        }
    }
}

