/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.client;

import com.alibaba.hbase.client.AliHBaseAPIProxy;
import com.alibaba.hbase.client.AliHBaseConstants;
import com.alibaba.hbase.client.AliHBaseDirectImplFactory;
import com.alibaba.hbase.client.AliHBaseUEAggregateService;
import com.alibaba.hbase.client.ElementConvertor;
import com.alibaba.hbase.exception.BatchExceptions;
import com.alibaba.lindorm.client.WideColumnService;
import com.alibaba.lindorm.client.core.meta.ExternalIndexConfig;
import com.alibaba.lindorm.client.core.meta.ExternalIndexField;
import com.alibaba.lindorm.client.core.meta.TableState;
import com.alibaba.lindorm.client.core.tableservice.EmptyResult;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.core.widecolumnservice.WAppend;
import com.alibaba.lindorm.client.core.widecolumnservice.WDelete;
import com.alibaba.lindorm.client.core.widecolumnservice.WGet;
import com.alibaba.lindorm.client.core.widecolumnservice.WIncrement;
import com.alibaba.lindorm.client.core.widecolumnservice.WPut;
import com.alibaba.lindorm.client.core.widecolumnservice.WResult;
import com.alibaba.lindorm.client.core.widecolumnservice.WRowMutations;
import com.alibaba.lindorm.client.core.widecolumnservice.WScan;
import com.alibaba.lindorm.client.core.widecolumnservice.WScanner;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WCompareFilter;
import com.alibaba.lindorm.client.schema.IndexState;
import com.alibaba.lindorm.client.schema.LindormFamilyAttributes;
import com.alibaba.lindorm.client.schema.LindormIndexDescriptor;
import com.alibaba.lindorm.client.schema.LindormTableDescriptor;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.client.index.AliHBaseIndexDescriptor;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.protobuf.generated.AggregateProtos;
import org.apache.hadoop.hbase.util.Bytes;

public class AliHBaseAPIProxyDirectImpl
implements AliHBaseAPIProxy {
    private boolean isSupportBatchAppendIncrement = true;
    private AliHBaseDirectImplFactory factory;
    private TableName myTableName;
    private int defaultScannerCaching;
    private WideColumnService wideColumnService;
    private String tableNameWithoutNamespace;
    private boolean isMergeEnabled = false;

    public AliHBaseAPIProxyDirectImpl(AliHBaseDirectImplFactory factory, TableName tableName) throws IOException {
        this.factory = factory;
        this.myTableName = tableName;
        this.defaultScannerCaching = factory.getConf().getInt("hbase.client.scanner.caching", 1000);
        if (this.defaultScannerCaching > 1000) {
            this.defaultScannerCaching = 1000;
        }
        if (this.myTableName != null) {
            this.wideColumnService = factory.getWideColumnService(this.myTableName.getNamespaceAsString());
            this.tableNameWithoutNamespace = this.myTableName.getQualifierAsString();
        }
        this.isMergeEnabled = factory.getConf().getBoolean("hbase.client.merge.enabled", true);
    }

    @Override
    public boolean tableExists(TableName tableName) throws IOException {
        try {
            return !TableState.TABLE_NOT_EXIST.equals(this.factory.getWideColumnService(tableName.getNamespaceAsString()).getTableState(tableName.getQualifierAsString()));
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public List<HTableDescriptor> listTableDescriptors() throws IOException {
        try {
            TableName[] tableNames = this.listTableNames();
            ArrayList<HTableDescriptor> tableDescriptors = new ArrayList<HTableDescriptor>();
            for (TableName tableName : tableNames) {
                HTableDescriptor tableDescriptor = this.getDescriptor(tableName);
                tableDescriptors.add(tableDescriptor);
            }
            return tableDescriptors;
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public TableName[] listTableNames() throws IOException {
        try {
            List<String> tables = this.factory.getAdminService().listTableNamesByPrefix("");
            TableName[] tableNames = new TableName[tables.size()];
            for (int i = 0; i < tables.size(); ++i) {
                tableNames[i] = ElementConvertor.toHBaseTableName(tables.get(i));
            }
            return tableNames;
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public HTableDescriptor getDescriptor(TableName tableName) throws IOException {
        try {
            LindormTableDescriptor lindormTableDescriptor = this.factory.getWideColumnService(tableName.getNamespaceAsString()).describeTable(tableName.getQualifierAsString());
            return ElementConvertor.toHbaseTableDescriptor(tableName.getNamespaceAsString(), lindormTableDescriptor);
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public TableName[] listTableNamesByNamespace(String name) throws IOException {
        try {
            List<String> tables = this.factory.getWideColumnService(name).listTables();
            TableName[] tableNames = new TableName[tables.size()];
            for (int i = 0; i < tables.size(); ++i) {
                tableNames[i] = TableName.valueOf((String)name, (String)tables.get(i));
            }
            return tableNames;
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public List<HTableDescriptor> listTableDescriptorsByNamespace(String name) throws IOException {
        try {
            TableName[] tableNames = this.listTableNamesByNamespace(name);
            ArrayList<HTableDescriptor> descriptors = new ArrayList<HTableDescriptor>();
            for (TableName tableName : tableNames) {
                descriptors.add(this.getDescriptor(tableName));
            }
            return descriptors;
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public void createTable(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        try {
            LindormTableDescriptor lindormTableDescriptor = ElementConvertor.toLindormTableDescripter(desc, false);
            TableName tableName = desc.getTableName();
            this.factory.getWideColumnService(tableName.getNamespaceAsString()).createTable(lindormTableDescriptor, splitKeys);
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public void deleteTable(TableName tableName) throws IOException {
        try {
            this.factory.getWideColumnService(tableName.getNamespaceAsString()).deleteTable(tableName.getQualifierAsString());
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public void truncateTable(TableName tableName, boolean preserveSplits) throws IOException {
        try {
            this.factory.getWideColumnService(tableName.getNamespaceAsString()).truncateTable(tableName.getQualifierAsString(), preserveSplits);
        }
        catch (IOException e) {
            if (e.getMessage().contains("NoSuchMethodException")) {
                try {
                    this.factory.getWideColumnService(tableName.getNamespaceAsString()).truncateTable(tableName.getQualifierAsString());
                }
                catch (IOException e1) {
                    throw ElementConvertor.toHBaseIOException(e1);
                }
            }
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public void enableTable(TableName tableName) throws IOException {
        try {
            this.factory.getWideColumnService(tableName.getNamespaceAsString()).onlineTable(tableName.getQualifierAsString());
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public void disableTable(TableName tableName) throws IOException {
        try {
            this.factory.getWideColumnService(tableName.getNamespaceAsString()).offlineTable(tableName.getQualifierAsString());
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public boolean isTableEnabled(TableName tableName) throws IOException {
        try {
            return this.factory.getWideColumnService(tableName.getNamespaceAsString()).isTableOnline(tableName.getQualifierAsString());
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public boolean isTableDisabled(TableName tableName) throws IOException {
        try {
            return this.factory.getWideColumnService(tableName.getNamespaceAsString()).isTableOffline(tableName.getQualifierAsString());
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public boolean isTableAvailable(TableName tableName) throws IOException {
        try {
            return this.isTableEnabled(tableName);
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public void addColumnFamily(TableName tableName, HColumnDescriptor columnFamily) throws IOException {
        try {
            this.factory.getWideColumnService(tableName.getNamespaceAsString()).addFamily(tableName.getQualifierAsString(), ElementConvertor.toLindormcolumnFamilyDescriptor(columnFamily, false));
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public void deleteColumnFamily(TableName tableName, byte[] columnFamily) throws IOException {
        try {
            this.factory.getWideColumnService(tableName.getNamespaceAsString()).deleteFamily(tableName.getQualifierAsString(), Bytes.toString((byte[])columnFamily));
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public void modifyColumnFamily(TableName tableName, HColumnDescriptor columnFamily) throws IOException {
        try {
            List<LindormFamilyAttributes> lindormFamilyAttributes = ElementConvertor.toLindormFamilyAttributes(columnFamily, false);
            this.factory.getWideColumnService(tableName.getNamespaceAsString()).modifyFamilyAttributes(tableName.getQualifierAsString(), lindormFamilyAttributes);
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public void modifyTable(HTableDescriptor td) throws IOException {
        try {
            byte[] isTableServiceBytes = td.getValue(AliHBaseConstants.TABLESERVICE_ATTRIBUTES_KEY_BYTES);
            boolean isTableService = false;
            if (isTableServiceBytes != null) {
                isTableService = Bytes.toBoolean((byte[])isTableServiceBytes);
            }
            LindormTableDescriptor lindormTableDescriptor = ElementConvertor.toLindormTableDescripter(td, false);
            if (isTableService) {
                this.factory.getTableServiceService(td.getTableName().getNamespaceAsString()).modifyTableAttributes(lindormTableDescriptor);
            } else {
                this.factory.getWideColumnService(td.getTableName().getNamespaceAsString()).modifyTableAttributes(lindormTableDescriptor);
            }
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public void deleteNamespace(String name) throws IOException {
        try {
            this.factory.getAdminService().removeNamespace(name);
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public NamespaceDescriptor getNamespaceDescriptor(String name) throws NamespaceNotFoundException, IOException {
        try {
            if (this.factory.getAdminService().listNamespaces().contains(name)) {
                return NamespaceDescriptor.create((String)name).build();
            }
            throw new NamespaceNotFoundException(name + " is not found");
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public NamespaceDescriptor[] listNamespaceDescriptors() throws IOException {
        try {
            List<String> namespaces = this.factory.getAdminService().listNamespaces();
            NamespaceDescriptor[] namespaceDescriptors = new NamespaceDescriptor[namespaces.size()];
            for (int i = 0; i < namespaces.size(); ++i) {
                namespaceDescriptors[i] = NamespaceDescriptor.create((String)namespaces.get(i)).build();
            }
            return namespaceDescriptors;
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public void createNamespace(NamespaceDescriptor descriptor) throws IOException {
        try {
            this.factory.getAdminService().createNamespace(descriptor.getName());
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public void flushRegion(String regionName) {
        try {
            for (String idc : this.factory.getSystemService().getLConnection().getAllIDC()) {
                this.factory.getSystemService().flush(regionName, idc);
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    @Override
    public void compactRegion(String regionName) {
        try {
            for (String idc : this.factory.getSystemService().getLConnection().getAllIDC()) {
                this.factory.getSystemService().compact(regionName, idc);
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    @Override
    public void majorCompactRegion(String regionName) {
        try {
            for (String idc : this.factory.getSystemService().getLConnection().getAllIDC()) {
                this.factory.getSystemService().majorCompact(regionName, idc);
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    @Override
    public void flushTable(TableName tableName) {
        String table = ElementConvertor.toLindormTableFullName(tableName);
        try {
            for (String idc : this.factory.getSystemService().getLConnection().getAllIDC()) {
                this.factory.getSystemService().flush(table, idc);
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    @Override
    public void compactTable(TableName tableName) {
        String table = ElementConvertor.toLindormTableFullName(tableName);
        try {
            for (String idc : this.factory.getSystemService().getLConnection().getAllIDC()) {
                this.factory.getSystemService().compact(table, idc);
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    @Override
    public void majorCompactTable(TableName tableName) {
        String table = ElementConvertor.toLindormTableFullName(tableName);
        try {
            for (String idc : this.factory.getSystemService().getLConnection().getAllIDC()) {
                this.factory.getSystemService().majorCompact(table, idc);
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    @Override
    public void split(String tableNameOrRegionName, byte[] splitPoint) {
        try {
            for (String idc : this.factory.getSystemService().getLConnection().getAllIDC()) {
                this.factory.getSystemService().splitTableOrRegion(tableNameOrRegionName, splitPoint, idc);
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    @Override
    public void mergeRegions(String tableNameA, String shortNameA, String shortNameB) {
        if (!this.isMergeEnabled) {
            return;
        }
        try {
            for (String idc : this.factory.getSystemService().getLConnection().getAllIDC()) {
                this.factory.getSystemService().mergeRegions(tableNameA, shortNameA, shortNameB, idc);
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    private HRegionLocation createFakeRegionLocation(byte[] startKey, byte[] endKey) {
        HRegionInfo regionInfo = new HRegionInfo(this.myTableName, startKey, endKey);
        return new HRegionLocation(regionInfo, ServerName.valueOf((String)"localhost", (int)0, (long)0L));
    }

    private org.apache.hadoop.hbase.util.Pair<byte[], byte[]> getStartEndKey(byte[] row) throws IOException {
        byte[][] endKeys = (byte[][])this.getStartEndKeys().getSecond();
        if (endKeys.length == 1) {
            return new org.apache.hadoop.hbase.util.Pair((Object)HConstants.EMPTY_START_ROW, (Object)HConstants.EMPTY_START_ROW);
        }
        byte[] preStartKey = HConstants.EMPTY_START_ROW;
        for (byte[] endKey : endKeys) {
            if (Bytes.compareTo((byte[])row, (byte[])endKey) < 0) {
                return new org.apache.hadoop.hbase.util.Pair((Object)preStartKey, (Object)endKey);
            }
            preStartKey = endKey;
        }
        return new org.apache.hadoop.hbase.util.Pair((Object)endKeys[endKeys.length - 2], (Object)HConstants.EMPTY_START_ROW);
    }

    @Override
    public HRegionLocation getRegionLocation(byte[] row) throws IOException {
        try {
            org.apache.hadoop.hbase.util.Pair<byte[], byte[]> startEndKey = this.getStartEndKey(row);
            return this.createFakeRegionLocation((byte[])startEndKey.getFirst(), (byte[])startEndKey.getSecond());
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public List<HRegionLocation> getAllRegionLocations() throws IOException {
        try {
            ArrayList<HRegionLocation> fakeRegionLocations = new ArrayList<HRegionLocation>();
            byte[] preStartKey = HConstants.EMPTY_START_ROW;
            byte[][] endKeys = (byte[][])this.getStartEndKeys().getSecond();
            for (int i = 0; i < endKeys.length; ++i) {
                byte[] endKey = endKeys[i];
                fakeRegionLocations.add(this.createFakeRegionLocation(preStartKey, endKey));
                preStartKey = endKey;
            }
            return fakeRegionLocations;
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public org.apache.hadoop.hbase.util.Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        try {
            Pair<byte[][], byte[][]> pair = this.wideColumnService.getStartEndKeys(this.tableNameWithoutNamespace);
            return new org.apache.hadoop.hbase.util.Pair((Object)pair.getFirst(), (Object)pair.getSecond());
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public boolean exists(Get get2) throws IOException {
        try {
            WGet wGet = ElementConvertor.toLindormGet(get2);
            return this.wideColumnService.exists(this.tableNameWithoutNamespace, wGet);
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public boolean[] exists(List<Get> gets) throws IOException {
        try {
            Result[] results = this.get(gets);
            boolean[] existResult = new boolean[results.length];
            for (int i = 0; i < results.length; ++i) {
                existResult[i] = results[i].getRow() != null;
            }
            return existResult;
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batch(List<? extends Row> actions, Object[] results) throws IOException {
        ArrayList<Object> tactions = new ArrayList<Object>(actions.size());
        for (Row row : actions) {
            if (row instanceof Get) {
                tactions.add(ElementConvertor.toLindormGet((Get)row));
                continue;
            }
            if (row instanceof Put) {
                tactions.add(ElementConvertor.toLindormPut((Put)row));
                continue;
            }
            if (row instanceof Delete) {
                tactions.add(ElementConvertor.toLindormDelete((Delete)row));
                continue;
            }
            if (row instanceof Append) {
                tactions.add(ElementConvertor.toLindormAppend((Append)row));
                continue;
            }
            if (row instanceof Increment) {
                tactions.add(ElementConvertor.toLindormIncrement((Increment)row));
                continue;
            }
            throw new UnsupportedOperationException("Unsupported type " + row.getClass().getName() + " in batch operation.");
        }
        Object[] hbaseResults = null;
        BatchExceptions batchExceptions = new BatchExceptions();
        try {
            hbaseResults = this.batch(tactions);
        }
        catch (Throwable throwable) {
            for (int i = 0; i < hbaseResults.length; ++i) {
                if (results != null) {
                    if (hbaseResults[i] == null) {
                        results[i] = null;
                        continue;
                    }
                    if (hbaseResults[i] instanceof WResult) {
                        if (actions.get(i) instanceof Get) {
                            results[i] = ElementConvertor.toHBaseResult((WResult)hbaseResults[i], ((Get)actions.get(i)).isCheckExistenceOnly());
                            continue;
                        }
                        results[i] = ElementConvertor.toHBaseResult((WResult)hbaseResults[i]);
                        continue;
                    }
                    if (hbaseResults[i] instanceof Result) {
                        results[i] = hbaseResults[i];
                        continue;
                    }
                    if (hbaseResults[i] instanceof Throwable) {
                        results[i] = hbaseResults[i];
                        batchExceptions.add((Throwable)hbaseResults[i], actions.get(i), null);
                        continue;
                    }
                    throw new IOException("Not unsupported result type " + hbaseResults[i]);
                }
                if (hbaseResults[i] == null || !(hbaseResults[i] instanceof Throwable)) continue;
                batchExceptions.add((Throwable)hbaseResults[i], actions.get(i), null);
            }
            if (batchExceptions.hasErrors()) {
                throw batchExceptions.makeException();
            }
            throw throwable;
        }
        for (int i = 0; i < hbaseResults.length; ++i) {
            if (results != null) {
                if (hbaseResults[i] == null) {
                    results[i] = null;
                    continue;
                }
                if (hbaseResults[i] instanceof WResult) {
                    if (actions.get(i) instanceof Get) {
                        results[i] = ElementConvertor.toHBaseResult((WResult)hbaseResults[i], ((Get)actions.get(i)).isCheckExistenceOnly());
                        continue;
                    }
                    results[i] = ElementConvertor.toHBaseResult((WResult)hbaseResults[i]);
                    continue;
                }
                if (hbaseResults[i] instanceof Result) {
                    results[i] = hbaseResults[i];
                    continue;
                }
                if (hbaseResults[i] instanceof Throwable) {
                    results[i] = hbaseResults[i];
                    batchExceptions.add((Throwable)hbaseResults[i], actions.get(i), null);
                    continue;
                }
                throw new IOException("Not unsupported result type " + hbaseResults[i]);
            }
            if (hbaseResults[i] == null || !(hbaseResults[i] instanceof Throwable)) continue;
            batchExceptions.add((Throwable)hbaseResults[i], actions.get(i), null);
        }
        if (batchExceptions.hasErrors()) {
            throw batchExceptions.makeException();
        }
    }

    private boolean isNotSupportAppendCrementError(Throwable t) {
        if (t.getMessage().contains("NoSuchMethodException")) {
            this.isSupportBatchAppendIncrement = false;
            return true;
        }
        return false;
    }

    private WResult[] doBatchAppend(List<WAppend> appendActions) throws IOException {
        block4: {
            if (this.isSupportBatchAppendIncrement) {
                try {
                    return this.wideColumnService.batchAppend(this.tableNameWithoutNamespace, appendActions);
                }
                catch (IOException ioE) {
                    boolean notSupported = this.isNotSupportAppendCrementError(ioE);
                    if (notSupported) break block4;
                    throw ioE;
                }
            }
        }
        WResult[] results = new WResult[appendActions.size()];
        for (int i = 0; i < appendActions.size(); ++i) {
            results[i] = this.wideColumnService.append(this.tableNameWithoutNamespace, appendActions.get(i));
        }
        return results;
    }

    private WResult[] doBatchIncrement(List<WIncrement> incActions) throws IOException {
        block4: {
            if (this.isSupportBatchAppendIncrement) {
                try {
                    return this.wideColumnService.batchIncrement(this.tableNameWithoutNamespace, incActions);
                }
                catch (IOException ioE) {
                    boolean notSupported = this.isNotSupportAppendCrementError(ioE);
                    if (notSupported) break block4;
                    throw ioE;
                }
            }
        }
        WResult[] results = new WResult[incActions.size()];
        for (int i = 0; i < incActions.size(); ++i) {
            results[i] = this.wideColumnService.increment(this.tableNameWithoutNamespace, incActions.get(i));
        }
        return results;
    }

    private Object[] batch(List<Object> actions) throws IOException {
        Object[] finalResults = new Object[actions.size()];
        ArrayList<WGet> getActions = new ArrayList<WGet>();
        ArrayList<Integer> getActionsIndex = new ArrayList<Integer>();
        ArrayList<WPut> putActions = new ArrayList<WPut>();
        ArrayList<Integer> putActionsIndex = new ArrayList<Integer>();
        ArrayList<WDelete> delActions = new ArrayList<WDelete>();
        ArrayList<Integer> delActionsIndex = new ArrayList<Integer>();
        ArrayList<WAppend> appendActions = new ArrayList<WAppend>();
        ArrayList<Integer> appendActionsIndex = new ArrayList<Integer>();
        ArrayList<WIncrement> incActions = new ArrayList<WIncrement>();
        ArrayList<Integer> incActionsIndex = new ArrayList<Integer>();
        for (int i = 0; i < actions.size(); ++i) {
            Object a = actions.get(i);
            if (a instanceof WGet) {
                getActions.add((WGet)a);
                getActionsIndex.add(i);
                continue;
            }
            if (a instanceof WPut) {
                putActions.add((WPut)a);
                putActionsIndex.add(i);
                continue;
            }
            if (a instanceof WDelete) {
                delActions.add((WDelete)a);
                delActionsIndex.add(i);
                continue;
            }
            if (a instanceof WAppend) {
                appendActions.add((WAppend)a);
                appendActionsIndex.add(i);
                continue;
            }
            if (a instanceof WIncrement) {
                incActions.add((WIncrement)a);
                incActionsIndex.add(i);
                continue;
            }
            throw new UnsupportedOperationException("Not supported action " + a.getClass().getName());
        }
        if (!getActions.isEmpty()) {
            try {
                WResult[] getResult = this.wideColumnService.batchGet(this.tableNameWithoutNamespace, getActions);
                for (int i = 0; i < getActions.size(); ++i) {
                    int index = (Integer)getActionsIndex.get(i);
                    finalResults[index] = getResult[i];
                }
            }
            catch (Throwable e) {
                for (Integer index : getActionsIndex) {
                    finalResults[index.intValue()] = e;
                }
            }
        }
        if (!putActions.isEmpty()) {
            Object[] putResults = new Object[putActions.size()];
            try {
                this.wideColumnService.batchPut(this.tableNameWithoutNamespace, putActions, putResults);
                int resultIndex = 0;
                for (Integer index : putActionsIndex) {
                    finalResults[index.intValue()] = putResults[resultIndex] instanceof EmptyResult ? new Result() : putResults[resultIndex];
                    ++resultIndex;
                }
            }
            catch (Throwable e) {
                int resultIndex = 0;
                for (Integer index : putActionsIndex) {
                    finalResults[index.intValue()] = putResults[resultIndex] == null ? e : (putResults[resultIndex] instanceof EmptyResult ? new Result() : putResults[resultIndex]);
                    ++resultIndex;
                }
            }
        }
        if (!delActions.isEmpty()) {
            try {
                this.wideColumnService.batchDelete(this.tableNameWithoutNamespace, delActions);
                for (Integer index : delActionsIndex) {
                    finalResults[index.intValue()] = new Result();
                }
            }
            catch (Throwable e) {
                for (Integer index : delActionsIndex) {
                    finalResults[index.intValue()] = e;
                }
            }
        }
        if (!appendActions.isEmpty()) {
            try {
                WResult[] appendResults = this.doBatchAppend(appendActions);
                for (int i = 0; i < appendActions.size(); ++i) {
                    int index = (Integer)appendActionsIndex.get(i);
                    finalResults[index] = appendResults[i];
                }
            }
            catch (Throwable e) {
                for (Integer index : appendActionsIndex) {
                    finalResults[index.intValue()] = e;
                }
            }
        }
        if (!incActions.isEmpty()) {
            try {
                WResult[] incResults = this.doBatchIncrement(incActions);
                for (int i = 0; i < incActions.size(); ++i) {
                    int index = (Integer)incActionsIndex.get(i);
                    finalResults[index] = incResults[i];
                }
            }
            catch (Throwable e) {
                for (Integer index : appendActionsIndex) {
                    finalResults[index.intValue()] = e;
                }
            }
        }
        return finalResults;
    }

    @Override
    public Result get(Get get2) throws IOException {
        try {
            WResult result = this.wideColumnService.get(this.tableNameWithoutNamespace, ElementConvertor.toLindormGet(get2));
            return ElementConvertor.toHBaseResult(result, get2.isCheckExistenceOnly());
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public Result[] get(List<Get> gets) throws IOException {
        try {
            WResult[] results = this.wideColumnService.batchGet(this.tableNameWithoutNamespace, ElementConvertor.toLindormGets(gets));
            return ElementConvertor.toHBaseResults(results, gets);
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public ResultScanner getScanner(Scan scan) throws IOException {
        return new Scanner(scan);
    }

    @Override
    public void put(Put put2) throws IOException {
        try {
            WPut wPut = ElementConvertor.toLindormPut(put2);
            this.wideColumnService.put(this.tableNameWithoutNamespace, wPut);
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public void put(List<Put> puts) throws IOException {
        try {
            List<WPut> wPuts = ElementConvertor.toLindormPuts(puts);
            this.wideColumnService.batchPut(this.tableNameWithoutNamespace, wPuts);
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public void delete(Delete delete) throws IOException {
        try {
            WDelete wDelete = ElementConvertor.toLindormDelete(delete);
            this.wideColumnService.delete(this.tableNameWithoutNamespace, wDelete);
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public void delete(List<Delete> deletes) throws IOException {
        try {
            List<WDelete> wDeletes = ElementConvertor.toLindormDeleteList(deletes);
            this.wideColumnService.batchDelete(this.tableNameWithoutNamespace, wDeletes);
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Put put2) throws IOException {
        try {
            WPut wPut = ElementConvertor.toLindormPut(put2);
            WCompareFilter.CompareOp wOp = ElementConvertor.toLindormCompareOp(compareOp);
            return this.wideColumnService.checkAndPut(this.tableNameWithoutNamespace, row, family, qualifier, wOp, value, wPut);
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Delete delete) throws IOException {
        try {
            WDelete wDelete = ElementConvertor.toLindormDelete(delete);
            WCompareFilter.CompareOp wOp = ElementConvertor.toLindormCompareOp(compareOp);
            return this.wideColumnService.checkAndDelete(this.tableNameWithoutNamespace, row, family, qualifier, wOp, value, wDelete);
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp op, byte[] value, RowMutations rowMutations) throws IOException {
        try {
            WRowMutations wRowMutations = ElementConvertor.toLindormRowMutation(rowMutations);
            WCompareFilter.CompareOp wOp = ElementConvertor.toLindormCompareOp(op);
            return this.wideColumnService.checkAndMutate(this.tableNameWithoutNamespace, row, family, qualifier, wOp, value, wRowMutations);
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public void mutateRow(RowMutations rm) throws IOException {
        try {
            ArrayList<Put> puts = new ArrayList<Put>();
            ArrayList<Delete> deletes = new ArrayList<Delete>();
            for (Mutation mutation : rm.getMutations()) {
                if (mutation instanceof Put) {
                    puts.add((Put)mutation);
                    continue;
                }
                if (mutation instanceof Delete) {
                    deletes.add((Delete)mutation);
                    continue;
                }
                throw new IOException("mutateRow not supported, use put(List<Put> puts), get(List<Get> gets) or delete(List<Delete> deletes) respectively");
            }
            if (!deletes.isEmpty()) {
                this.delete(deletes);
            }
            if (!puts.isEmpty()) {
                this.put(puts);
            }
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public Result append(Append append2) throws IOException {
        try {
            WAppend wAppend = ElementConvertor.toLindormAppend(append2);
            WResult wResult = this.wideColumnService.append(this.tableNameWithoutNamespace, wAppend);
            return ElementConvertor.toHBaseResult(wResult);
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public Result increment(Increment increment2) throws IOException {
        try {
            WIncrement wIncrement = ElementConvertor.toLindormIncrement(increment2);
            WResult wResult = this.wideColumnService.increment(this.tableNameWithoutNamespace, wIncrement);
            return ElementConvertor.toHBaseResult(wResult);
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
        if (service != AggregateProtos.AggregateService.class) {
            throw new UnsupportedOperationException("coprocessorService " + service + " not supported");
        }
        AliHBaseUEAggregateService instance = new AliHBaseUEAggregateService(this.factory.getTableServiceService(this.myTableName.getNamespaceAsString()), this.tableNameWithoutNamespace);
        Object result = callable.call(instance);
        if (callback != null) {
            callback.update(null, null, result);
        }
    }

    @Override
    public void addExternalIndex(ExternalIndexConfig config, List<ExternalIndexField> fields) throws IOException {
        this.wideColumnService.addExternalIndex(this.tableNameWithoutNamespace, config, fields);
    }

    @Override
    public void alterExternalIndex(ExternalIndexConfig config) throws IOException {
        try {
            this.wideColumnService.alterExternalIndex(this.tableNameWithoutNamespace, config);
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public void removeExternalIndex(List<String> fields) throws IOException {
        try {
            this.wideColumnService.removeExternalIndex(this.tableNameWithoutNamespace, fields);
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public void buildExternalIndex() throws IOException {
        try {
            this.wideColumnService.buildExternalIndex(this.tableNameWithoutNamespace);
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public void cancelBuildExternalIndex() throws IOException {
        try {
            this.wideColumnService.cancelBuildExternalIndex(this.tableNameWithoutNamespace);
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public List<AliHBaseIndexDescriptor> describeIndex(TableName dataTableName) throws IOException {
        try {
            LindormTableDescriptor desc = this.factory.getWideColumnService(dataTableName.getNamespaceAsString()).describeTable(dataTableName.getQualifierAsString());
            List<LindormIndexDescriptor> indexDescriptors = desc.getIndexes();
            List<AliHBaseIndexDescriptor> ret = Collections.emptyList();
            if (indexDescriptors != null && !indexDescriptors.isEmpty()) {
                ret = new ArrayList<AliHBaseIndexDescriptor>(indexDescriptors.size());
                for (LindormIndexDescriptor lid : indexDescriptors) {
                    ret.add(ElementConvertor.toAliHBaseIndexDescriptor(dataTableName.getNamespaceAsString(), lid));
                }
            }
            return ret;
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public void createIndex(AliHBaseIndexDescriptor indexDescriptor) throws IOException {
        try {
            LindormIndexDescriptor lid = ElementConvertor.toLindormIndexDescriptor(indexDescriptor);
            TableName tableName = indexDescriptor.getDataTable();
            this.factory.getTableServiceService(tableName.getNamespaceAsString()).createIndex(lid);
            this.buildIndexSync(indexDescriptor.getIndexName(), indexDescriptor.getDataTable());
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public void createIndex(AliHBaseIndexDescriptor indexDescriptor, byte[][] splitKeys) throws IOException {
        try {
            LindormIndexDescriptor lid = ElementConvertor.toLindormIndexDescriptor(indexDescriptor);
            TableName tableName = indexDescriptor.getDataTable();
            this.factory.getTableServiceService(tableName.getNamespaceAsString()).createIndex(lid, splitKeys);
            this.buildIndexSync(indexDescriptor.getIndexName(), indexDescriptor.getDataTable());
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public void createIndex(AliHBaseIndexDescriptor indexDescriptor, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        try {
            LindormIndexDescriptor lid = ElementConvertor.toLindormIndexDescriptor(indexDescriptor);
            TableName tableName = indexDescriptor.getDataTable();
            this.factory.getTableServiceService(tableName.getNamespaceAsString()).createIndex(lid, startKey, endKey, numRegions);
            this.buildIndexSync(indexDescriptor.getIndexName(), indexDescriptor.getDataTable());
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public void deleteIndex(String indexName, TableName dataTable) throws IOException {
        try {
            this.factory.getTableServiceService(dataTable.getNamespaceAsString()).deleteIndex(indexName, dataTable.getQualifierAsString());
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public void offlineIndex(String indexName, TableName dataTable) throws IOException {
        try {
            this.factory.getTableServiceService(dataTable.getNamespaceAsString()).alterIndexState(indexName, dataTable.getQualifierAsString(), IndexState.DISABLED);
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public void registerBDSCluster(String hbaseSourceName, String bdsClusterkey, String hbaseConnectionString, String username, String password) throws IOException {
        this.factory.getSystemService().registerBDSCluster(hbaseSourceName, bdsClusterkey, hbaseConnectionString, username, password);
    }

    @Override
    public void registerSolrCluster(String solrSourceName, String solrConnectionStr) throws IOException {
        this.factory.getSystemService().registerSolrCluster(solrSourceName, solrConnectionStr);
    }

    @Override
    public void registerESCluster(String esSourceName, String esConnectionStr, String userName, String password) throws IOException {
        this.factory.getSystemService().registerESCluster(esSourceName, esConnectionStr, userName, password);
    }

    @Override
    public void unregisterSolrCluster(boolean force) throws IOException {
        this.factory.getSystemService().unregisterSolrCluster(force);
    }

    @Override
    public void unregisterESCluster(boolean force) throws IOException {
        this.factory.getSystemService().unregisterESCluster(force);
    }

    @Override
    public void unregisterBDSCluster(boolean force) throws IOException {
        this.factory.getSystemService().unregisterBDSCluster(force);
    }

    private void buildIndexSync(String indexName, TableName dataTable) throws IOException {
        this.factory.getTableServiceService(dataTable.getNamespaceAsString()).buildIndexAsync(dataTable.getNamespaceAsString(), dataTable.getQualifierAsString(), indexName);
        this.blockingAndWaitIndexAvailable(indexName, dataTable);
    }

    @Override
    public void alterExternalIndex(String json) throws IOException {
        try {
            this.wideColumnService.alterExternalIndex(this.tableNameWithoutNamespace, json);
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    @Override
    public String describeExternalIndex() throws IOException {
        try {
            return this.wideColumnService.describeExternalIndex(this.tableNameWithoutNamespace);
        }
        catch (IOException e) {
            throw ElementConvertor.toHBaseIOException(e);
        }
    }

    private void blockingAndWaitIndexAvailable(String indexName, TableName dataTable) throws IOException {
        long startTime = System.currentTimeMillis();
        long blockTimeInMs = Integer.MAX_VALUE;
        long deadline = startTime + blockTimeInMs;
        long remaining = deadline - System.currentTimeMillis();
        long pauseTime = 1000L;
        int loop = 0;
        IndexState expectedIndexState = IndexState.ACTIVE;
        IndexState currIndexState = null;
        while (remaining >= 0L) {
            if (currIndexState != expectedIndexState) {
                currIndexState = this.factory.getTableServiceService(dataTable.getNamespaceAsString()).getIndexState(indexName, dataTable.getQualifierAsString());
            } else {
                boolean done = this.factory.getTableServiceService(dataTable.getNamespaceAsString()).isModifySuccess(dataTable.getQualifierAsString());
                if (done) {
                    return;
                }
            }
            long sleepTime = pauseTime;
            if (++loop > 60) {
                sleepTime = pauseTime * 10L;
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                throw new IOException("Failed to wait index state of " + indexName + " to:" + (Object)((Object)expectedIndexState) + ", current index state is:" + (Object)((Object)currIndexState), e);
            }
        }
    }

    private class Scanner
    implements ResultScanner {
        private final WScanner wScanner;
        protected Result lastResult = null;
        protected final Queue<Result> cache = new ArrayDeque<Result>();

        public Scanner(Scan scan) throws IOException {
            if (scan.getCaching() <= 0) {
                scan.setCaching(AliHBaseAPIProxyDirectImpl.this.defaultScannerCaching);
            } else if (scan.getCaching() == 1 && scan.isReversed()) {
                scan.setCaching(scan.getCaching() + 1);
            }
            WScan wScan = ElementConvertor.toLindormScan(scan);
            this.wScanner = AliHBaseAPIProxyDirectImpl.this.wideColumnService.getScanner(AliHBaseAPIProxyDirectImpl.this.tableNameWithoutNamespace, wScan);
        }

        public boolean renewLease() {
            return false;
        }

        public ScanMetrics getScanMetrics() {
            return null;
        }

        public Iterator<Result> iterator() {
            return new Iterator<Result>(){
                private Iterator<WResult> it;
                {
                    this.it = Scanner.this.wScanner.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public Result next() {
                    WResult wResult = this.it.next();
                    if (wResult == null) {
                        return null;
                    }
                    return ElementConvertor.toHBaseResult(wResult);
                }

                @Override
                public void remove() {
                }
            };
        }

        public Result next() throws IOException {
            try {
                WResult r = this.wScanner.next();
                if (r == null) {
                    return null;
                }
                return ElementConvertor.toHBaseResult(r);
            }
            catch (IOException e) {
                throw ElementConvertor.toHBaseIOException(e);
            }
        }

        public void close() {
        }

        public Result[] next(int nbRows) throws IOException {
            try {
                Result next;
                ArrayList<Result> resultSets = new ArrayList<Result>(nbRows);
                for (int i = 0; i < nbRows && (next = this.next()) != null; ++i) {
                    resultSets.add(next);
                }
                return resultSets.toArray(new Result[resultSets.size()]);
            }
            catch (IOException e) {
                throw ElementConvertor.toHBaseIOException(e);
            }
        }
    }
}

