/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.client;

import com.alibaba.hbase.client.ElementConvertor;
import com.alibaba.lindorm.client.TableService;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.dml.Aggregate;
import com.alibaba.lindorm.client.dml.ColumnValue;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.dml.ConditionFactory;
import com.alibaba.lindorm.client.dml.ConditionList;
import com.alibaba.lindorm.client.dml.Row;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.PrimaryKeySchema;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import java.io.IOException;
import java.util.List;
import java.util.NavigableSet;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ColumnInterpreter;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.AggregateProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliHBaseUEAggregateService<T, S, P extends Message, Q extends Message, R extends Message>
extends AggregateProtos.AggregateService {
    private static final Logger LOG = LoggerFactory.getLogger(AliHBaseUEAggregateService.class);
    private TableService tableService;
    private String table;
    private static byte[] PK_COLUMN_NAME = "ROW".getBytes();
    private static byte[] COUNT_ALL = Bytes.toBytes("COUNT(*)");

    public AliHBaseUEAggregateService(TableService tableService, String table) {
        this.tableService = tableService;
        this.table = table;
    }

    public void getMax(RpcController rpcController, AggregateProtos.AggregateRequest aggregateRequest, RpcCallback<AggregateProtos.AggregateResponse> rpcCallback) {
        AggregateProtos.AggregateResponse response = null;
        try {
            LindormAggregate lindormAggregate = this.toLindormAggregate(aggregateRequest);
            ColumnValue cv = lindormAggregate.max();
            ColumnInterpreter<T, S, P, Q, R> ci = this.constructColumnInterpreterFromRequest(aggregateRequest);
            byte[] value = cv.getBinary();
            Object max = ci.getValue(lindormAggregate.getCfName(), lindormAggregate.getColName(), (Cell)new KeyValue(HConstants.EMPTY_BYTE_ARRAY, lindormAggregate.getCfName(), lindormAggregate.getColName(), value));
            response = AggregateProtos.AggregateResponse.newBuilder().addFirstPart(ci.getProtoForCellType(max).toByteString()).build();
        }
        catch (IOException e) {
            ResponseConverter.setControllerException((RpcController)rpcController, (IOException)e);
        }
        if (rpcCallback != null) {
            rpcCallback.run(response);
        }
    }

    public void getMin(RpcController rpcController, AggregateProtos.AggregateRequest aggregateRequest, RpcCallback<AggregateProtos.AggregateResponse> rpcCallback) {
        AggregateProtos.AggregateResponse response = null;
        try {
            LindormAggregate lindormAggregate = this.toLindormAggregate(aggregateRequest);
            ColumnValue cv = lindormAggregate.min();
            ColumnInterpreter<T, S, P, Q, R> ci = this.constructColumnInterpreterFromRequest(aggregateRequest);
            byte[] value = cv.getBinary();
            Object min = ci.getValue(lindormAggregate.getCfName(), lindormAggregate.getColName(), (Cell)new KeyValue(HConstants.EMPTY_BYTE_ARRAY, lindormAggregate.getCfName(), lindormAggregate.getColName(), value));
            response = AggregateProtos.AggregateResponse.newBuilder().addFirstPart(ci.getProtoForCellType(min).toByteString()).build();
        }
        catch (IOException e) {
            ResponseConverter.setControllerException((RpcController)rpcController, (IOException)e);
        }
        if (rpcCallback != null) {
            rpcCallback.run(response);
        }
    }

    public void getSum(RpcController rpcController, AggregateProtos.AggregateRequest aggregateRequest, RpcCallback<AggregateProtos.AggregateResponse> rpcCallback) {
        AggregateProtos.AggregateResponse response = null;
        try {
            LindormAggregate lindormAggregate = this.toLindormAggregate(aggregateRequest);
            ColumnValue cv = lindormAggregate.sum();
            ColumnInterpreter<T, S, P, Q, R> ci = this.constructColumnInterpreterFromRequest(aggregateRequest);
            byte[] value = ElementConvertor.toValueBytes(cv, ci);
            Object sum = ci.getValue(lindormAggregate.getCfName(), lindormAggregate.getColName(), (Cell)new KeyValue(HConstants.EMPTY_BYTE_ARRAY, lindormAggregate.getCfName(), lindormAggregate.getColName(), value));
            response = AggregateProtos.AggregateResponse.newBuilder().addFirstPart(ci.getProtoForCellType(sum).toByteString()).build();
        }
        catch (IOException e) {
            ResponseConverter.setControllerException((RpcController)rpcController, (IOException)e);
        }
        if (rpcCallback != null) {
            rpcCallback.run(response);
        }
    }

    public void getRowNum(RpcController rpcController, AggregateProtos.AggregateRequest aggregateRequest, RpcCallback<AggregateProtos.AggregateResponse> rpcCallback) {
        AggregateProtos.AggregateResponse response = null;
        try {
            LindormAggregate lindormAggregate = this.toLindormAggregate(aggregateRequest);
            ColumnValue cv = lindormAggregate.count();
            response = AggregateProtos.AggregateResponse.newBuilder().addFirstPart(ByteString.copyFrom((byte[])Bytes.toBytes(cv.getLong()))).build();
        }
        catch (IOException e) {
            ExceptionUtils.getFullStackTrace((Throwable)e);
            ResponseConverter.setControllerException((RpcController)rpcController, (IOException)e);
        }
        if (rpcCallback != null) {
            rpcCallback.run(response);
        }
    }

    public void getAvg(RpcController rpcController, AggregateProtos.AggregateRequest aggregateRequest, RpcCallback<AggregateProtos.AggregateResponse> rpcCallback) {
        AggregateProtos.AggregateResponse response = null;
        try {
            LindormAggregate lindormAggregate = this.toLindormAggregate(aggregateRequest);
            ColumnValue cv = lindormAggregate.avg();
            ColumnInterpreter<T, S, P, Q, R> ci = this.constructColumnInterpreterFromRequest(aggregateRequest);
            byte[] value = ElementConvertor.toValueBytes(cv, ci);
            Object avg = ci.getValue(lindormAggregate.getCfName(), lindormAggregate.getColName(), (Cell)new KeyValue(HConstants.EMPTY_BYTE_ARRAY, lindormAggregate.getCfName(), lindormAggregate.getColName(), value));
            AggregateProtos.AggregateResponse.Builder pair = AggregateProtos.AggregateResponse.newBuilder();
            pair.addFirstPart(ci.getProtoForCellType(avg).toByteString());
            pair.setSecondPart(ByteString.copyFrom((byte[])Bytes.toBytes(1L)));
            response = pair.build();
        }
        catch (IOException e) {
            ResponseConverter.setControllerException((RpcController)rpcController, (IOException)e);
        }
        if (rpcCallback != null) {
            rpcCallback.run(response);
        }
    }

    public void getStd(RpcController rpcController, AggregateProtos.AggregateRequest aggregateRequest, RpcCallback<AggregateProtos.AggregateResponse> rpcCallback) {
        throw new UnsupportedOperationException("GetStd unsupported !");
    }

    public void getMedian(RpcController rpcController, AggregateProtos.AggregateRequest aggregateRequest, RpcCallback<AggregateProtos.AggregateResponse> rpcCallback) {
        throw new UnsupportedOperationException("GetMedian unsupported !");
    }

    private LindormAggregate toLindormAggregate(AggregateProtos.AggregateRequest aggregateRequest) throws IOException {
        ClientProtos.Scan scan = aggregateRequest.getScan();
        Scan scanner = ProtobufUtil.toScan((ClientProtos.Scan)scan);
        Condition condition = this.convertRequestToCondition(scanner);
        Aggregate aggregate = this.tableService.aggregate().from(this.table);
        if (condition != null) {
            aggregate.where(condition);
        }
        aggregate.allowFiltering(true);
        if (!aggregateRequest.hasScan()) {
            throw new UnsupportedOperationException("Scan is null !");
        }
        byte[] colFamily = null;
        byte[] qualifier = null;
        if (scanner.getFamilies() != null) {
            if (scanner.getFamilies().length > 1) {
                LOG.warn("Only support one family in sum, max, min, avg");
            }
            colFamily = scanner.getFamilies()[0];
            NavigableSet qualifiers = (NavigableSet)scanner.getFamilyMap().get(colFamily);
            if (qualifiers != null && !qualifiers.isEmpty()) {
                qualifier = (byte[])qualifiers.pollFirst();
            }
        }
        if (!aggregateRequest.hasInterpreterClassName()) {
            throw new UnsupportedOperationException("Must provide interpreter class");
        }
        DataType interpreterDatype = ElementConvertor.toInterpreterDataType(aggregateRequest.getInterpreterClassName());
        return new LindormAggregate(colFamily, qualifier, interpreterDatype, aggregate);
    }

    public Condition convertRequestToCondition(Scan scan) throws HBaseIOException {
        try {
            List<Condition> conditions;
            ConditionList conditionList = ConditionFactory.and();
            AliHBaseUEAggregateService.checkAggregateSupport(scan);
            if (scan.hasFilter()) {
                conditionList.add(this.covertFilterToCondition(scan.getFilter(), scan.isReversed()));
            }
            Condition startRow = null;
            Condition stopRow = null;
            if (scan != null) {
                if (scan.getStartRow() != null) {
                    startRow = ConditionFactory.compare(PK_COLUMN_NAME, ConditionFactory.CompareOp.GREATER, (Object)scan.getStartRow());
                }
                if (scan.getStopRow() != null) {
                    stopRow = ConditionFactory.compare(PK_COLUMN_NAME, ConditionFactory.CompareOp.LESS_OR_EQUAL, (Object)scan.getStopRow());
                }
            }
            if (startRow != null) {
                conditionList.add(ConditionFactory.and(startRow));
            }
            if (stopRow != null) {
                conditionList.add(ConditionFactory.and(stopRow));
            }
            if ((conditions = conditionList.getConditions()) == null || conditions.isEmpty()) {
                return null;
            }
            return conditions.size() > 1 ? conditionList : conditions.get(0);
        }
        catch (LindormException e) {
            throw new HBaseIOException((Throwable)e);
        }
    }

    public Condition covertFilterToCondition(Filter filter, boolean reversed) throws HBaseIOException {
        try {
            if (filter instanceof FilterList) {
                return this.generateConditionByFilterList((FilterList)filter, reversed);
            }
            return this.generateConditionBySingleFilter(filter, reversed);
        }
        catch (LindormException e) {
            throw new HBaseIOException((Throwable)e);
        }
    }

    private Condition generateConditionByFilterList(FilterList filter, boolean reversed) throws HBaseIOException, LindormException {
        ConditionList conditionList = filter.getOperator() == FilterList.Operator.MUST_PASS_ALL ? ConditionFactory.and() : ConditionFactory.or();
        List filters = filter.getFilters();
        for (Filter subFilter : filters) {
            conditionList.add(this.covertFilterToCondition(subFilter, reversed));
        }
        return conditionList;
    }

    public Condition generateConditionBySingleFilter(Filter filter, boolean reversed) throws HBaseIOException, LindormException {
        if (filter instanceof RowFilter) {
            return this.generateCondition((RowFilter)filter);
        }
        if (filter instanceof InclusiveStopFilter) {
            return this.generateCondition((InclusiveStopFilter)filter, reversed);
        }
        if (filter instanceof SingleColumnValueFilter) {
            return this.generateCondition((SingleColumnValueFilter)filter);
        }
        throw new HBaseIOException("Unsupported filter [type: " + filter.toString() + "]");
    }

    private Condition generateCondition(RowFilter filter) throws HBaseIOException, LindormException {
        LColumn column = new LColumn(AliHBaseUEAggregateService.getFirstPkSchema(), 0);
        return this.generateCondition(column, filter.getOperator(), filter.getComparator());
    }

    private Condition generateCondition(LColumn column, CompareFilter.CompareOp operator, ByteArrayComparable comparator) throws HBaseIOException, LindormException {
        this.checkComparator(comparator);
        ConditionFactory.CompareOp compareOp = AliHBaseUEAggregateService.transformOp(operator);
        return ConditionFactory.compare(column.getFamilyName(), column.getColumnName(), compareOp, (Object)comparator.getValue());
    }

    private void checkComparator(ByteArrayComparable comparator) throws HBaseIOException {
        if (!(comparator instanceof BinaryComparator)) {
            throw new HBaseIOException("Compiling the comparator [class: " + (comparator == null ? null : comparator.getClass().getName()) + "] is not supported.");
        }
    }

    private Condition generateCondition(InclusiveStopFilter filter, boolean reversed) throws LindormException {
        LColumn column = new LColumn(AliHBaseUEAggregateService.getFirstPkSchema(), 0);
        ConditionFactory.CompareOp op = !reversed ? ConditionFactory.CompareOp.LESS_OR_EQUAL : ConditionFactory.CompareOp.GREATER_OR_EQUAL;
        return ConditionFactory.compare(column.getFamilyName(), column.getColumnName(), op, (Object)filter.getStopRowKey());
    }

    private Condition generateCondition(SingleColumnValueFilter filter) throws HBaseIOException, LindormException {
        ByteArrayComparable comparator = filter.getComparator();
        this.checkComparator(comparator);
        ConditionFactory.CompareOp compareOp = AliHBaseUEAggregateService.transformOp(filter.getOperator());
        Condition condition = ConditionFactory.compare(filter.getFamily(), filter.getQualifier(), compareOp, (Object)comparator.getValue());
        return condition;
    }

    public static PrimaryKeySchema getFirstPkSchema() {
        return new PrimaryKeySchema("ROW", DataType.VARBINARY);
    }

    public static ConditionFactory.CompareOp transformOp(CompareFilter.CompareOp operator) {
        switch (operator) {
            case LESS: {
                return ConditionFactory.CompareOp.LESS;
            }
            case LESS_OR_EQUAL: {
                return ConditionFactory.CompareOp.LESS_OR_EQUAL;
            }
            case EQUAL: {
                return ConditionFactory.CompareOp.EQUAL;
            }
            case NOT_EQUAL: {
                return ConditionFactory.CompareOp.NOT_EQUAL;
            }
            case GREATER_OR_EQUAL: {
                return ConditionFactory.CompareOp.GREATER_OR_EQUAL;
            }
            case GREATER: {
                return ConditionFactory.CompareOp.GREATER;
            }
        }
        throw new IllegalArgumentException("Invalid compare operator " + operator);
    }

    public static void checkAggregateSupport(Scan scan) {
        if (scan == null) {
            return;
        }
        if (scan.hasFilter() && !AliHBaseUEAggregateService.checkSupportedFilters(scan.getFilter())) {
            throw new UnsupportedOperationException("Filter unsupported !");
        }
        if (scan.getMaxVersions() > 1) {
            throw new UnsupportedOperationException("Versions unsupported ! current : " + scan.getMaxVersions());
        }
    }

    public static boolean checkSupportedFilters(Filter filter) {
        if (filter == null) {
            return false;
        }
        if (filter instanceof FilterList) {
            boolean result = true;
            for (Filter subFilter : ((FilterList)filter).getFilters()) {
                result = result && AliHBaseUEAggregateService.checkSupportedFilters(subFilter);
            }
            return result;
        }
        if (filter instanceof RowFilter) {
            return true;
        }
        if (filter instanceof InclusiveStopFilter) {
            return true;
        }
        return filter instanceof SingleColumnValueFilter;
    }

    ColumnInterpreter<T, S, P, Q, R> constructColumnInterpreterFromRequest(AggregateProtos.AggregateRequest request) throws IOException {
        String className = request.getInterpreterClassName();
        try {
            Class<?> cls = Class.forName(className);
            ColumnInterpreter ci = (ColumnInterpreter)cls.newInstance();
            if (request.hasInterpreterSpecificBytes()) {
                ByteString b = request.getInterpreterSpecificBytes();
                Message initMsg = ProtobufUtil.getParsedGenericInstance(ci.getClass(), (int)2, (ByteString)b);
                ci.initialize(initMsg);
            }
            return ci;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    class LindormAggregate {
        private byte[] cfName;
        private byte[] colName;
        private DataType interpreterDatype;
        private Aggregate aggregate;

        public LindormAggregate(byte[] cfName, byte[] colName, DataType interpreterDatype, Aggregate aggregate) {
            this.cfName = cfName;
            this.colName = colName;
            this.interpreterDatype = interpreterDatype;
            this.aggregate = aggregate;
        }

        public byte[] getCfName() {
            return this.cfName;
        }

        public byte[] getColName() {
            return this.colName;
        }

        public DataType getInterpreterDatype() {
            return this.interpreterDatype;
        }

        public Aggregate getAggregate() {
            return this.aggregate;
        }

        public ColumnValue sum() throws LindormException {
            String colStrName = Bytes.toString(this.colName);
            this.aggregate.sumAs(Bytes.toString(this.cfName), colStrName, colStrName, this.interpreterDatype);
            Row row = this.aggregate.execute();
            return row.getColumnValue(this.colName);
        }

        public ColumnValue max() throws LindormException {
            String colStrName = Bytes.toString(this.colName);
            this.aggregate.maxAs(Bytes.toString(this.cfName), colStrName, colStrName);
            Row row = this.aggregate.execute();
            return row.getColumnValue(this.colName);
        }

        public ColumnValue min() throws LindormException {
            String colStrName = Bytes.toString(this.colName);
            this.aggregate.minAs(Bytes.toString(this.cfName), colStrName, colStrName);
            Row row = this.aggregate.execute();
            return row.getColumnValue(this.colName);
        }

        public ColumnValue avg() throws LindormException {
            String colStrName = Bytes.toString(this.colName);
            this.aggregate.avgAs(Bytes.toString(this.cfName), colStrName, colStrName, this.interpreterDatype);
            Row row = this.aggregate.execute();
            return row.getColumnValue(this.colName);
        }

        public ColumnValue count() throws LindormException {
            if (this.colName == null) {
                this.aggregate.count();
            } else {
                String colStrName = Bytes.toString(this.colName);
                this.aggregate.countAs(Bytes.toString(this.cfName), colStrName, colStrName);
            }
            Row row = this.aggregate.execute();
            if (this.colName == null) {
                return row.getColumnValue(COUNT_ALL);
            }
            return row.getColumnValue(this.colName);
        }
    }
}

