/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.com.taobao.middleware.logger.log4j;

import com.alibaba.hbase.com.taobao.middleware.logger.Logger;
import com.alibaba.hbase.com.taobao.middleware.logger.option.Log4jActivateOption;
import com.alibaba.hbase.com.taobao.middleware.logger.support.LoggerHelper;
import com.alibaba.hbase.com.taobao.middleware.logger.support.LoggerSupport;
import com.alibaba.hbase.com.taobao.middleware.logger.util.MessageUtil;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class Log4jLogger
extends LoggerSupport
implements Logger {
    private org.apache.log4j.Logger delegate;

    public Log4jLogger(org.apache.log4j.Logger delegate) {
        super(delegate);
        if (delegate == null) {
            throw new IllegalArgumentException("delegate Logger is null");
        }
        this.delegate = delegate;
        this.activateOption = new Log4jActivateOption(delegate);
    }

    @Override
    public void debug(String context, String message) {
        if (this.isDebugEnabled()) {
            message = LoggerHelper.getResourceBundleString(this.getProductName(), message);
            this.delegate.debug((Object)MessageUtil.getMessage(context, message));
        }
    }

    @Override
    public void debug(String context, String format, Object ... args) {
        if (this.isDebugEnabled()) {
            format = LoggerHelper.getResourceBundleString(this.getProductName(), format);
            this.delegate.debug((Object)MessageUtil.getMessage(context, MessageUtil.formatMessage(format, args)));
        }
    }

    @Override
    public void info(String context, String message) {
        if (this.isInfoEnabled()) {
            message = LoggerHelper.getResourceBundleString(this.getProductName(), message);
            this.delegate.info((Object)MessageUtil.getMessage(context, message));
        }
    }

    @Override
    public void info(String context, String format, Object ... args) {
        if (this.isInfoEnabled()) {
            format = LoggerHelper.getResourceBundleString(this.getProductName(), format);
            this.delegate.info((Object)MessageUtil.getMessage(context, MessageUtil.formatMessage(format, args)));
        }
    }

    @Override
    public void warn(String message, Throwable t) {
        if (this.isWarnEnabled()) {
            message = LoggerHelper.getResourceBundleString(this.getProductName(), message);
            this.delegate.warn((Object)MessageUtil.getMessage(null, message), t);
        }
    }

    @Override
    public void warn(String context, String message) {
        if (this.isWarnEnabled()) {
            message = LoggerHelper.getResourceBundleString(this.getProductName(), message);
            this.delegate.warn((Object)MessageUtil.getMessage(context, message));
        }
    }

    @Override
    public void warn(String context, String format, Object ... args) {
        if (this.isWarnEnabled()) {
            format = LoggerHelper.getResourceBundleString(this.getProductName(), format);
            this.delegate.warn((Object)MessageUtil.getMessage(context, MessageUtil.formatMessage(format, args)));
        }
    }

    @Override
    public void error(String context, String errorCode, String message) {
        if (this.isErrorEnabled()) {
            message = LoggerHelper.getResourceBundleString(this.getProductName(), message);
            this.delegate.error((Object)MessageUtil.getMessage(context, errorCode, message));
        }
    }

    @Override
    public void error(String context, String errorCode, String message, Throwable t) {
        if (this.isErrorEnabled()) {
            message = LoggerHelper.getResourceBundleString(this.getProductName(), message);
            this.delegate.error((Object)MessageUtil.getMessage(context, errorCode, message), t);
        }
    }

    @Override
    public void error(String context, String errorCode, String format, Object ... args) {
        if (this.isErrorEnabled()) {
            format = LoggerHelper.getResourceBundleString(this.getProductName(), format);
            this.delegate.error((Object)MessageUtil.getMessage(context, errorCode, MessageUtil.formatMessage(format, args)));
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.delegate.isEnabledFor((Priority)Level.WARN);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.delegate.isEnabledFor((Priority)Level.ERROR);
    }
}

