/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.exception;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Row;

public class BatchExceptions {
    private final List<Throwable> throwables = new ArrayList<Throwable>();
    private final List<Row> actions = new ArrayList<Row>();
    private final List<String> addresses = new ArrayList<String>();

    public synchronized void add(Throwable ex, Row row, ServerName serverName) {
        if (row == null) {
            throw new IllegalArgumentException("row cannot be null. location=" + serverName);
        }
        this.throwables.add(ex);
        this.actions.add(row);
        this.addresses.add(serverName != null ? serverName.toString() : "null");
    }

    public boolean hasErrors() {
        return !this.throwables.isEmpty();
    }

    public synchronized RetriesExhaustedWithDetailsException makeException() {
        RetriesExhaustedWithDetailsException exception = new RetriesExhaustedWithDetailsException(new ArrayList<Throwable>(this.throwables), new ArrayList<Row>(this.actions), new ArrayList<String>(this.addresses));
        if (this.throwables != null && this.throwables.size() > 0) {
            exception.addSuppressed((Throwable)new IOException("Get all details use RetriesExhaustedWithDetailsException.getCauses() , first exception is:", this.throwables.get(0)));
        }
        return exception;
    }

    public synchronized void clear() {
        this.throwables.clear();
        this.actions.clear();
        this.addresses.clear();
    }

    public synchronized void merge(BatchExceptions other) {
        this.throwables.addAll(other.throwables);
        this.actions.addAll(other.actions);
        this.addresses.addAll(other.addresses);
    }
}

