/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.haclient;

import com.alibaba.hbase.client.AliHBaseConstants;
import com.alibaba.hbase.client.AliHBaseUEConnection;
import com.alibaba.hbase.haclient.SwitchCommand;
import com.alibaba.hbase.protobuf.generated.ClusterSwitchProto;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;

public class ClusterSwitchUtil {
    public static String ZOOKEEPER_REDIRECT_NODE = "hbase.haclient.redirect.node";
    public static String ZOOKEEPER_CONNECT_NODE = "hbase.haclient.connect.node";
    public static String ZOOKEEPER_LINK_NODE = "hbase.haclient.link.node";
    public static String ZOOKEEPER_CREATE_NODE = "hbase.haclient.create.node";
    public static String ZOOKEEPER_MODIFY_NODE = "hbase.haclient.modify.node";
    public static String ZOOKEEPER_DUAL_TABLE_NODE = "hbase.haclient.dual.table.node";
    public static String ZOOKEEPER_DUAL_TRACE_NODE = "hbase.haclient.dual.trace.node";
    public static final Pattern CLUSTER_KEY_PATTERN = Pattern.compile("^[^,]+(,[^,]+)*:[0-9]+:/.+$");
    public static final Pattern ENDPOINT_PATTERN = Pattern.compile("^[0-9a-zA-Z\\.\\-]+:[0-9]+");
    public static String ZOOKEEPER_REDIRECT_NODE_DEFAULT = ".redirect";
    public static String ZOOKEEPER_CONNECT_NODE_DEFAULT = ".connect";
    public static String ZOOKEEPER_LINK_NODE_DEFAULT = ".link";
    public static String ZOOKEEPER_CREATE_NODE_DEFAULT = ".create";
    public static String ZOOKEEPER_MODIFY_NODE_DEFAULT = ".modify";
    public static String ZOOKEEPER_DUAL_TABLE_NODE_DEFAULT = ".dualtable";
    public static String ZOOKEEPER_DUAL_TRACE_NODE_DEFAULT = ".dualtrace";
    public static String CONF_SEPARATOR = ".";

    public static String buildQuorumServerString(String[] serverHosts, String clientPort) {
        StringBuilder quorumStringBuilder = new StringBuilder();
        for (int i = 0; i < serverHosts.length; ++i) {
            String serverHost = serverHosts[i].contains(":") ? serverHosts[i] : serverHosts[i] + ":" + clientPort;
            if (i > 0) {
                quorumStringBuilder.append(',');
            }
            quorumStringBuilder.append(serverHost);
        }
        return quorumStringBuilder.toString();
    }

    public static ZKClusterKey transformClusterKey(String key) throws IOException {
        String[] parts = key.split(":");
        if (parts.length == 3) {
            return new ZKClusterKey(parts[0], Integer.parseInt(parts[1]), parts[2]);
        }
        if (parts.length > 3) {
            String zNodeParent = parts[parts.length - 1];
            String clientPort = parts[parts.length - 2];
            int endQuorumIndex = key.length() - zNodeParent.length() - clientPort.length() - 2;
            String quorumStringInput = key.substring(0, endQuorumIndex);
            String[] serverHosts = quorumStringInput.split(",");
            if (parts.length - 2 == serverHosts.length + 1) {
                return new ZKClusterKey(quorumStringInput, Integer.parseInt(clientPort), zNodeParent);
            }
            return new ZKClusterKey(ClusterSwitchUtil.buildQuorumServerString(serverHosts, clientPort), Integer.parseInt(clientPort), zNodeParent);
        }
        throw new IOException("Cluster key passed " + key + " is invalid, the format should be:" + "hbase.zookeeper.quorum" + ":" + "hbase.zookeeper.property.clientPort" + ":" + "zookeeper.znode.parent");
    }

    public static void applyClusterKeyToConf(Configuration conf, String key) throws IOException {
        ZKClusterKey zkClusterKey = ClusterSwitchUtil.transformClusterKey(key);
        conf.set("hbase.zookeeper.quorum", zkClusterKey.quorumString);
        conf.setInt("hbase.zookeeper.property.clientPort", zkClusterKey.clientPort);
        conf.set("zookeeper.znode.parent", zkClusterKey.znodeParent);
    }

    public static String getZooKeeperClusterKey(Configuration conf) {
        String ensemble = conf.get("hbase.zookeeper.quorum").trim();
        StringBuilder builder = new StringBuilder(ensemble);
        builder.append(":");
        builder.append(conf.get("hbase.zookeeper.property.clientPort"));
        builder.append(":");
        builder.append(conf.get("zookeeper.znode.parent"));
        return builder.toString();
    }

    public static String getConnectKey(Configuration conf) {
        AliHBaseConstants.ClusterType clusterType = AliHBaseConstants.ClusterType.valueOf(conf.get("hbase.cluster.type"));
        if (clusterType == AliHBaseConstants.ClusterType.HBASEUE) {
            return conf.get("hbase.client.endpoint");
        }
        return ClusterSwitchUtil.getZooKeeperClusterKey(conf);
    }

    public static Map<Integer, String> parseSlaveClustersNames(Configuration conf) throws IOException {
        try {
            HashMap<Integer, String> slaveClusters = new HashMap<Integer, String>();
            Iterator iter2 = conf.iterator();
            String slavePrefix = "hbase.zookeeper.quorum" + CONF_SEPARATOR;
            Map.Entry entry = null;
            while (iter2.hasNext()) {
                entry = (Map.Entry)iter2.next();
                if (!((String)entry.getKey()).startsWith(slavePrefix)) continue;
                String confKey = (String)entry.getKey();
                String indexStr = confKey.substring(confKey.lastIndexOf(CONF_SEPARATOR) + 1);
                Integer index = Integer.valueOf(indexStr);
                slaveClusters.put(index, confKey);
            }
            return slaveClusters;
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
    }

    public static Configuration createConfForSalveCluster(int index, Configuration conf) throws IOException {
        String baseNodeKey;
        String quorumKey = "hbase.zookeeper.quorum" + CONF_SEPARATOR + index;
        String quorum = conf.get(quorumKey);
        if (quorum == null) {
            throw new IOException("Cluster Conf for slave index " + index + " does not exist");
        }
        Configuration newConf = new Configuration(conf);
        newConf.set("hbase.zookeeper.quorum", quorum);
        String ClientPortKey = "hbase.zookeeper.property.clientPort" + CONF_SEPARATOR + index;
        if (conf.get(ClientPortKey) != null) {
            newConf.set("hbase.zookeeper.property.clientPort", conf.get(ClientPortKey));
        }
        if (conf.get(baseNodeKey = "zookeeper.znode.parent" + CONF_SEPARATOR + index) != null) {
            newConf.set("zookeeper.znode.parent", conf.get(baseNodeKey));
        }
        return newConf;
    }

    public static Configuration createConfWithConnectKey(String connectKey, Configuration conf) throws IOException {
        Configuration newConf = null;
        newConf = conf != null ? new Configuration(conf) : new Configuration();
        if (ClusterSwitchUtil.isValidClusterKey(connectKey)) {
            ZKClusterKey zkClusterKey = ClusterSwitchUtil.transformClusterKey(connectKey);
            newConf.set("hbase.zookeeper.quorum", zkClusterKey.quorumString);
            newConf.set("hbase.zookeeper.property.clientPort", Integer.toString(zkClusterKey.clientPort));
            newConf.set("zookeeper.znode.parent", zkClusterKey.znodeParent);
            newConf.set("hbase.cluster.type", AliHBaseConstants.ClusterType.HBASE.toString());
            newConf.set("hbase.client.connection.impl", "org.apache.hadoop.hbase.client.ConnectionManager.HConnectionImplementation");
        } else if (ClusterSwitchUtil.isValidEndpoint(connectKey)) {
            newConf.set("hbase.client.endpoint", connectKey.trim());
            newConf.set("hbase.cluster.type", AliHBaseConstants.ClusterType.HBASEUE.toString());
            newConf.set("hbase.client.connection.impl", AliHBaseUEConnection.class.getName());
        }
        return newConf;
    }

    public static byte[] toSwitchCommandBytes(String clusterKey, long ts) {
        ClusterSwitchProto.SwitchCommand.Builder builder = ClusterSwitchProto.SwitchCommand.newBuilder();
        return ProtobufUtil.prependPBMagic((byte[])builder.setTargetClusterKey(clusterKey).setTs(ts).build().toByteArray());
    }

    public static SwitchCommand toSwitchCommand(byte[] data) throws IOException {
        if (data == null) {
            return SwitchCommand.NOCOMMAND;
        }
        try {
            ProtobufUtil.expectPBMagicPrefix((byte[])data);
            int prefixLen = ProtobufUtil.lengthOfPBMagic();
            ClusterSwitchProto.SwitchCommand.Builder builder = ClusterSwitchProto.SwitchCommand.newBuilder();
            ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])data, (int)prefixLen, (int)(data.length - prefixLen));
            ClusterSwitchProto.SwitchCommand switchProto = builder.build();
            return new SwitchCommand(switchProto.getTargetClusterKey(), switchProto.getTs());
        }
        catch (DeserializationException e) {
            throw new IOException(e);
        }
    }

    public static boolean isValidClusterKey(String clusterKey) {
        return CLUSTER_KEY_PATTERN.matcher(clusterKey).matches();
    }

    public static boolean isValidEndpoint(String endpoint) {
        return ENDPOINT_PATTERN.matcher(endpoint).matches();
    }

    public static boolean isValidConnectKey(String key) {
        return ClusterSwitchUtil.isValidClusterKey(key) || ClusterSwitchUtil.isValidEndpoint(key);
    }

    public static String getBaseNode(String baseNode, String hacluster) {
        return baseNode + "_" + hacluster;
    }

    public static class ZKClusterKey {
        public String quorumString;
        public int clientPort;
        public String znodeParent;

        ZKClusterKey(String quorumString, int clientPort, String znodeParent) {
            this.quorumString = quorumString;
            this.clientPort = clientPort;
            this.znodeParent = znodeParent;
        }
    }
}

