/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.haclient;

public class SwitchCommand
implements Comparable<SwitchCommand> {
    public static final SwitchCommand NOCOMMAND = new SwitchCommand(null, Long.MIN_VALUE);
    private String clusterKey;
    private long ts;

    public SwitchCommand(String clusterKey, long ts) {
        this.clusterKey = clusterKey;
        this.ts = ts;
    }

    public long getTs() {
        return this.ts;
    }

    public String getClusterKey() {
        return this.clusterKey;
    }

    public boolean isSwitchBackToMaster() {
        return this.ts < 0L || this.clusterKey == null || this.clusterKey.isEmpty();
    }

    public String toString() {
        return "{SwitchCommand: clusterkey=" + this.clusterKey + ", ts=" + this.ts + "}";
    }

    @Override
    public int compareTo(SwitchCommand o) {
        long compare = this.ts - o.ts;
        if (compare != 0L) {
            return (int)compare;
        }
        if (this.clusterKey == null) {
            return o.clusterKey == null ? 0 : -1;
        }
        return this.clusterKey.compareTo(o.clusterKey);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SwitchCommand) {
            return this.compareTo((SwitchCommand)obj) == 0;
        }
        return false;
    }
}

