/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.haclient.dualservice;

import com.alibaba.hbase.client.AliHBaseConstants;
import com.alibaba.hbase.haclient.AliHBaseMultiClusterConnectionImpl;
import com.alibaba.hbase.haclient.ClusterSwitchUtil;
import com.alibaba.hbase.haclient.dualservice.DualUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

public class DualConfigTracker
implements Watcher {
    private static final Log LOG = LogFactory.getLog(DualConfigTracker.class);
    private String quorum;
    private RecoverableZooKeeper zooKeeper;
    public String dualTableNode;
    private String identifier;
    private final AliHBaseMultiClusterConnectionImpl connection;
    private Configuration conf;
    private volatile boolean stopped = false;
    private boolean everConnected = false;
    private int expireTime;
    private final int RETRYCOUNT = 10;
    private Lock zkConnectionLock = new ReentrantLock();

    public DualConfigTracker(Configuration conf, AliHBaseMultiClusterConnectionImpl connection) throws IOException {
        this.conf = conf;
        this.connection = connection;
        this.quorum = ZKConfig.getZKQuorumServersString((Configuration)conf);
        this.dualTableNode = ZKUtil.joinZNode((String)ClusterSwitchUtil.getBaseNode(conf.get("haclient.base.node", "/haclient"), AliHBaseConstants.getHaClusterID(conf)), (String)conf.get(ClusterSwitchUtil.ZOOKEEPER_DUAL_TABLE_NODE, ClusterSwitchUtil.ZOOKEEPER_DUAL_TABLE_NODE_DEFAULT));
        this.expireTime = conf.getInt("zookeeper.session.timeout", 180000);
        this.identifier = this.quorum + "_DualConfigTracker0x0";
        this.zooKeeper = ZKUtil.connect((Configuration)conf, (String)this.quorum, (Watcher)this, (String)this.identifier);
    }

    public String getDualTableNode() {
        return this.dualTableNode;
    }

    public String getQuorum() {
        return this.quorum;
    }

    public void process(WatchedEvent event) {
        LOG.trace((Object)(this.toString() + "Received ZooKeeper Event, " + "type=" + event.getType() + ", " + "state=" + event.getState() + ", " + "path=" + event.getPath()));
        switch (event.getType()) {
            case None: {
                this.connectionEvent(event);
                break;
            }
            case NodeCreated: {
                if (event == null || event.getPath() == null || !event.getPath().startsWith(this.dualTableNode)) break;
                this.updateDualConfig();
                break;
            }
            case NodeDeleted: {
                break;
            }
            case NodeDataChanged: {
                if (event == null || event.getPath() == null || !event.getPath().startsWith(this.dualTableNode)) break;
                this.updateDualConfig();
                break;
            }
            default: {
                throw new IllegalStateException("Received event is not valid: " + event.getState());
            }
        }
    }

    public void connectionEvent(WatchedEvent event) {
        switch (event.getState()) {
            case SyncConnected: {
                if (this.zooKeeper == null) {
                    long finished = System.currentTimeMillis() + this.conf.getLong("hbase.zookeeper.watcher.sync.connected.wait", 2000L);
                    while (System.currentTimeMillis() < finished) {
                        try {
                            if (this.zooKeeper != null) break;
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            LOG.warn((Object)"Interrupted while sleeping");
                            throw new RuntimeException("Interrupted while waiting for recoverableZooKeeper is set");
                        }
                    }
                    if (this.zooKeeper == null) {
                        LOG.error((Object)("ZK is null on connection event for " + this.quorum));
                        throw new NullPointerException("ZK is null for " + this.quorum);
                    }
                }
                this.identifier = this.identifier + "-0x" + Long.toHexString(this.zooKeeper.getSessionId());
                LOG.debug((Object)(this.identifier + " connected"));
                this.updateDualConfig();
                if (this.everConnected) break;
                this.everConnected = true;
                break;
            }
            case Disconnected: {
                LOG.debug((Object)(this.toString() + "Received Disconnected from ZooKeeper, ignoring"));
                break;
            }
            case Expired: {
                LOG.debug((Object)(this.toString() + " received expired from ZooKeeper, reconnecting"));
                this.startThreadForZKReconnection();
                break;
            }
            case ConnectedReadOnly: 
            case SaslAuthenticated: 
            case AuthFailed: {
                break;
            }
            default: {
                throw new IllegalStateException("Received event is not valid: " + event.getState());
            }
        }
    }

    public void updateDualConfig() {
        block4: {
            try {
                if (this.zooKeeper.exists(this.dualTableNode, true) == null) break block4;
                List<String> dualTables = null;
                try {
                    byte[] data = this.zooKeeper.getData(this.dualTableNode, true, null);
                    dualTables = DualUtil.toDualTables(data);
                    DualUtil.flushDualTables(dualTables, this.connection.getConfiguration());
                }
                catch (Exception e) {
                    LOG.warn((Object)("Get dual tables from zk failed, " + e));
                    dualTables = DualUtil.getDualTablesFromXML(this.conf);
                }
                this.connection.updateDualConfig(dualTables);
            }
            catch (Exception e) {
                LOG.warn((Object)("Get data from dual table node " + this.dualTableNode + " failed " + e));
            }
        }
    }

    public synchronized void stop() {
        if (!this.stopped) {
            this.stopped = true;
            LOG.info((Object)("Stopping tracker on cluster " + this.quorum));
            this.closeZookeeper();
        }
    }

    private void closeZookeeper() {
        if (this.zooKeeper != null) {
            try {
                if (this.zooKeeper != null) {
                    this.zooKeeper.close();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.zooKeeper = null;
        }
    }

    private void startThreadForZKReconnection() {
        if (this.zooKeeper == null) {
            return;
        }
        Thread t = new Thread(){
            private int retryCount = 10;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!DualConfigTracker.this.zkConnectionLock.tryLock()) {
                    return;
                }
                try {
                    DualConfigTracker.this.closeZookeeper();
                    while (!DualConfigTracker.this.stopped && this.retryCount > 0) {
                        try {
                            if (DualConfigTracker.this.zooKeeper == null) {
                                DualConfigTracker.this.zooKeeper = ZKUtil.connect((Configuration)DualConfigTracker.this.conf, (String)DualConfigTracker.this.quorum, (Watcher)DualConfigTracker.this, (String)DualConfigTracker.this.identifier);
                            }
                            LOG.info((Object)("Successfully reconnected to dual config tracker on zk '" + DualConfigTracker.this.quorum + "'"));
                            break;
                        }
                        catch (Throwable t) {
                            LOG.warn((Object)("Failed reconnecting to dual config tracker on zk '" + DualConfigTracker.this.quorum + "', will retry again..."), t);
                            Threads.sleep((long)30000L);
                            --this.retryCount;
                        }
                    }
                    if (DualConfigTracker.this.zooKeeper == null && this.retryCount == 0) {
                        LOG.warn((Object)("Failed reconnecting to dual config tracker on zk '" + DualConfigTracker.this.quorum + " after " + 10 + " times"));
                    }
                }
                finally {
                    DualConfigTracker.this.zkConnectionLock.unlock();
                }
            }
        };
        t.setDaemon(true);
        t.setName("DualConfigTracker-ZK-Reconnection-" + System.currentTimeMillis());
        t.start();
    }

    @VisibleForTesting
    public RecoverableZooKeeper getZooKeeper() {
        return this.zooKeeper;
    }

    public String toString() {
        return this.identifier + ", trackNode=" + this.dualTableNode + " ";
    }
}

