/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.acl;

import java.util.ArrayList;
import java.util.List;

public enum Action {
    READ('R'),
    WRITE('W'),
    ADMIN('A'),
    TRASH('T'),
    SYSTEM('S');

    private byte code;

    private Action(char code) {
        this.code = (byte)code;
    }

    public byte code() {
        return this.code;
    }

    public static List<Action> getActionFromStrings(String ... strs) {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (String str : strs) {
            str = str.toUpperCase();
            Action action = Enum.valueOf(Action.class, str);
            actions.add(action);
        }
        return actions;
    }

    public static List<String> getStringFromActions(Action ... actions) {
        ArrayList<String> actionStrs = new ArrayList<String>();
        for (Action action : actions) {
            actionStrs.add(action.toString());
        }
        return actionStrs;
    }
}

