/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.command;

import com.alibaba.lindorm.client.core.command.Command;
import com.alibaba.lindorm.client.core.command.CommandResult;
import com.alibaba.lindorm.client.core.ipc.LConnection;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class GetConfCommand
extends Command {
    private static Command.Type type = Command.Type.GETCONF;
    private Set<String> confKeys;

    public GetConfCommand() {
        this.confKeys = null;
    }

    public GetConfCommand(String ... keys) {
        if (keys != null) {
            this.confKeys = new HashSet<String>();
            for (String key : keys) {
                if (key == null || (key = key.trim()).length() == 0) continue;
                this.confKeys.add(key);
            }
        } else {
            this.confKeys = null;
        }
    }

    public Set<String> getConfKeys() {
        return this.confKeys;
    }

    @Override
    public Command.Type getType() {
        return type;
    }

    @Override
    public CommandResult run(LConnection lConnection) {
        String confDump = lConnection.getConfig().dumpConfiguration(this.confKeys);
        return new CommandResult(confDump, type, this.commandID);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        if (this.confKeys == null) {
            WritableUtils.writeVInt(out, 0);
        } else {
            WritableUtils.writeVInt(out, this.confKeys.size());
            for (String key : this.confKeys) {
                WritableUtils.writeString(out, key);
            }
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        int size = WritableUtils.readVInt(in);
        if (size > 0) {
            this.confKeys = new HashSet<String>();
        }
        for (int i = 0; i < size; ++i) {
            String key = WritableUtils.readString(in);
            this.confKeys.add(key);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append("confkeys= ").append(this.confKeys);
        return builder.toString();
    }
}

