/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.compile;

import com.alibaba.lindorm.client.core.compile.Interval;
import com.alibaba.lindorm.client.core.compile.QueryFilterInfo;
import java.util.Collections;
import java.util.List;

public class IntervalQuery {
    private final Interval interval;
    private final List<QueryFilterInfo> filters;
    private int hashCode = 0;

    public IntervalQuery(Interval interval) {
        this.interval = interval;
        this.filters = null;
    }

    public IntervalQuery(Interval interval, QueryFilterInfo filterInfo) {
        this.interval = interval;
        this.filters = filterInfo == null || filterInfo.getColumnSlots() == null ? null : Collections.singletonList(filterInfo);
    }

    public IntervalQuery(Interval interval, List<QueryFilterInfo> filter) {
        this.interval = interval;
        this.filters = filter;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public List<QueryFilterInfo> getFilters() {
        return this.filters;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("interval: ");
        builder.append(this.interval);
        builder.append(" - filter: ");
        if (this.filters == null) {
            builder.append("[]");
        } else {
            builder.append("[");
            for (int i = 0; i < this.filters.size(); ++i) {
                if (i != 0) {
                    builder.append(" OR ");
                }
                builder.append(this.filters.get(i));
            }
            builder.append("]");
        }
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntervalQuery)) {
            return false;
        }
        IntervalQuery other = (IntervalQuery)obj;
        if (this.interval == null ? other.interval != null : !this.interval.equals(other.interval)) {
            return false;
        }
        return this.filters == null ? other.filters == null : this.filters.equals(other.filters);
    }

    public int hashCode() {
        if (this.hashCode == 0 && (this.interval != null || this.filters != null)) {
            int result = 0;
            if (this.interval != null) {
                result = 31 * result + this.interval.hashCode();
            }
            if (this.filters != null) {
                for (QueryFilterInfo filter : this.filters) {
                    result = 31 * result + filter.hashCode();
                }
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }
}

