/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc;

import com.alibaba.hbase.net.jpountz.lz4.LZ4Factory;
import com.alibaba.lindorm.client.core.ipc.LindormObject;
import com.alibaba.lindorm.client.core.ipc.Serializer;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.exception.NotImplementedException;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;

public class Invocation
implements LindormObject {
    protected String methodName;
    protected Class[] parameterClasses;
    protected Object[] parameters;
    private long clientVersion;
    private int clientMethodsHash;
    private Serializer serializer;
    private int compressThreshold;
    private static final LZ4Factory factory = LZ4Factory.fastestJavaInstance();
    protected static byte RPC_VERSION = 1;
    private static final String VERSION = "VERSION";
    public static final int MD5_HEX_LENGTH = 32;

    public Invocation() {
    }

    public Invocation(Class<?> protocol, Method method, Object[] parameters, Serializer serializer, int compressThreshold) {
        this.methodName = method.getName();
        this.parameterClasses = method.getParameterTypes();
        this.parameters = parameters;
        this.serializer = serializer;
        try {
            Field versionField = protocol.getField(VERSION);
            versionField.setAccessible(true);
            this.clientVersion = versionField.getLong(protocol);
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException("The " + method.getDeclaringClass(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        this.clientMethodsHash = 0;
        this.compressThreshold = compressThreshold;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class[] getParameterClasses() {
        return this.parameterClasses;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    long getProtocolVersion() {
        return this.clientVersion;
    }

    protected int getClientMethodsHash() {
        return this.clientMethodsHash;
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        throw new NotImplementedException("Client side invocation has no read from method");
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        out.writeByte(this.getVersion());
        if (RPC_VERSION == 1) {
            out.writeUTF(this.methodName);
            out.writeLong(this.clientVersion);
            out.writeInt(this.clientMethodsHash);
            out.writeInt(this.parameterClasses.length);
            for (int i = 0; i < this.parameterClasses.length; ++i) {
                this.serializer.serialize(out, this.parameters[i], this.parameterClasses[i]);
            }
        } else {
            if (this.compressThreshold == Integer.MAX_VALUE) {
                out.writeBoolean(false);
                out.writeUTF(this.methodName);
                out.writeLong(this.clientVersion);
                out.writeInt(this.clientMethodsHash);
                out.writeInt(this.parameterClasses.length);
                for (int i = 0; i < this.parameterClasses.length; ++i) {
                    this.serializer.serialize(out, this.parameters[i], this.parameterClasses[i]);
                }
                return;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            DataOutputStream tmp = new DataOutputStream(byteArrayOutputStream);
            tmp.writeUTF(this.methodName);
            tmp.writeLong(this.clientVersion);
            tmp.writeInt(this.clientMethodsHash);
            tmp.writeInt(this.parameterClasses.length);
            for (int i = 0; i < this.parameterClasses.length; ++i) {
                this.serializer.serialize(tmp, this.parameters[i], this.parameterClasses[i]);
            }
            if (tmp.size() > this.compressThreshold) {
                out.writeBoolean(true);
                out.writeInt(byteArrayOutputStream.size());
                byte[] compressed = factory.fastCompressor().compress(byteArrayOutputStream.toByteArray());
                out.writeInt(compressed.length);
                out.write(compressed);
            } else {
                out.writeBoolean(false);
                out.write(byteArrayOutputStream.toByteArray());
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(this.methodName);
        buffer.append("(");
        for (int i = 0; i < this.parameters.length; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            if (this.parameterClasses[i] == byte[].class) {
                byte[] byteParam = (byte[])this.parameters[i];
                if (byteParam.length <= 1000) {
                    buffer.append(Bytes.toStringBinary(byteParam));
                } else {
                    buffer.append("..." + Bytes.toStringBinary(byteParam, byteParam.length - 1000 - 1, 1000));
                }
                buffer.append(Bytes.toStringBinary((byte[])this.parameters[i]));
                continue;
            }
            if (this.parameterClasses[i] == List.class) {
                int appendNum = 0;
                List listParam = (List)this.parameters[i];
                buffer.append("[");
                for (Object o : listParam) {
                    if (appendNum > 0) {
                        buffer.append(",");
                    }
                    if (buffer.length() >= 10000) break;
                    String paramString = o.toString();
                    if (paramString.length() > 1000) {
                        buffer.append(paramString.substring(0, 1000));
                        buffer.append("..");
                    } else {
                        buffer.append(paramString);
                    }
                    ++appendNum;
                }
                if (appendNum < listParam.size()) {
                    buffer.append(",");
                    buffer.append("[...count=" + listParam.size() + "]");
                }
                buffer.append("]");
                continue;
            }
            if (this.parameters[i] == null) {
                buffer.append("null");
                continue;
            }
            String param = this.parameters[i].toString();
            if (param.length() > 1000) {
                buffer.append(param.substring(0, 1000));
                buffer.append("..");
                continue;
            }
            buffer.append(param);
        }
        buffer.append(")");
        buffer.append(", rpc version=" + RPC_VERSION);
        buffer.append(", client version=" + this.clientVersion);
        buffer.append(", methodsFingerPrint=" + this.clientMethodsHash);
        return buffer.toString();
    }

    public String toSimpleString() {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(this.methodName);
        buffer.append("(");
        if (this.parameters == null) {
            buffer.append("noparam");
        } else {
            for (int i = 0; i < this.parameters.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                if (byte[].class.equals((Object)this.parameterClasses[i])) {
                    byte[] byteParam = (byte[])this.parameters[i];
                    if (byteParam == null) {
                        buffer.append("empty bytes");
                        continue;
                    }
                    if (byteParam.length <= 32) {
                        buffer.append(Bytes.toStringBinary(byteParam));
                        continue;
                    }
                    buffer.append("..." + Bytes.toStringBinary(byteParam, byteParam.length - 32 - 1, 32));
                    continue;
                }
                if (this.parameterClasses[i] == List.class) {
                    int appendNum = 0;
                    List listParam = (List)this.parameters[i];
                    buffer.append("[");
                    for (Object o : listParam) {
                        if (appendNum > 0) {
                            buffer.append(",");
                        }
                        if (buffer.length() >= 10000) break;
                        buffer.append(o);
                        ++appendNum;
                    }
                    if (appendNum < listParam.size()) {
                        buffer.append(",");
                        buffer.append("[...count=" + listParam.size() + "]");
                    }
                    buffer.append("]");
                    continue;
                }
                if (this.parameters[i] != null) {
                    buffer.append(this.parameterClasses[i].getSimpleName());
                    continue;
                }
                buffer.append("null");
            }
        }
        buffer.append(")");
        return buffer.toString();
    }

    public byte getVersion() {
        return RPC_VERSION;
    }
}

