/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc;

import com.alibaba.lindorm.client.core.auth.AuthenticationPassport;
import com.alibaba.lindorm.client.core.ipc.LindormObject;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RpcOptionalParams
implements LindormObject {
    @Deprecated
    public static final byte CLIENT_WAIT_TIME = 1;
    public static final byte CLIENT_SEND_TIME = 2;
    public static final byte SERVER_RECEIVE_TIMESTAMP = 3;
    public static final byte SERVER_EXECUTION_TIME = 4;
    public static final byte USERNAME = 5;
    public static final byte SIGNATURE = 6;
    public static final byte SIGNATURE_TIMESTAMP = 7;
    public static final byte AUTHENTICATION_PASSPORT = 8;
    public static final byte CLIENT_VERSION = 9;
    public static final byte DO_AS_USER = 10;
    public static final byte SKIP_CONSISTENCY_CEHCK = 11;
    public static final byte CLIENT_WAIT_TIME_MS = 12;
    private Map<Byte, byte[]> options = new HashMap<Byte, byte[]>();

    public String getUsername() {
        byte[] value = this.options.get((byte)5);
        if (value == null) {
            return null;
        }
        return Bytes.toString(value);
    }

    public byte[] getSignature() {
        return this.options.get((byte)6);
    }

    public Long getSignatureTimestamp() {
        byte[] value = this.options.get((byte)7);
        if (value == null) {
            return null;
        }
        return Bytes.toLong(value);
    }

    public Integer getMaxClientWaitTime() {
        byte[] value = this.options.get((byte)12);
        if (value != null) {
            return Bytes.toInt(value);
        }
        value = this.options.get((byte)1);
        if (value == null) {
            return 0;
        }
        return Bytes.toShort(value) * 1000;
    }

    public Long getClientSendTime() {
        byte[] value = this.options.get((byte)2);
        if (value == null) {
            return null;
        }
        return Bytes.toLong(value);
    }

    public Long getServerReceiveTimestamp() {
        byte[] value = this.options.get((byte)3);
        if (value == null) {
            return null;
        }
        return Bytes.toLong(value);
    }

    public Integer getServerExceutionTime() {
        byte[] value = this.options.get((byte)4);
        if (value == null) {
            return null;
        }
        return Bytes.toInt(value);
    }

    public void setUsername(String userName) {
        this.options.put((byte)5, Bytes.toBytes(userName));
    }

    public void setSignature(byte[] signature) {
        this.options.put((byte)6, signature);
    }

    public void setDoAsUser(String doAsUser) {
        this.options.put((byte)10, Bytes.toBytes(doAsUser));
    }

    public void setSignatureTimestamp(long signatureTimestamp) {
        this.options.put((byte)7, Bytes.toBytes(signatureTimestamp));
    }

    public void setMaxClientWaitTime(int clientWaitTime) {
        short clientWaitTimeS = (short)((clientWaitTime + 999) / 1000);
        this.options.put((byte)1, Bytes.toBytes(clientWaitTimeS));
        this.options.put((byte)12, Bytes.toBytes(clientWaitTime));
    }

    public void setClientSendTime(long clientStartTime) {
        this.options.put((byte)2, Bytes.toBytes(clientStartTime));
    }

    public void setServerReceiveTimestmp(long receiveTimestamp) {
        this.options.put((byte)3, Bytes.toBytes(receiveTimestamp));
    }

    public void setServerExecutionTime(int executionTime) {
        this.options.put((byte)4, Bytes.toBytes(executionTime));
    }

    public void setSkipConsistencyCheck(boolean skipConsistencyCheck) {
        this.options.put((byte)11, Bytes.toBytes(skipConsistencyCheck));
    }

    public Boolean skipConsistencyCheck() {
        byte[] value = this.options.get((byte)11);
        if (value == null) {
            return null;
        }
        return Bytes.toBoolean(value);
    }

    public AuthenticationPassport getAuthPassport() throws IOException {
        byte[] value = this.options.get((byte)8);
        if (value == null) {
            return null;
        }
        AuthenticationPassport passport = new AuthenticationPassport();
        WritableUtils.getWritable(value, passport);
        return passport;
    }

    public void setClientVersion(String version) {
        if (version != null) {
            this.options.put((byte)9, Bytes.toBytes(version));
        }
    }

    public String getClientVersion() {
        byte[] value = this.options.get((byte)9);
        if (value == null) {
            return null;
        }
        return Bytes.toString(value);
    }

    public String getDoAsUser() {
        byte[] value = this.options.get((byte)10);
        if (value == null) {
            return null;
        }
        return Bytes.toString(value);
    }

    public void setAuthPassport(AuthenticationPassport passport) throws IOException {
        this.options.put((byte)8, WritableUtils.getBytes(passport));
    }

    @Override
    public void readFrom(DataInput dis) throws IOException {
        int optionSize = dis.readInt();
        for (int i = 0; i < optionSize; ++i) {
            byte tag = dis.readByte();
            int len = dis.readInt();
            byte[] value = new byte[len];
            dis.readFully(value);
            this.options.put(tag, value);
        }
    }

    @Override
    public void writeTo(DataOutput output) throws IOException {
        output.writeInt(this.options.size());
        for (Map.Entry<Byte, byte[]> option : this.options.entrySet()) {
            output.writeByte(option.getKey().byteValue());
            output.writeInt(option.getValue().length);
            output.write(option.getValue());
        }
    }
}

