/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc.locator;

import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.core.ipc.LDServerAddress;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PingDelayMeasurer {
    private static final Log LOG = LogFactory.getLog((String)PingDelayMeasurer.class.getName());
    private int pingTimeout;
    protected LindormClientConfig config;
    private static final String OS = System.getProperty("os.name");
    private static final boolean PING_TOOL_AVAILABLE = OS.startsWith("Linux") || OS.startsWith("Mac") || OS.startsWith("SunOS");
    private static final Pattern UNIX_PING_TIME_PATTERN = Pattern.compile(".*?([\\d.]+)\\s?ms.*");

    public PingDelayMeasurer(LindormClientConfig config) {
        this.onConfigChange(config);
    }

    public LindormClientConfig getConf() {
        return this.config;
    }

    public long getPingDelay(LDServerAddress address) throws IOException {
        InetAddress inetAddress = InetAddress.getByName(address.getHostname());
        long start = System.nanoTime();
        if (inetAddress.isReachable(this.pingTimeout)) {
            return System.nanoTime() - start;
        }
        if (PING_TOOL_AVAILABLE) {
            return this.getDelayByCMD(inetAddress);
        }
        return Long.MAX_VALUE;
    }

    public void onConfigChange(LindormClientConfig config) {
        this.config = config;
        this.pingTimeout = config.getInt("lindorm.rpc.idc.ping.timeout", 1000);
    }

    public long getDelayByCMD(InetAddress inetAddress) throws IOException {
        int timeoutInSeconds = Math.max((int)Math.ceil((float)this.pingTimeout / 1000.0f), 1);
        StringBuilder cmd = new StringBuilder("ping -c 1 ");
        cmd.append("-W ").append(" ").append(timeoutInSeconds).append(" ").append(inetAddress.getHostName());
        long start = System.nanoTime();
        Process p = Runtime.getRuntime().exec(cmd.toString());
        try {
            String line;
            if (p.waitFor() == 0) {
                String line2;
                long costInNano = System.nanoTime() - start;
                BufferedReader inputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line2 = inputStream.readLine()) != null) {
                    Matcher matcher = UNIX_PING_TIME_PATTERN.matcher(line2);
                    if (!matcher.matches()) continue;
                    float ms = Float.parseFloat(matcher.group(1));
                    return (long)(ms * 1000.0f * 1000.0f);
                }
                return costInNano;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            throw new IOException(inetAddress.getHostName() + " is not reachable by unix ping, " + sb);
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted when pinging " + inetAddress.getHostName());
        }
    }
}

