/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.meta;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Date;

public class SilenceIndex
extends VersionedObjectWithAttributes {
    private byte indexID;
    private String indexName;
    private String tableName;
    private long delTime;

    public SilenceIndex() {
    }

    public SilenceIndex(byte indexID, String indexName, String tableName, long delTime) {
        this.indexID = indexID;
        this.indexName = indexName;
        this.tableName = tableName;
        this.delTime = delTime;
    }

    public byte getIndexID() {
        return this.indexID;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public long getDelTime() {
        return this.delTime;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeVInt(out, this.indexID);
        WritableUtils.writeString(out, this.indexName);
        WritableUtils.writeString(out, this.tableName);
        WritableUtils.writeVLong(out, this.delTime);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.indexID = (byte)WritableUtils.readVInt(in);
        this.indexName = WritableUtils.readString(in);
        this.tableName = WritableUtils.readString(in);
        this.delTime = WritableUtils.readVLong(in);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SilenceIndex that = (SilenceIndex)o;
        if (this.hashCode() != that.hashCode()) {
            return false;
        }
        return this.indexID == that.indexID && this.delTime == that.delTime && this.indexName.equals(that.indexName) && this.tableName.equals(that.tableName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.indexID;
        result = 31 * result + (this.indexName != null ? this.indexName.hashCode() : 0);
        result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
        result = 31 * result + new Date(this.delTime).hashCode();
        return result;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[SilenceIndex:, index id:" + this.indexID + ", index name:" + this.indexName + ", table name:" + this.tableName + ", delete time:" + new Date(this.delTime) + "]");
        return stringBuilder.toString();
    }
}

