/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.metrics;

import com.alibaba.lindorm.client.core.ipc.OperationContext;
import com.alibaba.lindorm.client.core.metrics.OperationMetrics;
import com.alibaba.lindorm.client.core.metrics.OperationMetricsSnapshot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TableMetrics {
    private static final Log LOG = LogFactory.getLog((String)TableMetrics.class.getName());
    private String namespace;
    private String table;
    private Map<OperationContext.OperationType, OperationMetrics> opMetricsMap = new HashMap<OperationContext.OperationType, OperationMetrics>();
    private Map<OperationContext.OperationType, ConcurrentLinkedQueue<OperationMetricsSnapshot>> snapshotMap = new HashMap<OperationContext.OperationType, ConcurrentLinkedQueue<OperationMetricsSnapshot>>();

    public TableMetrics(String namespace, String table, List<OperationContext.OperationType> operationTypes) {
        for (OperationContext.OperationType type : operationTypes) {
            OperationMetrics operationMetrics = new OperationMetrics();
            this.opMetricsMap.put(type, operationMetrics);
            this.snapshotMap.put(type, new ConcurrentLinkedQueue());
        }
        this.namespace = namespace;
        this.table = table;
    }

    public void onSuccess(OperationContext.OperationType type, long timeTook, int row) {
        OperationMetrics metrics = this.opMetricsMap.get((Object)type);
        if (metrics == null) {
            return;
        }
        metrics.onSuccess(timeTook, row);
    }

    public void onError(OperationContext.OperationType type, Throwable t) {
        OperationMetrics metrics = this.opMetricsMap.get((Object)type);
        if (metrics == null) {
            return;
        }
        metrics.onError(t);
    }

    public void snapshot(long now, long timeToExpire, boolean printLog) {
        StringBuilder sb = null;
        if (printLog) {
            sb = new StringBuilder(1024);
            sb.append("Metrics: namespace: ").append(this.namespace).append(" table: ").append(this.table).append("\n");
        }
        for (Map.Entry<OperationContext.OperationType, OperationMetrics> entry : this.opMetricsMap.entrySet()) {
            OperationMetricsSnapshot oldSnapshot;
            OperationContext.OperationType type = entry.getKey();
            OperationMetrics metrics = entry.getValue();
            OperationMetricsSnapshot snapshot = metrics.snapshot(now);
            ConcurrentLinkedQueue<OperationMetricsSnapshot> snapshots = this.snapshotMap.get((Object)type);
            if (snapshots != null && snapshot != null) {
                snapshots.add(snapshot);
                if (sb != null) {
                    sb.append("[Operation Type: ").append((Object)type).append("]\n");
                    sb.append(TableMetrics.buildMetricsLog(snapshot));
                }
            }
            if (snapshot == null) continue;
            Iterator<OperationMetricsSnapshot> iter2 = snapshots.iterator();
            while (iter2.hasNext() && (oldSnapshot = iter2.next()).getEndTime() < timeToExpire) {
                iter2.remove();
            }
        }
        if (sb != null) {
            LOG.info((Object)sb.toString());
        }
    }

    public List<OperationMetricsSnapshot> getSnapshotInRange(OperationContext.OperationType type, long begin, long end) {
        ArrayList<OperationMetricsSnapshot> ret = new ArrayList<OperationMetricsSnapshot>();
        ConcurrentLinkedQueue<OperationMetricsSnapshot> snapshots = this.snapshotMap.get((Object)type);
        if (snapshots == null) {
            return ret;
        }
        for (OperationMetricsSnapshot snapshot : snapshots) {
            if (!(snapshot.getStartTime() >= begin && snapshot.getEndTime() < end || begin >= snapshot.getStartTime() && end <= snapshot.getEndTime() || begin >= snapshot.getStartTime() && begin <= snapshot.getEndTime()) && (end < snapshot.getStartTime() || end > snapshot.getEndTime())) continue;
            ret.add(snapshot);
        }
        return ret;
    }

    public static String buildMetricsLog(OperationMetricsSnapshot snapshot) {
        return TableMetrics.buildMetricsLog(snapshot.getStartTime(), snapshot.getEndTime(), snapshot.getTotalRowCount(), snapshot.getSuccessOps(), snapshot.getErrorOps(), snapshot.getSumTime(), snapshot.getMaxTime(), snapshot.getRt0(), snapshot.getRt1(), snapshot.getRt5(), snapshot.getRt10(), snapshot.getRt50(), snapshot.getRt100(), snapshot.getRt500(), snapshot.getRt1000(), snapshot.getRt1001());
    }

    public static String buildMetricsLog(long startTime, long endTime, long totalRowCount, long successOps, long errorOps, long sumTime, long maxTime, long rt0, long rt1, long rt5, long rt10, long rt50, long rt100, long rt500, long rt1000, long rt1001) {
        if (totalRowCount > 0L) {
            long timeSpend = endTime - startTime;
            StringBuilder sb = new StringBuilder(512);
            sb.append("Time Interval: ").append(timeSpend / 1000L).append("s\n");
            sb.append("Total Rows: ").append(totalRowCount).append(" TPS/QPS: ").append(totalRowCount * 1000L / timeSpend).append("/s\n");
            sb.append("Total Requests: ").append(successOps + errorOps).append(" Success: ").append(successOps).append(" RowsPerRequest: ").append(totalRowCount / successOps).append("\n");
            sb.append("AVG RT: ").append(sumTime / successOps).append("ms").append(" MAX RT: ").append(maxTime).append("ms\n");
            sb.append(" RT <= 0: ").append(rt0 * 100L / successOps).append("% ").append(rt0).append("/").append(successOps).append("\n");
            sb.append(" RT (0,1]: ").append(rt1 * 100L / successOps).append("% ").append(rt1).append("/").append(successOps).append("\n");
            sb.append(" RT (1,5]: ").append(rt5 * 100L / successOps).append("% ").append(rt5).append("/").append(successOps).append("\n");
            sb.append(" RT (5,10]: ").append(rt10 * 100L / successOps).append("% ").append(rt10).append("/").append(successOps).append("\n");
            sb.append(" RT (10,50]: ").append(rt50 * 100L / successOps).append("% ").append(rt50).append("/").append(successOps).append("\n");
            sb.append(" RT (50,100]: ").append(rt100 * 100L / successOps).append("% ").append(rt100).append("/").append(successOps).append("\n");
            sb.append(" RT (100,500]: ").append(rt500 * 100L / successOps).append("% ").append(rt500).append("/").append(successOps).append("\n");
            sb.append(" RT (500,1000]: ").append(rt1000 * 100L / successOps).append("% ").append(rt1000).append("/").append(successOps).append("\n");
            sb.append(" RT > 1000: ").append(rt1001 * 100L / successOps).append("% ").append(rt1001).append("/").append(successOps).append("\n\n");
            return sb.toString();
        }
        return "No ops\n";
    }
}

