/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.tableservice;

import com.alibaba.lindorm.client.AsyncCallback;
import com.alibaba.lindorm.client.core.LindormTableService;
import com.alibaba.lindorm.client.core.expression.ExpressionType;
import com.alibaba.lindorm.client.core.ipc.ClientCompletableFuture;
import com.alibaba.lindorm.client.core.ipc.LServerCallable;
import com.alibaba.lindorm.client.core.ipc.OperationContext;
import com.alibaba.lindorm.client.core.ipc.RetryingCaller;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.tableservice.AggregateOperation;
import com.alibaba.lindorm.client.core.tableservice.DmlOperation;
import com.alibaba.lindorm.client.core.tableservice.LAggregateResult;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.CompilerUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.Aggregate;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.dml.Row;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.exception.TableNotFoundException;
import com.alibaba.lindorm.client.schema.DataType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Future;

public class LAggregate
extends DmlOperation
implements Aggregate {
    public static final String ALLOW_FILTERING_ATTR = "ALLOW_FILTERING";
    private boolean isExplain = false;
    private boolean parallelExe = true;
    private Condition where;
    private List<AggregateOperation> operations = null;
    private Boolean allowFiltering = null;

    public LAggregate() {
    }

    public LAggregate(LindormTableService service) {
        super(service);
        this.operations = CollectionUtils.newArrayList();
    }

    @Override
    public Aggregate from(String tableName) throws LindormException {
        if (this.service != null) {
            this.namespace = this.service.getNamespace();
        }
        this.tableName = tableName;
        return this;
    }

    @Override
    public Aggregate where(Condition where) {
        this.where = where;
        return this;
    }

    @Override
    public Aggregate count() throws LindormException {
        this.operations.add(AggregateOperation.count());
        return this;
    }

    @Override
    public Aggregate count(String columnName) throws LindormException {
        this.operations.add(AggregateOperation.count(new ColumnKey(columnName)));
        return this;
    }

    @Override
    public Aggregate count(String familyName, String columnName) throws LindormException {
        this.operations.add(AggregateOperation.count(new ColumnKey(familyName, columnName)));
        return this;
    }

    @Override
    public Aggregate countAs(String aliasedName) throws LindormException {
        this.operations.add(AggregateOperation.count(null, aliasedName));
        return this;
    }

    @Override
    public Aggregate countAs(String columnName, String aliasedName) throws LindormException {
        this.operations.add(AggregateOperation.count(new ColumnKey(columnName), aliasedName));
        return this;
    }

    @Override
    public Aggregate countAs(String familyName, String columnName, String aliasedName) throws LindormException {
        this.operations.add(AggregateOperation.count(new ColumnKey(familyName, columnName), aliasedName));
        return this;
    }

    @Override
    public Aggregate sum(String columnName) throws LindormException {
        this.operations.add(AggregateOperation.sum(new ColumnKey(columnName)));
        return this;
    }

    @Override
    public Aggregate sum(String familyName, String columnName) throws LindormException {
        this.operations.add(AggregateOperation.sum(new ColumnKey(familyName, columnName)));
        return this;
    }

    @Override
    public Aggregate sumAs(String columnName, String aliasedName) throws LindormException {
        this.operations.add(AggregateOperation.sum(new ColumnKey(columnName), aliasedName));
        return this;
    }

    @Override
    public Aggregate sumAs(String familyName, String columnName, String aliasedName) throws LindormException {
        this.operations.add(AggregateOperation.sum(new ColumnKey(familyName, columnName), aliasedName));
        return this;
    }

    @Override
    public Aggregate sumAs(String familyName, String columnName, String aliasedName, DataType interpreterDatatype) throws LindormException {
        this.operations.add(AggregateOperation.sum(new ColumnKey(familyName, columnName), aliasedName).setInterpreterDatatype(interpreterDatatype));
        return this;
    }

    @Override
    public Aggregate avg(String columnName) throws LindormException {
        this.operations.add(AggregateOperation.avg(new ColumnKey(columnName)));
        return this;
    }

    @Override
    public Aggregate avg(String familyName, String columnName) throws LindormException {
        this.operations.add(AggregateOperation.avg(new ColumnKey(familyName, columnName)));
        return this;
    }

    @Override
    public Aggregate avgAs(String columnName, String aliasedName) throws LindormException {
        this.operations.add(AggregateOperation.avg(new ColumnKey(columnName), aliasedName));
        return this;
    }

    @Override
    public Aggregate avgAs(String familyName, String columnName, String aliasedName) throws LindormException {
        this.operations.add(AggregateOperation.avg(new ColumnKey(familyName, columnName), aliasedName));
        return this;
    }

    @Override
    public Aggregate avgAs(String familyName, String columnName, String aliasedName, DataType interpreterDatatype) throws LindormException {
        this.operations.add(AggregateOperation.avg(new ColumnKey(familyName, columnName), aliasedName).setInterpreterDatatype(interpreterDatatype));
        return this;
    }

    @Override
    public Aggregate min(String columnName) throws LindormException {
        this.operations.add(AggregateOperation.min(new ColumnKey(columnName)));
        return this;
    }

    @Override
    public Aggregate min(String familyName, String columnName) throws LindormException {
        this.operations.add(AggregateOperation.min(new ColumnKey(familyName, columnName)));
        return this;
    }

    @Override
    public Aggregate minAs(String columnName, String aliasedName) throws LindormException {
        this.operations.add(AggregateOperation.min(new ColumnKey(columnName), aliasedName));
        return this;
    }

    @Override
    public Aggregate minAs(String familyName, String columnName, String aliasedName) throws LindormException {
        this.operations.add(AggregateOperation.min(new ColumnKey(familyName, columnName), aliasedName));
        return this;
    }

    @Override
    public Aggregate max(String columnName) throws LindormException {
        this.operations.add(AggregateOperation.max(new ColumnKey(columnName)));
        return this;
    }

    @Override
    public Aggregate max(String familyName, String columnName) throws LindormException {
        this.operations.add(AggregateOperation.max(new ColumnKey(familyName, columnName)));
        return this;
    }

    @Override
    public Aggregate maxAs(String columnName, String aliasedName) throws LindormException {
        this.operations.add(AggregateOperation.max(new ColumnKey(columnName), aliasedName));
        return this;
    }

    @Override
    public Aggregate maxAs(String familyName, String columnName, String aliasedName) throws LindormException {
        this.operations.add(AggregateOperation.max(new ColumnKey(familyName, columnName), aliasedName));
        return this;
    }

    @Override
    public Aggregate explain() {
        this.isExplain = true;
        return this;
    }

    @Override
    public Aggregate explain(boolean isExplain) {
        this.isExplain = isExplain;
        return this;
    }

    public boolean isAllowFiltering() {
        return this.allowFiltering != null && this.allowFiltering != false;
    }

    @Override
    public Aggregate allowFiltering(boolean value) {
        this.allowFiltering = value;
        return this;
    }

    @Override
    public Aggregate setQueryHotOnly(Boolean hotOnly) {
        if (hotOnly == null) {
            this.removeAttribute("HOT_ONLY");
        } else {
            this.setAttribute("HOT_ONLY", Bytes.toBytes(hotOnly));
        }
        return this;
    }

    @Override
    public void internalSetTTL(long ttl) {
        throw new UnsupportedOperationException("Setting TTLs on Aggregate is not supported");
    }

    @Override
    public boolean isQueryHotOnly() {
        byte[] value = this.getAttribute("HOT_ONLY");
        return value != null && Bytes.toBoolean(value);
    }

    public boolean isParallelExe() {
        return this.parallelExe;
    }

    public void setParallelExe(boolean isParallelExe) {
        this.parallelExe = isParallelExe;
    }

    public boolean isExplain() {
        return this.isExplain;
    }

    public Condition getWhere() {
        return this.where;
    }

    public List<AggregateOperation> getAggregateOperations() {
        return this.operations;
    }

    private LServerCallable<LAggregateResult> buildAggregateCallable() {
        return new LServerCallable<LAggregateResult>((DmlOperation)this, OperationContext.OperationType.AGGREGATE){

            @Override
            public LAggregateResult call() throws Exception {
                return this.server.aggregate(LAggregate.this);
            }
        };
    }

    @Override
    public Future<Row> executeAsync() throws LindormException {
        final ClientCompletableFuture<Row> future = new ClientCompletableFuture<Row>();
        this.executeAsync(new AsyncCallback<Row>(){

            @Override
            public void onComplete(Row result) {
                future.complete(result);
            }

            @Override
            public void onError(Throwable exception) {
                future.completeExceptionally(exception);
            }

            @Override
            public boolean shouldProcessResultInPool() {
                return false;
            }
        });
        return future;
    }

    @Override
    public void executeAsync(AsyncCallback<Row> callback) throws LindormException {
        this.validate();
        this.setupRouteKey();
        OperationContext.OperationType operationType = OperationContext.OperationType.AGGREGATE;
        LServerCallable<LAggregateResult> aggregateCallable = this.buildAggregateCallable();
        RetryingCaller<LAggregateResult> retryingCaller = this.service.getLConnection().getDMLRetryingCaller(this.getOperationTimeout(), this.getGlitchTimeout(), this.service.getDoAsUser());
        Object traceContext = this.service.startOperationAsync(this.tableName, operationType);
        AsyncLAggregateResultHandler asyncAggregateHandler = new AsyncLAggregateResultHandler(callback, operationType, System.currentTimeMillis(), traceContext, retryingCaller);
        retryingCaller.withRetriesAsync(aggregateCallable, asyncAggregateHandler);
    }

    @Override
    public Row execute() throws LindormException {
        this.validate();
        this.service.startOperation(this.tableName, OperationContext.OperationType.AGGREGATE);
        RetryingCaller<LAggregateResult> retryingCaller = this.service.getLConnection().getDMLRetryingCaller(this.getOperationTimeout(), this.getGlitchTimeout(), this.service.getDoAsUser());
        try {
            this.setupRouteKey();
            LServerCallable<LAggregateResult> aggregateCallable = this.buildAggregateCallable();
            long start = System.currentTimeMillis();
            LAggregateResult result = retryingCaller.withRetries(aggregateCallable);
            this.handleResultAttributes(this, result);
            this.service.getLConnection().getTableMetricsManager().onOperationSuccess(this.namespace, this.tableName, OperationContext.OperationType.AGGREGATE, System.currentTimeMillis() - start, 1);
            this.service.endOperationSuccessfully(this.tableName, retryingCaller);
            return result.getResult();
        }
        catch (Throwable t) {
            if (t instanceof TableNotFoundException) {
                this.service.getLConnection().getTableMetaCache().removeTable(this.namespace, this.tableName);
            }
            LindormException error = new LindormException(t);
            this.service.getLConnection().getTableMetricsManager().onOperationError(this.namespace, this.tableName, OperationContext.OperationType.DELETE, error);
            this.service.endOperationExceptionally(this.tableName, retryingCaller, t);
            throw error;
        }
    }

    @Override
    protected byte[] computeRowKey(TableMeta meta) throws LindormException {
        return CompilerUtils.getRowKeyForRouting(meta, this.where);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LAggregate)) {
            return false;
        }
        LAggregate other = (LAggregate)obj;
        if (this.where == null != (other.where == null)) {
            return false;
        }
        if (this.where != null && !this.where.equals(other.where)) {
            return false;
        }
        return this.operations.equals(other.operations);
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("AGGREGATE ");
        for (AggregateOperation op : this.operations) {
            str.append(op.toString());
            str.append(",");
        }
        if (!this.operations.isEmpty()) {
            str.setLength(str.length() - 1);
        }
        str.append(" from ");
        str.append(this.tableName);
        if (this.where != null) {
            str.append(" where ");
            str.append(this.where.toString());
        }
        return str.toString();
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.setupAttributes();
        super.writeTo(out);
        assert (!this.operations.isEmpty());
        out.writeBoolean(this.isExplain);
        out.writeBoolean(this.parallelExe);
        if (this.where != null) {
            out.writeBoolean(true);
            WritableUtils.writeVInt(out, ExpressionType.getOrdinal(this.where));
            this.where.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        WritableUtils.writeVInt(out, this.operations.size());
        for (AggregateOperation op : this.operations) {
            op.writeTo(out);
        }
    }

    private void setupAttributes() throws LindormException {
        try {
            if (this.allowFiltering != null) {
                this.setAttribute(ALLOW_FILTERING_ATTR, Bytes.toBytes(this.allowFiltering));
            } else {
                this.removeAttribute(ALLOW_FILTERING_ATTR);
            }
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.isExplain = in.readBoolean();
        this.parallelExe = in.readBoolean();
        boolean hasWhere = in.readBoolean();
        if (hasWhere) {
            this.where = (Condition)ExpressionType.fromOrdinal(WritableUtils.readVInt(in));
            this.where.readFrom(in);
        } else {
            this.where = null;
        }
        int functionNumber = WritableUtils.readVInt(in);
        this.operations = CollectionUtils.newArrayListWithCapacity(functionNumber);
        for (int i = 0; i < functionNumber; ++i) {
            AggregateOperation op = new AggregateOperation();
            op.readFrom(in);
            this.operations.add(op);
        }
        this.initFromAttributes();
    }

    private void initFromAttributes() throws LindormException {
        try {
            byte[] allowFilteringBytes = this.getAttribute(ALLOW_FILTERING_ATTR);
            if (allowFilteringBytes != null) {
                this.allowFiltering = Bytes.toBoolean(allowFilteringBytes);
            }
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    private void validate() throws LindormException {
        if (this.tableName == null || this.tableName.isEmpty()) {
            throw new IllegalRequestException("Table name must not be null or empty.");
        }
        if (this.operations == null || this.operations.isEmpty()) {
            throw new IllegalRequestException("Must specify at least one aggregate operation.");
        }
    }

    private class AsyncLAggregateResultHandler
    extends DmlOperation.AsyncMutationHandler<Row, LAggregateResult> {
        public AsyncLAggregateResultHandler(AsyncCallback<Row> callback, OperationContext.OperationType operationType, long startTime, Object traceContext, RetryingCaller caller) {
            super(callback, operationType, startTime, traceContext, caller);
        }

        @Override
        protected int getAffectedRows(LAggregateResult result) {
            return 1;
        }

        @Override
        protected Row getReturnValue(LAggregateResult result) {
            return result.getResult();
        }
    }
}

