/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.tableservice;

import com.alibaba.lindorm.client.AsyncCallback;
import com.alibaba.lindorm.client.core.LindormTableService;
import com.alibaba.lindorm.client.core.expression.ExpressionType;
import com.alibaba.lindorm.client.core.ipc.ClientCompletableFuture;
import com.alibaba.lindorm.client.core.ipc.LServerCallable;
import com.alibaba.lindorm.client.core.ipc.OperationContext;
import com.alibaba.lindorm.client.core.ipc.RetryingCaller;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.tableservice.DmlOperation;
import com.alibaba.lindorm.client.core.tableservice.LMutationResult;
import com.alibaba.lindorm.client.core.utils.CompilerUtils;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.ColumnValue;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.dml.Increase;
import com.alibaba.lindorm.client.dml.Row;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.exception.TableNotFoundException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.Future;

public class LIncrease
extends DmlOperation
implements Increase {
    private Condition where;
    private Row values = new Row(3);

    public LIncrease() {
    }

    public LIncrease(LindormTableService service) {
        super(service);
    }

    @Override
    public Increase into(String tableName) throws LindormException {
        if (this.service != null) {
            this.namespace = this.service.getNamespace();
        }
        this.tableName = tableName;
        return this;
    }

    @Override
    public Increase where(Condition where) {
        this.where = where;
        return this;
    }

    @Override
    public Increase addColumn(String columnName, Number amount) throws LindormException {
        this.values.add(new ColumnValue(columnName, (Object)amount));
        return this;
    }

    @Override
    public Increase addColumn(byte[] columnName, Number amount) throws LindormException {
        this.values.add(new ColumnValue(columnName, (Object)amount));
        return this;
    }

    @Override
    public Increase addColumn(String familyName, String columnName, Number amount) throws LindormException {
        this.values.add(new ColumnValue(familyName, columnName, (Object)amount));
        return this;
    }

    @Override
    public Increase addColumn(byte[] familyName, byte[] columnName, Number amount) throws LindormException {
        this.values.add(new ColumnValue(familyName, columnName, (Object)amount));
        return this;
    }

    @Override
    public Future<Row> executeAsync() throws LindormException {
        final ClientCompletableFuture<Row> future = new ClientCompletableFuture<Row>();
        this.executeAsync(new AsyncCallback<Row>(){

            @Override
            public void onComplete(Row result) {
                future.complete(result);
            }

            @Override
            public void onError(Throwable exception) {
                future.completeExceptionally(exception);
            }

            @Override
            public boolean shouldProcessResultInPool() {
                return false;
            }
        });
        return future;
    }

    @Override
    public Increase setTTL(long ttl) {
        this.internalSetTTL(ttl);
        return this;
    }

    @Override
    public void executeAsync(AsyncCallback<Row> callback) throws LindormException {
        LIncrease.validate(this);
        if (this.isEmpty()) {
            callback.onComplete(null);
            return;
        }
        this.setupRouteKey();
        OperationContext.OperationType operationType = OperationContext.OperationType.INCREASE;
        int operationTimeout = this.getOperationTimeout();
        RetryingCaller<LMutationResult> retryingCaller = this.service.getLConnection().getDMLRetryingCaller(this.getOperationTimeout(), this.getGlitchTimeout(), this.service.getDoAsUser());
        LServerCallable<LMutationResult> increaseCallable = this.buildIncreaseCallable();
        Object traceContext = this.service.startOperationAsync(this.tableName, operationType);
        AsyncIncreaseHandler asyncIncreaseHandler = new AsyncIncreaseHandler(callback, operationType, System.currentTimeMillis(), traceContext, retryingCaller);
        retryingCaller.withRetriesAsync(increaseCallable, asyncIncreaseHandler);
    }

    private LServerCallable<LMutationResult> buildIncreaseCallable() {
        return new LServerCallable<LMutationResult>((DmlOperation)this, OperationContext.OperationType.INCREASE){

            @Override
            public LMutationResult call() throws Exception {
                return this.server.increase(LIncrease.this);
            }
        };
    }

    @Override
    public Row execute() throws LindormException {
        LIncrease.validate(this);
        if (this.isEmpty()) {
            return null;
        }
        long start = System.currentTimeMillis();
        this.service.startOperation(this.tableName, OperationContext.OperationType.INCREASE);
        RetryingCaller<LMutationResult> retryingCaller = this.service.getLConnection().getDMLRetryingCaller(this.getOperationTimeout(), this.getGlitchTimeout(), this.service.getDoAsUser());
        LServerCallable<LMutationResult> appendCallable = this.buildIncreaseCallable();
        try {
            this.setupRouteKey();
            LMutationResult response = retryingCaller.withRetries(appendCallable);
            this.handleResultAttributes(this, response);
            Object[] results = response.getResults();
            Row ret = (Row)results[0];
            this.service.getLConnection().getTableMetricsManager().onOperationSuccess(this.namespace, this.tableName, OperationContext.OperationType.INCREASE, System.currentTimeMillis() - start, 1);
            this.service.endOperationSuccessfully(this.tableName, retryingCaller);
            return ret;
        }
        catch (Throwable t) {
            if (t instanceof TableNotFoundException) {
                this.service.getLConnection().getTableMetaCache().removeTable(this.namespace, this.tableName);
            }
            String msg = this.buildErrorMsg(OperationContext.OperationType.INCREASE, t, System.currentTimeMillis() - start);
            LindormException finalError = new LindormException(msg);
            if (this.service.isInitCauseBy()) {
                finalError.initCause(t);
            }
            this.service.getLConnection().getTableMetricsManager().onOperationError(this.namespace, this.tableName, OperationContext.OperationType.INCREASE, finalError);
            this.service.endOperationExceptionally(this.tableName, retryingCaller, t);
            throw finalError;
        }
    }

    public Condition getWhere() {
        return this.where;
    }

    public Row getValues() {
        return this.values;
    }

    @Override
    protected byte[] computeRowKey(TableMeta meta) throws LindormException {
        try {
            return CompilerUtils.getRowKeyForRouting(meta, this.where);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        assert (this.where != null);
        assert (this.values != null);
        assert (!this.values.getColumnValues().isEmpty());
        try {
            super.writeTo(out);
            WritableUtils.writeVInt(out, ExpressionType.getOrdinal(this.where));
            this.where.writeTo(out);
            this.values.writeTo(out);
            WritableUtils.writeVInt(out, 0);
        }
        catch (Throwable t) {
            throw new IllegalRequestException(t);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.where = (Condition)ExpressionType.fromOrdinal(WritableUtils.readVInt(in));
        assert (this.where != null);
        this.where.readFrom(in);
        this.values = new Row();
        this.values.readFrom(in);
        WritableUtils.readVInt(in);
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("INCREASE ");
        for (ColumnValue cv : this.values.getColumnValues()) {
            str.append(cv.getColumnKey().toString());
            str.append("+=");
            str.append(DataTypeUtils.valueToString(cv.getType(), cv.getValueObject()));
            str.append(",");
        }
        if (!this.values.getColumnValues().isEmpty()) {
            str.setLength(str.length() - 1);
        }
        str.append(" into ");
        str.append(this.tableName);
        return str.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LIncrease)) {
            return false;
        }
        LIncrease other = (LIncrease)obj;
        if (!this.values.equals(other.values)) {
            return false;
        }
        if (this.where == null != (other.where == null)) {
            return false;
        }
        return this.where == null || this.where.equals(other.where);
    }

    private boolean isEmpty() {
        return this.values == null || this.values.getColumnValues().isEmpty();
    }

    private static void validate(LIncrease increase) throws LindormException {
        if (increase.getTableName() == null || increase.getTableName().isEmpty()) {
            throw new IllegalRequestException("Table name must not be null or empty.");
        }
        if (increase.getWhere() == null) {
            throw new IllegalRequestException("WHERE clause must not be null or empty for INCREASE.");
        }
    }

    private class AsyncIncreaseHandler
    extends DmlOperation.AsyncLMutationResultHandler<Row> {
        public AsyncIncreaseHandler(AsyncCallback<Row> callback, OperationContext.OperationType operationType, long startTime, Object traceContext, RetryingCaller<LMutationResult> caller) {
            super(callback, operationType, startTime, traceContext, caller);
        }

        @Override
        protected Row getReturnValue(LMutationResult result) {
            return (Row)result.getResults()[0];
        }
    }
}

