/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LDecimal;
import com.alibaba.lindorm.client.core.types.LRealNumberType;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class LDecimalV2
extends LRealNumberType<BigDecimal> {
    public static final LDecimalV2 INSTANCE = new LDecimalV2();
    public static final BigDecimal DEFAULT_NULL_VALUE = new BigDecimal(0);
    public static final int DECIMAL_V2_MAX_PRECISION = 38;
    public static final int DECIMAL_V2_MAX_SCALE = 38;
    public static final int DECIMAL_V2_MIN_SCALE = -38;

    private LDecimalV2() {
        super(DataType.DECIMAL_V2, BigDecimal.class);
    }

    @Override
    public int getByteSize() {
        throw new UnsupportedOperationException("Please call LDataType#estimateByteSize() for variable length data types");
    }

    @Override
    public int getByteSize(Object o) {
        return DataTypeUtils.getDecimalByteSize((BigDecimal)o, DataType.DECIMAL_V2);
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return targetType instanceof LRealNumberType && DataTypeUtils.equalsAny(targetType, LDecimal.INSTANCE, INSTANCE);
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        if (value == null) {
            return null;
        }
        BigDecimal bd = (BigDecimal)value;
        if (bd.precision() > 38) {
            throw new IllegalDataException("decimalV2 type support max precision: 38, yours: " + bd.precision());
        }
        if (bd.scale() > 38 || bd.scale() < -38) {
            throw new IllegalDataException(String.format("decimalV2 type support scale range: [%d, %d], yours: %d", -38, 38, bd.scale()));
        }
        return DataTypeUtils.encodeDecimal(bd, sortOrder, DataType.DECIMAL_V2);
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        return LDecimal.INSTANCE.toObject(value, actualType);
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        if (value == null) {
            return null;
        }
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        if (value == null) {
            return null;
        }
        return DataTypeUtils.decodeDecimal(value, offset, length, sortOrder, DataType.DECIMAL_V2);
    }

    @Override
    public byte[] getNullValue() throws IllegalDataException {
        return this.toBytes(DEFAULT_NULL_VALUE);
    }

    @Override
    public BigDecimal randomData(DataGenerator dataGenerator) {
        long unscaledVal = dataGenerator.getRandom().nextLong();
        int scaleBound = String.valueOf(unscaledVal).length();
        return BigDecimal.valueOf(unscaledVal, dataGenerator.getRandom().nextInt(scaleBound));
    }

    public Pair<byte[], byte[]> getValueBoundary() throws IllegalDataException {
        byte[] start = this.toBytes(BigDecimal.valueOf(Long.MIN_VALUE));
        byte[] end = this.toBytes(BigDecimal.valueOf(Long.MAX_VALUE));
        return new Pair<byte[], byte[]>(start, end);
    }

    public BigDecimal fixedTestData() {
        return BigDecimal.valueOf(1024L, 2);
    }

    public BigDecimal testDataFrom(int value) {
        return BigDecimal.valueOf(value);
    }

    public Pair<BigDecimal, BigDecimal> getTestMinMaxForTableCreation() {
        return new Pair<BigDecimal, BigDecimal>(BigDecimal.valueOf(Long.MIN_VALUE), BigDecimal.valueOf(Long.MAX_VALUE));
    }

    public List<Object> getTestPartitionsForTableCreation() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(BigDecimal.TEN.negate());
        list.add(BigDecimal.ZERO);
        list.add(BigDecimal.ONE);
        list.add(BigDecimal.TEN);
        return list;
    }

    @Override
    public byte[] toTransferBytes(Object data) throws IllegalDataException {
        return Bytes.toBytes((BigDecimal)data);
    }

    @Override
    public Object fromTransferBytes(byte[] bytes, int offset, int length) throws IllegalDataException {
        return Bytes.toBigDecimal(bytes, offset, length);
    }
}

