/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LByte;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LWholeNumberType;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;

public class LUnsignedByte
extends LWholeNumberType<Byte> {
    public static final LUnsignedByte INSTANCE = new LUnsignedByte();

    private LUnsignedByte() {
        super(DataType.UNSIGNED_BYTE, Byte.class);
    }

    @Override
    public int getByteSize() {
        return 1;
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return LByte.INSTANCE.isCastableTo(targetType);
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        byte[] ret = new byte[this.getByteSize()];
        DataTypeUtils.encodeUnsignedByte(((Number)value).byteValue(), ret, 0, sortOrder);
        return ret;
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        byte v = (Byte)LByte.INSTANCE.toObject(value, actualType);
        if (v < 0) {
            throw new IllegalDataException("Cannot set negative value for UNSIGNED_BYTE type, actual value=" + v);
        }
        return v;
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        DataTypeUtils.checkForSufficientLength(length, this.getByteSize(), this.clientType);
        return DataTypeUtils.decodeUnsignedByte(value, offset, sortOrder);
    }

    @Override
    public byte[] getNullValue() {
        return DataTypeUtils.ZERO_BYTE_ARRAY;
    }

    @Override
    public Byte randomData(DataGenerator dataGenerator) {
        Byte ret = LByte.INSTANCE.randomData(dataGenerator);
        if (ret < 0) {
            ret = (byte)(ret - -128);
        }
        return ret;
    }
}

