/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LDouble;
import com.alibaba.lindorm.client.core.types.LRealNumberType;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;

public class LUnsignedDouble
extends LRealNumberType<Double> {
    public static final LUnsignedDouble INSTANCE = new LUnsignedDouble();

    private LUnsignedDouble() {
        super(DataType.UNSIGNED_DOUBLE, Double.class);
    }

    @Override
    public int getByteSize() {
        return 8;
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return LDouble.INSTANCE.isCastableTo(targetType);
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        byte[] ret = new byte[this.getByteSize()];
        DataTypeUtils.encodeUnsignedDouble(((Number)value).doubleValue(), ret, 0, sortOrder);
        return ret;
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        double v = (Double)LDouble.INSTANCE.toObject(value, actualType);
        if (v < 0.0) {
            throw new IllegalDataException("Cannot set negative value for UNSIGNED_DOUBLE type, actual value=" + v);
        }
        return v;
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        DataTypeUtils.checkForSufficientLength(length, this.getByteSize(), this.clientType);
        return DataTypeUtils.decodeUnsignedDouble(value, offset, sortOrder);
    }

    @Override
    public byte[] getNullValue() {
        return DataTypeUtils.ZERO_DOUBLE_ARRAY;
    }

    @Override
    public Double randomData(DataGenerator dataGenerator) {
        Double ret = LDouble.INSTANCE.randomData(dataGenerator);
        if (ret < 0.0) {
            ret = Math.abs(ret);
        }
        return ret;
    }
}

