/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import com.alibaba.lindorm.client.core.ipc.LindormObject;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.ImmutableBytesPtr;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BytesKeyAttributes
implements LindormObject {
    private Map<ImmutableBytesPtr, ImmutableBytesPtr> attributes = null;

    public void set(ImmutableBytesPtr key, ImmutableBytesPtr value) {
        if (this.attributes == null && value == null) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new HashMap<ImmutableBytesPtr, ImmutableBytesPtr>();
        }
        if (value != null) {
            this.attributes.put(key, value);
        } else {
            this.attributes.remove(key);
            if (this.attributes.isEmpty()) {
                this.attributes = null;
            }
        }
    }

    public ImmutableBytesPtr get(ImmutableBytesPtr key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public Map<ImmutableBytesPtr, ImmutableBytesPtr> getAttributes() {
        if (this.attributes == null || this.attributes.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        if (this.attributes == null || this.attributes.size() == 0) {
            WritableUtils.writeVInt(out, 0);
        } else {
            WritableUtils.writeVInt(out, this.attributes.size());
            for (Map.Entry<ImmutableBytesPtr, ImmutableBytesPtr> attr : this.attributes.entrySet()) {
                attr.getKey().writeTo(out);
                attr.getValue().writeTo(out);
            }
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        int numAttributes = WritableUtils.readVInt(in);
        if (numAttributes > 0) {
            this.attributes = new HashMap<ImmutableBytesPtr, ImmutableBytesPtr>(numAttributes);
            for (int i = 0; i < numAttributes; ++i) {
                ImmutableBytesPtr key = new ImmutableBytesPtr();
                ImmutableBytesPtr value = new ImmutableBytesPtr();
                key.readFrom(in);
                value.readFrom(in);
                this.attributes.put(key, value);
            }
        }
    }

    public String toString() {
        if (this.attributes == null || this.attributes.isEmpty()) {
            return "[]";
        }
        StringBuilder str = new StringBuilder(1024);
        str.append(this.attributes.size());
        str.append("[");
        for (Map.Entry<ImmutableBytesPtr, ImmutableBytesPtr> entry : this.attributes.entrySet()) {
            String keyStr = Bytes.toStringBinary(entry.getKey().get(), entry.getKey().getOffset(), entry.getKey().getLength());
            String valueStr = Bytes.toStringBinary(entry.getValue().get(), entry.getValue().getOffset(), entry.getValue().getLength());
            str.append(keyStr);
            str.append("=");
            str.append(valueStr);
            str.append(",");
        }
        str.setLength(str.length() - 1);
        str.append("]");
        return str.toString();
    }
}

