/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import com.alibaba.lindorm.client.core.utils.Bytes;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class ImmutableBytesPtr
implements Comparable<ImmutableBytesPtr> {
    private byte[] bytes = null;
    private int offset;
    private int length;

    public ImmutableBytesPtr() {
    }

    public ImmutableBytesPtr(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public ImmutableBytesPtr(ImmutableBytesPtr other) {
        this(other.get(), other.getOffset(), other.getLength());
    }

    public ImmutableBytesPtr(byte[] bytes, int offset, int length) {
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    public byte[] get() {
        if (this.bytes == null) {
            throw new IllegalStateException("Uninitialized ImmutableBytesPtr");
        }
        return this.bytes;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public void set(byte[] b) {
        this.set(b, 0, b.length);
    }

    public void set(byte[] b, int offset, int length) {
        this.bytes = b;
        this.offset = offset;
        this.length = length;
    }

    public int hashCode() {
        int hash = 1;
        for (int i = this.offset; i < this.offset + this.length; ++i) {
            hash = 31 * hash + this.bytes[i];
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ImmutableBytesPtr) {
            ImmutableBytesPtr other = (ImmutableBytesPtr)obj;
            return Bytes.equals(this.bytes, this.offset, this.length, other.bytes, other.offset, other.length);
        }
        if (obj instanceof byte[]) {
            byte[] other = (byte[])obj;
            return Bytes.equals(this.bytes, this.offset, this.length, other, 0, other.length);
        }
        return false;
    }

    @Override
    public int compareTo(ImmutableBytesPtr o) {
        return Bytes.compareTo(this.bytes, this.offset, this.length, o.bytes, o.offset, o.length);
    }

    @Override
    public int compareTo(byte[] that) {
        return Bytes.compareTo(this.bytes, this.offset, this.length, that, 0, that.length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(3 * this.bytes.length);
        for (int idx = this.offset; idx < this.offset + this.length; ++idx) {
            String num;
            if (idx != this.offset) {
                sb.append(' ');
            }
            if ((num = Integer.toHexString(this.bytes[idx])).length() < 2) {
                sb.append('0');
            }
            sb.append(num);
        }
        return sb.toString();
    }

    public byte[] copyBytes() {
        return Arrays.copyOfRange(this.bytes, this.offset, this.offset + this.length);
    }

    public void readFrom(DataInput in) throws IOException {
        this.length = in.readInt();
        this.bytes = new byte[this.length];
        in.readFully(this.bytes, 0, this.length);
        this.offset = 0;
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeInt(this.length);
        out.write(this.bytes, this.offset, this.length);
    }
}

