/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import com.alibaba.lindorm.client.core.ipc.LindormObject;
import com.alibaba.lindorm.thirdparty.netty.buffer.ByteBuf;
import com.alibaba.lindorm.thirdparty.netty.buffer.ByteBufInputStream;
import com.alibaba.lindorm.thirdparty.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.zip.GZIPInputStream;

public final class WritableUtils {
    public static byte[] readCompressedByteArray(DataInput in) throws IOException {
        int len;
        int length = in.readInt();
        if (length == -1) {
            return null;
        }
        byte[] buffer = new byte[length];
        in.readFully(buffer);
        GZIPInputStream gzi = new GZIPInputStream(new ByteArrayInputStream(buffer, 0, buffer.length));
        byte[] outbuf = new byte[length];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = gzi.read(outbuf, 0, outbuf.length)) != -1) {
            bos.write(outbuf, 0, len);
        }
        byte[] decompressed = bos.toByteArray();
        bos.close();
        gzi.close();
        return decompressed;
    }

    public static void skipCompressedByteArray(DataInput in) throws IOException {
        int length = in.readInt();
        if (length != -1) {
            WritableUtils.skipFully(in, length);
        }
    }

    public static String readCompressedString(DataInput in) throws IOException {
        byte[] bytes = WritableUtils.readCompressedByteArray(in);
        if (bytes == null) {
            return null;
        }
        return new String(bytes, "UTF-8");
    }

    public static void writeString(DataOutput out, String s) throws IOException {
        if (s != null) {
            byte[] buffer = s.getBytes("UTF-8");
            int len = buffer.length;
            out.writeInt(len);
            out.write(buffer, 0, len);
        } else {
            out.writeInt(-1);
        }
    }

    public static String readString(DataInput in) throws IOException {
        int length = in.readInt();
        if (length == -1) {
            return null;
        }
        byte[] buffer = new byte[length];
        in.readFully(buffer);
        return new String(buffer, "UTF-8");
    }

    public static void writeStringArray(DataOutput out, String[] s) throws IOException {
        out.writeInt(s.length);
        for (int i = 0; i < s.length; ++i) {
            WritableUtils.writeString(out, s[i]);
        }
    }

    public static String[] readStringArray(DataInput in) throws IOException {
        int len = in.readInt();
        if (len == -1) {
            return null;
        }
        String[] s = new String[len];
        for (int i = 0; i < len; ++i) {
            s[i] = WritableUtils.readString(in);
        }
        return s;
    }

    public static String[] readCompressedStringArray(DataInput in) throws IOException {
        int len = in.readInt();
        if (len == -1) {
            return null;
        }
        String[] s = new String[len];
        for (int i = 0; i < len; ++i) {
            s[i] = WritableUtils.readCompressedString(in);
        }
        return s;
    }

    public static void displayByteArray(byte[] record) {
        int i;
        for (i = 0; i < record.length - 1; ++i) {
            if (i % 16 == 0) {
                System.out.println();
            }
            System.out.print(Integer.toHexString(record[i] >> 4 & 0xF));
            System.out.print(Integer.toHexString(record[i] & 0xF));
            System.out.print(",");
        }
        System.out.print(Integer.toHexString(record[i] >> 4 & 0xF));
        System.out.print(Integer.toHexString(record[i] & 0xF));
        System.out.println();
    }

    public static void writeVInt(DataOutput stream, int i) throws IOException {
        WritableUtils.writeVLong(stream, i);
    }

    public static void writeVIntArray(DataOutput stream, int[] intArray) throws IOException {
        WritableUtils.writeVInt(stream, intArray.length);
        for (int i = 0; i < intArray.length; ++i) {
            WritableUtils.writeVInt(stream, intArray[i]);
        }
    }

    public static void writeVLong(DataOutput stream, long i) throws IOException {
        if (i >= -112L && i <= 127L) {
            stream.writeByte((byte)i);
            return;
        }
        int len = -112;
        if (i < 0L) {
            i ^= 0xFFFFFFFFFFFFFFFFL;
            len = -120;
        }
        long tmp = i;
        while (tmp != 0L) {
            tmp >>= 8;
            --len;
        }
        stream.writeByte((byte)len);
        for (int idx = len = len < -120 ? -(len + 120) : -(len + 112); idx != 0; --idx) {
            int shiftbits = (idx - 1) * 8;
            long mask = 255L << shiftbits;
            stream.writeByte((byte)((i & mask) >> shiftbits));
        }
    }

    public static long readVLong(DataInput stream) throws IOException {
        byte firstByte = stream.readByte();
        int len = WritableUtils.decodeVIntSize(firstByte);
        if (len == 1) {
            return firstByte;
        }
        long i = 0L;
        for (int idx = 0; idx < len - 1; ++idx) {
            byte b = stream.readByte();
            i <<= 8;
            i |= (long)(b & 0xFF);
        }
        return WritableUtils.isNegativeVInt(firstByte) ? i ^ 0xFFFFFFFFFFFFFFFFL : i;
    }

    public static int readVInt(DataInput stream) throws IOException {
        long n = WritableUtils.readVLong(stream);
        if (n > Integer.MAX_VALUE || n < Integer.MIN_VALUE) {
            throw new IOException("value too long to fit in integer");
        }
        return (int)n;
    }

    public static int[] readVIntArray(DataInput stream) throws IOException {
        int length = WritableUtils.readVInt(stream);
        if (length > 0) {
            int[] intArray = new int[length];
            for (int i = 0; i < length; ++i) {
                intArray[i] = WritableUtils.readVInt(stream);
            }
            return intArray;
        }
        return null;
    }

    public static int readVIntInRange(DataInput stream, int lower, int upper) throws IOException {
        long n = WritableUtils.readVLong(stream);
        if (n < (long)lower) {
            if (lower == 0) {
                throw new IOException("expected non-negative integer, got " + n);
            }
            throw new IOException("expected integer greater than or equal to " + lower + ", got " + n);
        }
        if (n > (long)upper) {
            throw new IOException("expected integer less or equal to " + upper + ", got " + n);
        }
        return (int)n;
    }

    public static boolean isNegativeVInt(byte value) {
        return value < -120 || value >= -112 && value < 0;
    }

    public static int decodeVIntSize(byte value) {
        if (value >= -112) {
            return 1;
        }
        if (value < -120) {
            return -119 - value;
        }
        return -111 - value;
    }

    public static int getVIntSize(long i) {
        if (i >= -112L && i <= 127L) {
            return 1;
        }
        if (i < 0L) {
            i ^= 0xFFFFFFFFFFFFFFFFL;
        }
        int dataBits = 64 - Long.numberOfLeadingZeros(i);
        return (dataBits + 7) / 8 + 1;
    }

    public static void skipFully(DataInput in, int len) throws IOException {
        int total;
        int cur = 0;
        for (total = 0; total < len && (cur = in.skipBytes(len - total)) > 0; total += cur) {
        }
        if (total < len) {
            throw new IOException("Not able to skip " + len + " bytes, possibly " + "due to end of input.");
        }
    }

    public static String stringifyException(Throwable e) {
        StringWriter stm = new StringWriter();
        PrintWriter wrt = new PrintWriter(stm);
        e.printStackTrace(wrt);
        wrt.close();
        return stm.toString();
    }

    public static LindormObject getWritable(byte[] bytes, LindormObject w) throws IOException {
        return WritableUtils.getWritable(bytes, 0, bytes.length, w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LindormObject getWritable(byte[] bytes, int offset, int length, LindormObject w) throws IOException {
        if (bytes == null || length <= 0) {
            throw new IllegalArgumentException("Can't build a writable with empty bytes array");
        }
        if (offset + length > bytes.length) {
            throw new IllegalArgumentException("Bytes array overflow. offset: " + offset + ", length: " + length + ", bytes length: " + bytes.length);
        }
        if (w == null) {
            throw new IllegalArgumentException("Writable cannot be null");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer(bytes, offset, length);
        ByteBufInputStream in = new ByteBufInputStream(byteBuf);
        try {
            w.readFrom(in);
            LindormObject lindormObject = w;
            return lindormObject;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(LindormObject w) throws IOException {
        if (w == null) {
            throw new IllegalArgumentException("Writable cannot be null");
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        try {
            w.writeTo(out);
            out.close();
            out = null;
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

