/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataInputBuffer;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.LTag;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class WColumn
extends VersionedObjectWithAttributes {
    protected byte[] qualifier;
    protected byte[] value;
    protected long ts;
    protected Type type = Type.Put;
    protected List<LTag> tags = null;
    protected byte[] family;

    public void setTs(long ts) {
        this.ts = ts;
    }

    public void setTags(List<LTag> tags) {
        this.tags = new ArrayList<LTag>(tags);
    }

    public WColumn() {
    }

    public WColumn(byte[] family, byte[] qualifier, byte[] value) {
        this(family, qualifier, value, Long.MAX_VALUE, Type.Put);
    }

    public WColumn(byte[] family, byte[] qualifier, byte[] value, long ts) {
        this(family, qualifier, value, ts, Type.Put);
    }

    public WColumn(byte[] family, byte[] qualifier, byte[] value, long ts, Type type) {
        this.family = family;
        this.qualifier = qualifier;
        this.value = value;
        this.ts = ts;
        this.type = type;
    }

    public byte[] getQualifier() {
        return this.qualifier;
    }

    public long getTs() {
        return this.ts;
    }

    public byte[] getValue() {
        return this.value;
    }

    public byte[] getFamily() {
        return this.family;
    }

    public void setFamily(byte[] family) {
        this.family = family;
    }

    public Type getType() {
        return this.type;
    }

    public List<LTag> getTags() {
        return this.tags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupAttributes() throws IOException {
        if (this.tags != null && !this.tags.isEmpty()) {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(byteStream);
            try {
                WritableUtils.writeVInt(out, this.tags.size());
                for (LTag tag : this.tags) {
                    tag.writeTo(out);
                }
                out.close();
                this.setAttribute("tags", byteStream.toByteArray());
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.setupAttributes();
        super.writeTo(out);
        Bytes.writeByteArray(out, this.qualifier);
        Bytes.writeByteArray(out, this.value);
        WritableUtils.writeVLong(out, this.ts);
        out.writeByte(this.type.getCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.qualifier = Bytes.readByteArray(in);
        this.value = Bytes.readByteArray(in);
        this.ts = WritableUtils.readVLong(in);
        this.type = Type.codeToType(in.readByte());
        byte[] t = this.getAttribute("tags");
        if (t != null) {
            this.tags = new ArrayList<LTag>();
            DataInputBuffer tagIn = new DataInputBuffer();
            try {
                tagIn.reset(t, 0, t.length);
                int size = WritableUtils.readVInt(tagIn);
                for (int i = 0; i < size; ++i) {
                    LTag ltag = new LTag();
                    ltag.readFrom(tagIn);
                    this.tags.add(ltag);
                }
            }
            finally {
                tagIn.close();
            }
        }
    }

    public boolean isMatchingQualifier(byte[] qualifier) {
        return Bytes.equals(qualifier, this.qualifier);
    }

    public long getLength() {
        return (this.qualifier == null ? 0 : this.qualifier.length) + (this.value == null ? 0 : this.value.length) + 8 + 8;
    }

    public long getValueLength() {
        if (this.value == null) {
            return 0L;
        }
        return this.value.length;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(64);
        String familyStr = this.family == null ? "" : Bytes.toStringBinary(this.family);
        String qulifierStr = this.qualifier == null ? "" : Bytes.toStringBinary(this.qualifier);
        int vlen = this.value == null ? 0 : this.value.length;
        String timestampStr = WColumn.humanReadableTimestamp(this.ts);
        buffer.append(familyStr).append(":").append(qulifierStr).append("/").append(timestampStr).append("/").append((Object)this.type).append("/vlen=").append(vlen);
        if (this.getTTL() != Long.MAX_VALUE) {
            buffer.append("/ttl=").append(this.getTTL());
        }
        return buffer.toString();
    }

    public static String humanReadableTimestamp(long timestamp) {
        if (timestamp == Long.MAX_VALUE) {
            return "LATEST_TIMESTAMP";
        }
        if (timestamp == Long.MIN_VALUE) {
            return "OLDEST_TIMESTAMP";
        }
        return String.valueOf(timestamp);
    }

    public boolean isDelete() {
        return Type.Delete.getCode() <= this.type.getCode() && this.type.getCode() <= Type.DeleteFamily.getCode();
    }

    public boolean hasTTL() {
        return this.hasAttribute("_ttl");
    }

    public Long getTTL() {
        byte[] ttlBytes = this.getAttribute("_ttl");
        if (ttlBytes != null) {
            return Bytes.toLong(ttlBytes);
        }
        return Long.MAX_VALUE;
    }

    public int getEstimatedSize() {
        int qualifierLength = this.qualifier == null ? 0 : this.qualifier.length;
        int valueLength = this.value == null ? 0 : this.value.length;
        return qualifierLength + valueLength + 8 + 1 + this.getAttrEstimatedSize();
    }

    public static enum Type {
        Minimum(0),
        Put(4),
        Delete(8),
        DeleteColumn(12),
        DeleteColumnRange(13),
        DeleteFamily(14),
        Maximum(-1);

        private final byte code;
        private static final Type[] types;

        private Type(byte c) {
            this.code = c;
        }

        public byte getCode() {
            return this.code;
        }

        public static Type codeToType(byte b) {
            Type type = types[b & 0xFF];
            if (type != null) {
                return type;
            }
            throw new RuntimeException("Unknown code " + b);
        }

        static {
            types = new Type[256];
            Type[] arr$ = Type.values();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Type t;
                Type.types[t.getCode() & 0xFF] = t = arr$[i$];
            }
        }
    }
}

