/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice;

import com.alibaba.lindorm.client.core.ipc.LindormObject;
import com.alibaba.lindorm.client.core.ipc.LindormRawObject;
import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.StringUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.core.widecolumnservice.WResult;
import com.alibaba.lindorm.client.exception.LDRemoteException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class WMutationResult
extends VersionedObjectWithAttributes {
    public static int EXCEPTIONLENGTHLIMIT = 256;
    private Object[] results;

    public WMutationResult() {
    }

    public WMutationResult(Object result) {
        this.results = new Object[]{result};
    }

    public WMutationResult(Object[] results) {
        this.results = results;
    }

    public int getNumberOfRowsAffected() {
        if (this.results == null) {
            return 0;
        }
        int numberOfRowsAffected = 0;
        for (Object object : this.results) {
            if (object == null || object instanceof Throwable) continue;
            ++numberOfRowsAffected;
        }
        return numberOfRowsAffected;
    }

    public Object[] getResults() {
        return this.results;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        if (this.results == null || this.results.length == 0) {
            WritableUtils.writeVInt(out, 0);
            return;
        }
        WritableUtils.writeVInt(out, this.results.length);
        for (Object result : this.results) {
            if (result instanceof Throwable) {
                out.writeBoolean(true);
                Throwable t = (Throwable)result;
                WritableUtils.writeString(out, t.getClass().getName());
                WritableUtils.writeString(out, StringUtils.stringifyException(t, EXCEPTIONLENGTHLIMIT));
                continue;
            }
            out.writeBoolean(false);
            if (!(result instanceof LindormObject)) {
                result = null;
            }
            LindormRawObject.writeObject(out, result, result != null ? result.getClass() : LindormObject.class);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        int length = WritableUtils.readVInt(in);
        if (length == 0) {
            this.results = new Object[0];
        } else {
            this.results = new Object[length];
            for (int i = 0; i < length; ++i) {
                boolean isException = in.readBoolean();
                if (isException) {
                    String klass = WritableUtils.readString(in);
                    String desc = WritableUtils.readString(in);
                    this.results[i] = new LDRemoteException(klass, desc).unwrapRemoteException();
                    continue;
                }
                this.results[i] = LindormRawObject.readObject(in);
            }
        }
    }

    public int getEstimatedSize() {
        int size = 8;
        if (this.results != null) {
            size += this.results.length * 1;
            for (Object result : this.results) {
                if (!(result instanceof WResult)) continue;
                size += ((WResult)result).getEstimatedSize();
            }
        }
        return size;
    }
}

