/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice;

import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.widecolumnservice.WColumn;
import com.alibaba.lindorm.client.core.widecolumnservice.WMutation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WPut
extends WMutation {
    public WPut() {
    }

    public WPut(byte[] rowKey) {
        this(rowKey, Long.MAX_VALUE, -1L);
    }

    public WPut(byte[] row, long ts, long lockID) {
        super(row, ts, lockID);
    }

    public WPut(byte[] row, long ts) {
        this(row, ts, -1L);
    }

    public WPut(WPut putToCopy) {
        super(putToCopy);
    }

    public WPut add(byte[] family, byte[] qualifier, byte[] value) {
        return this.add(family, qualifier, this.ts, value);
    }

    public WPut add(byte[] family, byte[] qualifier, long ts, byte[] value) {
        WColumn column = new WColumn(family, qualifier, value, ts);
        this.addColumn(family, column);
        return this;
    }

    public WPut add(WColumn column) {
        byte[] family = column.getFamily();
        this.addColumn(family, column);
        return this;
    }

    public boolean has(byte[] family, byte[] qualifier) {
        return this.has(family, qualifier, this.ts, new byte[0], true, true);
    }

    public boolean has(byte[] family, byte[] qualifier, long ts) {
        return this.has(family, qualifier, ts, new byte[0], false, true);
    }

    public boolean has(byte[] family, byte[] qualifier, byte[] value) {
        return this.has(family, qualifier, this.ts, value, true, false);
    }

    public boolean has(byte[] family, byte[] qualifier, long ts, byte[] value) {
        return this.has(family, qualifier, ts, value, false, false);
    }

    private boolean has(byte[] family, byte[] qualifier, long ts, byte[] value, boolean ignoreTS, boolean ignoreValue) {
        List<WColumn> columns = this.getColumnList(family);
        if (columns == null || columns.size() == 0) {
            return false;
        }
        for (WColumn column : columns) {
            if (!column.isMatchingQualifier(qualifier) || !ignoreTS && column.getTs() != ts || !ignoreValue && !Bytes.equals(column.getValue(), value)) continue;
            return true;
        }
        return false;
    }

    public List<WColumn> get(byte[] family, byte[] qualifier) {
        ArrayList<WColumn> filteredList = new ArrayList<WColumn>();
        List<WColumn> familyList = this.getColumnList(family);
        if (familyList == null) {
            return filteredList;
        }
        for (WColumn column : familyList) {
            if (!column.isMatchingQualifier(qualifier)) continue;
            filteredList.add(column);
        }
        return filteredList;
    }

    public long getEstimateSize() {
        long ret = 0L;
        if (this.rowKey != null) {
            ret += (long)this.rowKey.length;
        }
        Map<byte[], List<WColumn>> familyMap = this.getFamilyMap();
        for (Map.Entry<byte[], List<WColumn>> entry : familyMap.entrySet()) {
            ret += (long)entry.getKey().length;
            for (WColumn column : entry.getValue()) {
                ret += 16L;
                if (column.getFamily() != null) {
                    ret += (long)column.getFamily().length;
                }
                if (column.getQualifier() != null) {
                    ret += (long)column.getQualifier().length;
                }
                if (column.getValue() == null) continue;
                ret += (long)column.getValue().length;
            }
        }
        return ret;
    }
}

