/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice;

import com.alibaba.lindorm.client.core.ipc.LindormObject;
import com.alibaba.lindorm.client.core.utils.Bytes;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class WTimeRange
implements LindormObject {
    private long minStamp = 0L;
    private long maxStamp = Long.MAX_VALUE;
    private boolean allTime = false;

    public WTimeRange() {
        this.allTime = true;
    }

    public WTimeRange(long minStamp) {
        this.minStamp = minStamp;
    }

    public WTimeRange(byte[] minStamp) {
        this.minStamp = Bytes.toLong(minStamp);
    }

    public WTimeRange(long minStamp, long maxStamp) throws IOException {
        if (maxStamp < minStamp) {
            throw new IOException("maxStamp is smaller than minStamp");
        }
        this.minStamp = minStamp;
        this.maxStamp = maxStamp;
    }

    public WTimeRange(byte[] minStamp, byte[] maxStamp) throws IOException {
        this(Bytes.toLong(minStamp), Bytes.toLong(maxStamp));
    }

    public long getMin() {
        return this.minStamp;
    }

    public long getMax() {
        return this.maxStamp;
    }

    public boolean withinTimeRange(byte[] bytes, int offset) {
        if (this.allTime) {
            return true;
        }
        return this.withinTimeRange(Bytes.toLong(bytes, offset));
    }

    public boolean withinTimeRange(long timestamp) {
        if (this.allTime) {
            return true;
        }
        return this.minStamp <= timestamp && timestamp < this.maxStamp;
    }

    public boolean withinOrAfterTimeRange(long timestamp) {
        if (this.allTime) {
            return true;
        }
        return timestamp >= this.minStamp;
    }

    public boolean containsAllTime() {
        return this.allTime;
    }

    public int compare(long timestamp) {
        if (timestamp < this.minStamp) {
            return -1;
        }
        if (timestamp >= this.maxStamp) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("maxStamp=");
        sb.append(this.maxStamp);
        sb.append(", minStamp=");
        sb.append(this.minStamp);
        return sb.toString();
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        this.minStamp = in.readLong();
        this.maxStamp = in.readLong();
        this.allTime = in.readBoolean();
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        out.writeLong(this.minStamp);
        out.writeLong(this.maxStamp);
        out.writeBoolean(this.allTime);
    }
}

