/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice.filter;

import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WCompareFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class WSingleColumnValueNumFilter
extends WFilter {
    protected byte[] columnFamily;
    protected byte[] columnQualifier;
    private WCompareFilter.CompareOp compareOp;
    private int dataType = 1;
    private Object object = null;
    private boolean filterIfMissing = false;
    private boolean latestVersionOnly = true;
    public static final int INT = 1;
    public static final int LONG = 2;
    public static final int SHORT = 3;
    public static final int DOUBLE = 4;
    public static final int FLOAT = 5;

    public WSingleColumnValueNumFilter() {
    }

    public WSingleColumnValueNumFilter(byte[] family, byte[] qualifier, WCompareFilter.CompareOp compareOp, Object object) {
        this.columnFamily = family;
        this.columnQualifier = qualifier;
        this.compareOp = compareOp;
        this.object = object;
    }

    public WCompareFilter.CompareOp getOperator() {
        return this.compareOp;
    }

    public byte[] getFamily() {
        return this.columnFamily;
    }

    public byte[] getQualifier() {
        return this.columnQualifier;
    }

    public boolean getFilterIfMissing() {
        return this.filterIfMissing;
    }

    public void setFilterIfMissing(boolean filterIfMissing) {
        this.filterIfMissing = filterIfMissing;
    }

    public boolean getLatestVersionOnly() {
        return this.latestVersionOnly;
    }

    public void setLatestVersionOnly(boolean latestVersionOnly) {
        this.latestVersionOnly = latestVersionOnly;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public byte[] getColumnFamily() {
        return this.columnFamily;
    }

    public void setColumnFamily(byte[] columnFamily) {
        this.columnFamily = columnFamily;
    }

    public byte[] getColumnQualifier() {
        return this.columnQualifier;
    }

    public void setColumnQualifier(byte[] columnQualifier) {
        this.columnQualifier = columnQualifier;
    }

    public WCompareFilter.CompareOp getCompareOp() {
        return this.compareOp;
    }

    public void setCompareOp(WCompareFilter.CompareOp compareOp) {
        this.compareOp = compareOp;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        Bytes.writeByteArray(out, this.columnFamily);
        Bytes.writeByteArray(out, this.columnQualifier);
        out.writeUTF(this.compareOp.name());
        out.writeBoolean(this.filterIfMissing);
        out.writeBoolean(this.latestVersionOnly);
        out.writeInt(this.dataType);
        switch (this.dataType) {
            case 1: {
                out.writeInt((Integer)this.object);
                break;
            }
            case 3: {
                out.writeShort(((Short)this.object).shortValue());
                break;
            }
            case 4: {
                out.writeDouble((Double)this.object);
                break;
            }
            case 5: {
                out.writeFloat(((Float)this.object).floatValue());
                break;
            }
            case 2: {
                out.writeLong((Long)this.object);
                break;
            }
            default: {
                throw new RuntimeException("Unknown data type :" + this.dataType);
            }
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.columnFamily = Bytes.readByteArray(in);
        if (this.columnFamily.length == 0) {
            this.columnFamily = null;
        }
        this.columnQualifier = Bytes.readByteArray(in);
        if (this.columnQualifier.length == 0) {
            this.columnQualifier = null;
        }
        this.compareOp = WCompareFilter.CompareOp.valueOf(in.readUTF());
        this.filterIfMissing = in.readBoolean();
        this.latestVersionOnly = in.readBoolean();
        this.dataType = in.readInt();
        switch (this.dataType) {
            case 1: {
                this.object = in.readInt();
                break;
            }
            case 3: {
                this.object = in.readShort();
                break;
            }
            case 4: {
                this.object = in.readDouble();
                break;
            }
            case 5: {
                this.object = Float.valueOf(in.readFloat());
                break;
            }
            case 2: {
                this.object = in.readLong();
                break;
            }
            default: {
                throw new RuntimeException("Unknown data type :" + this.dataType);
            }
        }
    }

    @Override
    public WFilter.Type getType() {
        return WFilter.Type.WSingleColumnValueNumFilter;
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.getClass().getSimpleName());
        ret.append(" (");
        ret.append(Bytes.toStringBinary(this.columnFamily));
        ret.append(":");
        ret.append(Bytes.toStringBinary(this.columnQualifier));
        ret.append(WCompareFilter.getReadableOperator(this.compareOp));
        if (this.object instanceof byte[]) {
            ret.append(Bytes.toString((byte[])this.object));
        } else {
            String obj;
            switch (this.dataType) {
                case 1: {
                    obj = ((Integer)this.object).toString();
                    break;
                }
                case 3: {
                    obj = ((Short)this.object).toString();
                    break;
                }
                case 4: {
                    obj = ((Double)this.object).toString();
                    break;
                }
                case 5: {
                    obj = ((Float)this.object).toString();
                    break;
                }
                case 2: {
                    obj = ((Long)this.object).toString();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown data type :" + this.dataType);
                }
            }
            ret.append(obj);
        }
        ret.append(")");
        return ret.toString();
    }
}

