/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.dml;

import com.alibaba.lindorm.client.core.ipc.LindormObject;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LTag
implements LindormObject {
    public static final byte TTL_TAG_TYPE = 8;
    public static final byte TS_NOT_INCLUSIVE_TAG_TYPE = 9;
    public static final byte RESOLVER_TAG_TYPE = 16;
    public static final byte MUST_RETURN_KV_FOR_EXISTENT_ROW = 17;
    public static final byte RESERVERD_SYSTEM_TAG_MAX = 32;
    byte type;
    byte[] value;

    public LTag() {
    }

    public LTag(byte type, byte[] value) {
        this.type = type;
        this.value = value;
    }

    public byte getType() {
        return this.type;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void validate() throws IllegalRequestException {
        if (this.type == 8 && this.value.length != 8) {
            throw new IllegalRequestException("TTL Tag must be size of Long");
        }
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        out.write(this.getType());
        WritableUtils.writeVInt(out, this.value.length);
        out.write(this.getValue());
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        this.type = in.readByte();
        int length = WritableUtils.readVInt(in);
        this.value = new byte[length];
        in.readFully(this.value);
    }

    public String toString() {
        return "LTag{type=" + this.type + ", value=" + Bytes.toStringBinary(this.value) + '}';
    }
}

