/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.exporter;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.exporter.ExporterLogState;
import com.alibaba.lindorm.client.exporter.LindormIdc;
import com.alibaba.lindorm.thirdparty.netty.buffer.ByteBuf;
import com.alibaba.lindorm.thirdparty.netty.buffer.ByteBufInputStream;
import com.alibaba.lindorm.thirdparty.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

public class ExporterLogFile
extends VersionedObjectWithAttributes
implements Comparable {
    private static final byte VERSION = 2;
    private String consumerId;
    private String serverName;
    private String filename;
    private LindormIdc lindormIdc;
    private ExporterLogState state;
    private long createTime;
    private long closeTime;
    private long syncTime;

    public ExporterLogFile() {
    }

    public ExporterLogFile(String consumerId, String filename, ExporterLogState state, long createTime) {
        this.consumerId = consumerId;
        this.filename = filename;
        this.createTime = createTime;
        this.state = state;
    }

    public ExporterLogFile(String consumerId, String filename, String serverName) {
        this.consumerId = consumerId;
        this.filename = filename;
        this.serverName = serverName;
    }

    public ExporterLogFile(String consumerId, String filename, String serverName, String idcName) {
        this.consumerId = consumerId;
        this.filename = filename;
        this.serverName = serverName;
        this.lindormIdc = new LindormIdc(idcName);
    }

    public ExporterLogFile(String consumerId, String filename, String serverName, String idcName, ExporterLogState state) {
        this.consumerId = consumerId;
        this.serverName = serverName;
        this.filename = filename;
        this.lindormIdc = new LindormIdc(idcName);
        this.state = state;
    }

    public void setConsumerId(String consumerId) {
        this.consumerId = consumerId;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getConsumerId() {
        return this.consumerId;
    }

    public LindormIdc getLindormIdc() {
        return this.lindormIdc;
    }

    public ExporterLogState getState() {
        return this.state;
    }

    public void setState(ExporterLogState state) {
        this.state = state;
    }

    public String getServerName() {
        return this.serverName;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public long getCloseTime() {
        return this.closeTime;
    }

    public void setCloseTime(long closeTime) {
        this.closeTime = closeTime;
    }

    public long getSyncTime() {
        return this.syncTime;
    }

    public void setSyncTime(long syncTime) {
        this.syncTime = syncTime;
    }

    public int compareTo(Object o) {
        ExporterLogFile otherFile = (ExporterLogFile)o;
        return this.filename.compareTo(otherFile.getFilename());
    }

    @Override
    protected byte getSupportedVersion() {
        return 2;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeString(out, this.consumerId);
        WritableUtils.writeString(out, this.serverName);
        WritableUtils.writeString(out, this.filename);
        this.lindormIdc.writeTo(out);
        out.writeInt(this.state.getCode());
        out.writeLong(this.createTime);
        out.writeLong(this.closeTime);
        out.writeLong(this.syncTime);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.consumerId = WritableUtils.readString(in);
        this.serverName = WritableUtils.readString(in);
        this.filename = WritableUtils.readString(in);
        this.lindormIdc = new LindormIdc();
        this.lindormIdc.readFrom(in);
        this.state = ExporterLogState.codeToState(in.readInt());
        if (this.getVersion() >= 1) {
            this.createTime = in.readLong();
            this.closeTime = in.readLong();
        }
        if (this.getVersion() >= 2) {
            this.syncTime = in.readLong();
        }
    }

    @Override
    public String toString() {
        return this.consumerId + " / " + this.lindormIdc + " / " + this.serverName + " / " + this.filename + " / " + (this.state == null ? " unknow" : this.state.name()) + " / " + "" + this.createTime + " / " + this.closeTime + " / " + this.syncTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getLogInfoBytes() throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        try {
            out.writeInt(this.state.getCode());
            out.writeLong(this.createTime);
            out.writeLong(this.closeTime);
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogInfoFromBytes(byte[] bytes) throws IOException {
        ByteBuf byteBuf = Unpooled.wrappedBuffer(bytes);
        ByteBufInputStream in = new ByteBufInputStream(byteBuf);
        try {
            this.state = ExporterLogState.codeToState(in.readInt());
            if (in.available() > 0) {
                this.createTime = in.readLong();
                this.closeTime = in.readLong();
            }
        }
        finally {
            in.close();
        }
    }
}

