/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.netty.jctools.queues.atomic;

import com.alibaba.lindorm.thirdparty.netty.jctools.queues.atomic.MpmcAtomicArrayQueue;
import com.alibaba.lindorm.thirdparty.netty.jctools.queues.atomic.MpscAtomicArrayQueue;
import com.alibaba.lindorm.thirdparty.netty.jctools.queues.atomic.MpscLinkedAtomicQueue;
import com.alibaba.lindorm.thirdparty.netty.jctools.queues.atomic.SpmcAtomicArrayQueue;
import com.alibaba.lindorm.thirdparty.netty.jctools.queues.atomic.SpscAtomicArrayQueue;
import com.alibaba.lindorm.thirdparty.netty.jctools.queues.atomic.SpscLinkedAtomicQueue;
import com.alibaba.lindorm.thirdparty.netty.jctools.queues.spec.ConcurrentQueueSpec;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class AtomicQueueFactory {
    public static <E> Queue<E> newQueue(ConcurrentQueueSpec qs) {
        if (qs.isBounded()) {
            if (qs.isSpsc()) {
                return new SpscAtomicArrayQueue(qs.capacity);
            }
            if (qs.isMpsc()) {
                return new MpscAtomicArrayQueue(qs.capacity);
            }
            if (qs.isSpmc()) {
                return new SpmcAtomicArrayQueue(qs.capacity);
            }
            return new MpmcAtomicArrayQueue(qs.capacity);
        }
        if (qs.isSpsc()) {
            return new SpscLinkedAtomicQueue();
        }
        if (qs.isMpsc()) {
            return new MpscLinkedAtomicQueue();
        }
        return new ConcurrentLinkedQueue();
    }
}

