/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.alibaba.hbase.client.AliHBaseAPIProxy;
import com.alibaba.hbase.client.AliHBaseUEConnection;
import com.alibaba.hbase.client.ElementConvertor;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.AliHBaseAdminInterface;
import org.apache.hadoop.hbase.client.AliHBaseUEClusterConnection;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.index.AliHBaseIndexDescriptor;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.UnknownSnapshotException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

public class AliHBaseUEAdmin
extends HBaseAdmin
implements AliHBaseAdminInterface {
    private static final Log LOG = LogFactory.getLog(HBaseAdmin.class);
    private AliHBaseUEConnection connection;
    private int operationTimeout;
    private Configuration conf;
    private AliHBaseAPIProxy proxy;
    private static AliHBaseUEClusterConnection superConnection = null;

    private static AliHBaseUEClusterConnection getSuperConnection(AliHBaseUEConnection connection) throws IOException {
        if (superConnection == null || superConnection.isClosed()) {
            superConnection = new AliHBaseUEClusterConnection(connection);
        }
        return superConnection;
    }

    public AliHBaseUEAdmin(AliHBaseUEConnection connection) throws IOException {
        super((ClusterConnection)AliHBaseUEAdmin.getSuperConnection(connection));
        this.connection = connection;
        this.conf = connection.getConfiguration();
        this.operationTimeout = connection.getOperationTimeout();
        this.proxy = connection.getAPIProxy(null);
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public void abort(String why, Throwable e) {
    }

    public boolean isAborted() {
        return false;
    }

    public void close() throws IOException {
        this.proxy.close();
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public boolean tableExists(TableName tableName) throws IOException {
        return this.proxy.tableExists(tableName);
    }

    public boolean tableExists(byte[] tableName) throws IOException {
        return this.tableExists(TableName.valueOf((byte[])tableName));
    }

    public boolean tableExists(String tableName) throws IOException {
        return this.tableExists(TableName.valueOf((String)tableName));
    }

    public HConnection getConnection() {
        return super.getConnection();
    }

    public HTableDescriptor[] listTables() throws IOException {
        return this.proxy.listTableDescriptors().toArray(new HTableDescriptor[0]);
    }

    public HTableDescriptor[] listTables(Pattern pattern) throws IOException {
        HTableDescriptor[] tables = this.listTables();
        if (tables != null && tables.length > 0) {
            ArrayList<HTableDescriptor> result = new ArrayList<HTableDescriptor>();
            for (HTableDescriptor table : tables) {
                Matcher matcher = pattern.matcher(table.getTableName().getNameAsString());
                if (!matcher.matches()) continue;
                result.add(table);
            }
            return result.toArray(new HTableDescriptor[result.size()]);
        }
        return tables;
    }

    public HTableDescriptor[] listTables(String regex) throws IOException {
        return this.listTables(Pattern.compile(regex));
    }

    public HTableDescriptor[] listTables(Pattern pattern, boolean includeSysTables) throws IOException {
        return this.listTables(pattern);
    }

    public HTableDescriptor[] listTables(String regex, boolean includeSysTables) throws IOException {
        return this.listTables(Pattern.compile(regex));
    }

    public TableName[] listTableNames() throws IOException {
        return this.proxy.listTableNames();
    }

    public TableName[] listTableNames(Pattern pattern) throws IOException {
        TableName[] allTables = this.listTableNames();
        ArrayList<TableName> results = new ArrayList<TableName>();
        for (int i = 0; i < allTables.length; ++i) {
            if (!pattern.matcher(allTables[i].getNameAsString()).matches()) continue;
            results.add(allTables[i]);
        }
        return results.toArray(new TableName[0]);
    }

    public TableName[] listTableNames(String regex) throws IOException {
        return this.listTableNames(Pattern.compile(regex));
    }

    public TableName[] listTableNames(Pattern pattern, boolean includeSysTables) throws IOException {
        return this.listTableNames(pattern);
    }

    public TableName[] listTableNames(String regex, boolean includeSysTables) throws IOException {
        return this.listTableNames(Pattern.compile(regex));
    }

    public HTableDescriptor getTableDescriptor(TableName tableName) throws TableNotFoundException, IOException {
        return this.proxy.getDescriptor(tableName);
    }

    public HTableDescriptor[] listTableDescriptorsByNamespace(String name) throws IOException {
        return this.proxy.listTableDescriptorsByNamespace(name).toArray(new HTableDescriptor[0]);
    }

    public HTableDescriptor[] getTableDescriptorsByTableName(List<TableName> tableNames) throws IOException {
        HTableDescriptor[] tableDescriptors = new HTableDescriptor[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tableDescriptors[i] = this.getTableDescriptor(tableNames.get(i));
        }
        return tableDescriptors;
    }

    public List<HTableDescriptor> listTableDescriptors(List<TableName> tableNames) throws IOException {
        ArrayList<HTableDescriptor> tableDescriptors = new ArrayList<HTableDescriptor>();
        for (TableName tableName : tableNames) {
            tableDescriptors.add(this.getTableDescriptor(tableName));
        }
        return tableDescriptors;
    }

    public HTableDescriptor[] getTableDescriptors(List<String> names) throws IOException {
        ArrayList<TableName> tableNames = new ArrayList<TableName>();
        for (String name : names) {
            tableNames.add(TableName.valueOf((String)name));
        }
        return this.getTableDescriptorsByTableName(tableNames);
    }

    public TableName[] listTableNamesByNamespace(String name) throws IOException {
        return this.proxy.listTableNamesByNamespace(name);
    }

    public void createTable(HTableDescriptor desc) throws IOException {
        this.createTable(desc, null);
    }

    public void createTable(HTableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        if (numRegions < 3) {
            throw new IllegalArgumentException("Must create at least three regions");
        }
        if (Bytes.compareTo((byte[])startKey, (byte[])endKey) >= 0) {
            throw new IllegalArgumentException("Start key must be smaller than end key");
        }
        if (numRegions == 3) {
            this.createTable(desc, new byte[][]{startKey, endKey});
            return;
        }
        byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)(numRegions - 3));
        if (splitKeys == null || splitKeys.length != numRegions - 1) {
            throw new IllegalArgumentException("Unable to split key range into enough regions");
        }
        this.createTable(desc, splitKeys);
    }

    public void createTable(HTableDescriptor hTableDescriptor, byte[][] bytes) throws IOException {
        TableName.isLegalFullyQualifiedTableName((byte[])hTableDescriptor.getTableName().getName());
        this.proxy.createTable(hTableDescriptor, bytes);
    }

    public void deleteTable(TableName tableName) throws IOException {
        this.proxy.deleteTable(tableName);
    }

    public void deleteTable(String tableName) throws IOException {
        this.deleteTable(TableName.valueOf((String)tableName));
    }

    public void deleteTable(byte[] tableName) throws IOException {
        this.deleteTable(TableName.valueOf((byte[])tableName));
    }

    public void truncateTable(TableName tableName, boolean preserveSplits) throws IOException {
        this.proxy.truncateTable(tableName, preserveSplits);
    }

    public void enableTable(TableName tableName) throws IOException {
        this.proxy.enableTable(tableName);
    }

    public void enableTable(byte[] tableName) throws IOException {
        this.enableTable(TableName.valueOf((byte[])tableName));
    }

    public void enableTable(String tableName) throws IOException {
        this.enableTable(TableName.valueOf((String)tableName));
    }

    public void disableTable(TableName tableName) throws IOException {
        this.proxy.disableTable(tableName);
    }

    public void disableTable(byte[] tableName) throws IOException {
        this.disableTable(TableName.valueOf((byte[])tableName));
    }

    public void disableTable(String tableName) throws IOException {
        this.disableTable(TableName.valueOf((String)tableName));
    }

    public boolean isTableEnabled(TableName tableName) throws IOException {
        return this.proxy.isTableEnabled(tableName);
    }

    public boolean isTableEnabled(byte[] tableName) throws IOException {
        return this.isTableEnabled(TableName.valueOf((byte[])tableName));
    }

    public boolean isTableEnabled(String tableName) throws IOException {
        return this.isTableEnabled(TableName.valueOf((String)tableName));
    }

    public boolean isTableDisabled(TableName tableName) throws IOException {
        return this.proxy.isTableDisabled(tableName);
    }

    public boolean isTableDisabled(byte[] tableName) throws IOException {
        return this.isTableDisabled(TableName.valueOf((byte[])tableName));
    }

    public boolean isTableDisabled(String tableName) throws IOException {
        return this.isTableDisabled(TableName.valueOf((String)tableName));
    }

    public boolean isTableAvailable(TableName tableName) throws IOException {
        return this.proxy.isTableAvailable(tableName);
    }

    public boolean isTableAvailable(byte[] tableName) throws IOException {
        return this.isTableAvailable(TableName.valueOf((byte[])tableName));
    }

    public boolean isTableAvailable(String tableName) throws IOException {
        return this.isTableAvailable(TableName.valueOf((String)tableName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTableAvailable(TableName tableName, byte[][] splitKeys) throws IOException {
        boolean enable = this.isTableEnabled(tableName);
        if (enable) {
            try (AliHBaseAPIProxy localProxy = null;){
                localProxy = this.connection.getAPIProxy(tableName);
                Pair<byte[][], byte[][]> pair = localProxy.getStartEndKeys();
                byte[][] startKeys = (byte[][])pair.getFirst();
                byte[][] endKeys = (byte[][])pair.getSecond();
                if (startKeys.length != splitKeys.length + 1 || endKeys.length != splitKeys.length + 1) {
                    boolean bl = false;
                    return bl;
                }
                for (int i = 0; i < splitKeys.length; ++i) {
                    if (Bytes.equals((byte[])startKeys[i + 1], (byte[])splitKeys[i]) && Bytes.equals((byte[])endKeys[i], (byte[])splitKeys[i])) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = enable;
                return bl;
            }
        }
        return enable;
    }

    public void addColumn(TableName tableName, HColumnDescriptor columnFamily) throws IOException {
        this.proxy.addColumnFamily(tableName, columnFamily);
    }

    public void addColumn(byte[] tableName, HColumnDescriptor column) throws IOException {
        this.addColumn(TableName.valueOf((byte[])tableName), column);
    }

    public void addColumn(String tableName, HColumnDescriptor column) throws IOException {
        this.addColumn(TableName.valueOf((String)tableName), column);
    }

    public void deleteColumn(TableName tableName, byte[] columnFamily) throws IOException {
        this.proxy.deleteColumnFamily(tableName, columnFamily);
    }

    public void deleteColumn(byte[] tableName, String columnName) throws IOException {
        this.deleteColumn(TableName.valueOf((byte[])tableName), Bytes.toBytes((String)columnName));
    }

    public void deleteColumn(String tableName, String columnName) throws IOException {
        this.deleteColumn(TableName.valueOf((String)tableName), Bytes.toBytes((String)columnName));
    }

    public void modifyColumn(TableName tableName, HColumnDescriptor columnFamily) throws IOException {
        this.proxy.modifyColumnFamily(tableName, columnFamily);
    }

    public void modifyColumn(String tableName, HColumnDescriptor descriptor) throws IOException {
        this.modifyColumn(TableName.valueOf((String)tableName), descriptor);
    }

    public void modifyColumn(byte[] tableName, HColumnDescriptor descriptor) throws IOException {
        this.modifyColumn(TableName.valueOf((byte[])tableName), descriptor);
    }

    public void modifyTable(TableName tableName, HTableDescriptor td) throws IOException {
        this.modifyTable(td);
    }

    public void modifyTable(byte[] tableName, HTableDescriptor htd) throws IOException {
        this.modifyTable(TableName.valueOf((byte[])tableName), htd);
    }

    public void modifyTable(String tableName, HTableDescriptor htd) throws IOException {
        this.modifyTable(TableName.valueOf((String)tableName), htd);
    }

    public void modifyTable(HTableDescriptor td) throws IOException {
        this.proxy.modifyTable(td);
    }

    public void modifyNamespace(NamespaceDescriptor descriptor) throws IOException {
    }

    public void deleteNamespace(String name) throws IOException {
        this.proxy.deleteNamespace(name);
    }

    public NamespaceDescriptor getNamespaceDescriptor(String name) throws NamespaceNotFoundException, IOException {
        return this.proxy.getNamespaceDescriptor(name);
    }

    public NamespaceDescriptor[] listNamespaceDescriptors() throws IOException {
        return this.proxy.listNamespaceDescriptors();
    }

    public void createNamespace(NamespaceDescriptor descriptor) throws IOException {
        String namespace = descriptor.getName();
        TableName.isLegalNamespaceName((byte[])Bytes.toBytes((String)namespace));
        this.proxy.createNamespace(descriptor);
    }

    public void flush(TableName tableName) {
        this.proxy.flushTable(tableName);
    }

    public void flush(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.flush(Bytes.toBytes((String)tableNameOrRegionName));
    }

    public void flush(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        try {
            this.flushRegion(tableNameOrRegionName);
        }
        catch (IllegalArgumentException var3) {
            this.flush(TableName.valueOf((byte[])tableNameOrRegionName));
        }
    }

    public void flushRegion(byte[] regionName) {
        this.proxy.flushRegion(Bytes.toString((byte[])regionName));
    }

    public void compact(TableName tableName) {
        this.proxy.compactTable(tableName);
    }

    public void compact(String tableNameOrRegionName) throws IOException {
        this.compact(Bytes.toBytes((String)tableNameOrRegionName));
    }

    public void compactRegion(byte[] regionName) {
        this.proxy.compactRegion(Bytes.toString((byte[])regionName));
    }

    public void compact(TableName tableName, byte[] columnFamily) {
        this.compact(tableName);
    }

    public void compact(byte[] tableNameOrRegionName) throws IOException {
        try {
            this.compactRegion(tableNameOrRegionName);
        }
        catch (IllegalArgumentException var3) {
            this.compact(TableName.valueOf((byte[])tableNameOrRegionName));
        }
    }

    public void compact(String tableOrRegionName, String columnFamily) throws IOException {
        this.compact(Bytes.toBytes((String)tableOrRegionName), Bytes.toBytes((String)columnFamily));
    }

    public void compact(byte[] tableNameOrRegionName, byte[] columnFamily) throws IOException {
        this.compact(tableNameOrRegionName);
    }

    public void compactRegion(byte[] regionName, byte[] columnFamily) {
        this.compactRegion(regionName);
    }

    public void majorCompact(TableName tableName) {
        this.proxy.majorCompactTable(tableName);
    }

    public void majorCompactRegion(byte[] regionName) {
        this.proxy.majorCompactRegion(Bytes.toString((byte[])regionName));
    }

    public void majorCompact(String tableNameOrRegionName, String columnFamily) throws IOException {
        this.majorCompact(Bytes.toBytes((String)tableNameOrRegionName), Bytes.toBytes((String)columnFamily));
    }

    public void majorCompact(byte[] tableNameOrRegionName, byte[] columnFamily) throws IOException {
        try {
            this.majorCompactRegion(tableNameOrRegionName, columnFamily);
        }
        catch (IllegalArgumentException var4) {
            this.majorCompact(TableName.valueOf((byte[])tableNameOrRegionName), columnFamily);
        }
    }

    public void majorCompact(TableName tableName, byte[] columnFamily) {
        this.majorCompact(tableName);
    }

    public void majorCompact(String tableNameOrRegionName) throws IOException {
        this.majorCompact(Bytes.toBytes((String)tableNameOrRegionName));
    }

    public void majorCompact(byte[] tableNameOrRegionName) throws IOException {
        try {
            this.majorCompactRegion(tableNameOrRegionName);
        }
        catch (IllegalArgumentException var3) {
            this.majorCompact(TableName.valueOf((byte[])tableNameOrRegionName));
        }
    }

    public void majorCompactRegion(byte[] regionName, byte[] columnFamily) {
        this.majorCompactRegion(regionName);
    }

    public boolean switchRpcThrottle(boolean enable) throws IOException {
        return false;
    }

    public boolean isRpcThrottleEnabled() throws IOException {
        return false;
    }

    public boolean exceedThrottleQuotaSwitch(boolean enable) throws IOException {
        return false;
    }

    public HTableDescriptor[] disableTables(String regex) throws IOException {
        return this.disableTables(Pattern.compile(regex));
    }

    public HTableDescriptor[] disableTables(Pattern pattern) throws IOException {
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : this.listTables(pattern)) {
            if (!this.isTableEnabled(table.getTableName())) continue;
            try {
                this.disableTable(table.getTableName());
            }
            catch (IOException ex) {
                LOG.info((Object)("Failed to disable table " + table.getTableName()), (Throwable)ex);
                failed.add(table);
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    public HTableDescriptor[] enableTables(String regex) throws IOException {
        return this.enableTables(Pattern.compile(regex));
    }

    public HTableDescriptor[] enableTables(Pattern pattern) throws IOException {
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : this.listTables(pattern)) {
            if (!this.isTableDisabled(table.getTableName())) continue;
            try {
                this.enableTable(table.getTableName());
            }
            catch (IOException ex) {
                LOG.info((Object)("Failed to enable table " + table.getTableName()), (Throwable)ex);
                failed.add(table);
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    public HTableDescriptor[] deleteTables(String regex) throws IOException {
        throw new UnsupportedOperationException("deleteTables by pattern not supported");
    }

    public HTableDescriptor[] deleteTables(Pattern pattern) throws IOException {
        throw new UnsupportedOperationException("deleteTables by pattern not supported");
    }

    public void closeRegion(String regionname, String serverName) {
    }

    public void closeRegion(byte[] regionname, String serverName) {
    }

    public boolean closeRegionWithEncodedRegionName(String encodedRegionName, String serverName) {
        return false;
    }

    public void closeRegion(ServerName sn, HRegionInfo hri) {
    }

    public List<HRegionInfo> getOnlineRegions(ServerName sn) {
        return new ArrayList<HRegionInfo>();
    }

    public List<HRegionInfo> getRegions(ServerName serverName) {
        return new ArrayList<HRegionInfo>();
    }

    public Map<ServerName, Boolean> compactionSwitch(boolean switchState, List<String> serverNamesList) {
        return new HashMap<ServerName, Boolean>();
    }

    public void move(byte[] encodedRegionName) {
    }

    public void move(byte[] encodedRegionName, ServerName destServerName) {
    }

    public void assign(byte[] regionName) {
    }

    public void unassign(byte[] regionName, boolean force) {
    }

    public void offline(byte[] regionName) {
    }

    public boolean isBalancerEnabled() {
        return true;
    }

    public boolean normalize() {
        return true;
    }

    public boolean isNormalizerEnabled() {
        return true;
    }

    public boolean isCatalogJanitorEnabled() {
        return true;
    }

    public boolean runCleanerChore() {
        return true;
    }

    public boolean isCleanerChoreEnabled() {
        return true;
    }

    public void mergeRegions(byte[] nameOfRegionA, byte[] nameOfRegionB, boolean forcible) {
        String regionA = Bytes.toString((byte[])nameOfRegionA);
        String regionB = Bytes.toString((byte[])nameOfRegionB);
        String[] splitA = regionA.split(",");
        String[] splitB = regionB.split(",");
        Preconditions.checkArgument((splitA.length > 1 && splitB.length > 1 ? 1 : 0) != 0, (Object)"only support full region name");
        String tableNameA = splitA[0];
        String tableNameB = splitB[0];
        Preconditions.checkArgument((boolean)StringUtils.equals((String)tableNameA, (String)tableNameB), (Object)"regions to be merged should belong to the same table");
        String shortNameA = regionA.split("\\.")[2];
        String shortNameB = regionB.split("\\.")[2];
        this.proxy.mergeRegions(tableNameA, shortNameA, shortNameB);
    }

    public void split(TableName tableName) {
        String table = ElementConvertor.toLindormTableFullName(tableName);
        this.proxy.split(table, null);
    }

    public void splitRegion(byte[] regionName) {
        this.proxy.split(Bytes.toString((byte[])regionName), null);
    }

    public void split(TableName tableName, byte[] splitPoint) {
        String table = ElementConvertor.toLindormTableFullName(tableName);
        this.proxy.split(table, splitPoint);
    }

    public void splitRegion(byte[] regionName, byte[] splitPoint) {
        this.proxy.split(Bytes.toString((byte[])regionName), splitPoint);
    }

    public void shutdown() {
    }

    public void stopMaster() {
    }

    public boolean isMasterInMaintenanceMode() {
        return false;
    }

    public void stopRegionServer(String hostnamePort) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HRegionInfo> getTableRegions(TableName tableName) throws IOException {
        try (AliHBaseAPIProxy localProxy = null;){
            localProxy = this.connection.getAPIProxy(tableName);
            List<HRegionLocation> list = localProxy.getAllRegionLocations();
            ArrayList<HRegionInfo> result = new ArrayList<HRegionInfo>(list.size());
            for (HRegionLocation location : list) {
                result.add(location.getRegionInfo());
            }
            ArrayList<HRegionInfo> arrayList = result;
            return arrayList;
        }
    }

    public boolean abortProcedure(long procId, boolean mayInterruptIfRunning) {
        return false;
    }

    public Future<Boolean> abortProcedureAsync(long procId, boolean mayInterruptIfRunning) {
        return new Future<Boolean>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public Boolean get() throws InterruptedException, ExecutionException {
                return false;
            }

            @Override
            public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return false;
            }
        };
    }

    public void rollWALWriter(ServerName serverName) {
    }

    public long getLastMajorCompactionTimestamp(TableName tableName) {
        return 0L;
    }

    public long getLastMajorCompactionTimestampForRegion(byte[] regionName) {
        return 0L;
    }

    public void snapshot(String snapshotName, TableName tableName) {
        throw new UnsupportedOperationException("snapshot not supported");
    }

    public void snapshot(byte[] snapshotName, TableName tableName) {
        throw new UnsupportedOperationException("snapshot not supported");
    }

    public void restoreSnapshot(byte[] snapshotName) {
        throw new UnsupportedOperationException("restoreSnapshot not supported");
    }

    public void restoreSnapshot(String snapshotName) {
        throw new UnsupportedOperationException("restoreSnapshot not supported");
    }

    public void restoreSnapshot(byte[] snapshotName, boolean takeFailSafeSnapshot) {
        throw new UnsupportedOperationException("restoreSnapshot not supported");
    }

    public void restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot) {
        throw new UnsupportedOperationException("restoreSnapshot not supported");
    }

    public void restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot, boolean restoreAcl) {
        throw new UnsupportedOperationException("restoreSnapshot not supported");
    }

    public void cloneSnapshot(byte[] snapshotName, TableName tableName) {
        throw new UnsupportedOperationException("cloneSnapshot not supported");
    }

    public void cloneSnapshot(String snapshotName, TableName tableName, boolean restoreAcl) {
        throw new UnsupportedOperationException("cloneSnapshot not supported");
    }

    public void cloneSnapshot(String snapshotName, TableName tableName) {
        throw new UnsupportedOperationException("cloneSnapshot not supported");
    }

    public void execProcedure(String signature, String instance, Map<String, String> props) {
        throw new UnsupportedOperationException("execProcedure not supported");
    }

    public boolean isProcedureFinished(String signature, String instance, Map<String, String> props) {
        return true;
    }

    public void deleteSnapshot(byte[] snapshotName) {
        throw new UnsupportedOperationException("deleteSnapshot not supported");
    }

    public void deleteSnapshot(String snapshotName) {
        throw new UnsupportedOperationException("deleteSnapshot not supported");
    }

    public void deleteSnapshots(String regex) {
        throw new UnsupportedOperationException("deleteSnapshots not supported");
    }

    public void deleteSnapshots(Pattern pattern) {
        throw new UnsupportedOperationException("deleteSnapshots not supported");
    }

    public void deleteTableSnapshots(String tableNameRegex, String snapshotNameRegex) {
        throw new UnsupportedOperationException("deleteTableSnapshots not supported");
    }

    public void deleteTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) {
        throw new UnsupportedOperationException("deleteTableSnapshots not supported");
    }

    public void setQuota(QuotaSettings quota) {
    }

    public QuotaRetriever getQuotaRetriever(QuotaFilter filter) {
        throw new UnsupportedOperationException("getQuotaRetriever not supported");
    }

    public CoprocessorRpcChannel coprocessorService() {
        throw new UnsupportedOperationException("coprocessorService not supported");
    }

    public CoprocessorRpcChannel coprocessorService(ServerName serverName) {
        throw new UnsupportedOperationException("coprocessorService not supported");
    }

    public void updateConfiguration(ServerName server) {
    }

    public void updateConfiguration() {
    }

    public List<ServerName> clearDeadServers(List<ServerName> servers) {
        return new ArrayList<ServerName>();
    }

    public void move(byte[] bytes, byte[] bytes1) throws IOException {
    }

    public void createTableAsync(HTableDescriptor hTableDescriptor, byte[][] bytes) throws IOException {
        this.createTable(hTableDescriptor, bytes);
    }

    public void enableTableAsync(TableName tableName) throws IOException {
        this.enableTable(tableName);
    }

    public void disableTableAsync(TableName tableName) throws IOException {
        this.disableTable(tableName);
    }

    public Pair<Integer, Integer> getAlterStatus(TableName tableName) throws IOException {
        return new Pair((Object)0, (Object)1);
    }

    public Pair<Integer, Integer> getAlterStatus(byte[] bytes) throws IOException {
        return new Pair((Object)0, (Object)1);
    }

    public void compactRegionServer(ServerName serverName, boolean b) throws IOException, InterruptedException {
    }

    public boolean setBalancerRunning(boolean b, boolean b1) throws IOException {
        return true;
    }

    public boolean balancer() throws IOException {
        return false;
    }

    public boolean balancer(boolean b) throws IOException {
        return true;
    }

    public boolean setNormalizerRunning(boolean b) throws IOException {
        return true;
    }

    public boolean enableCatalogJanitor(boolean b) throws IOException {
        return true;
    }

    public int runCatalogScan() throws IOException {
        return 0;
    }

    public boolean setCleanerChoreRunning(boolean b) throws IOException {
        return true;
    }

    public ClusterStatus getClusterStatus() throws IOException {
        ClusterStatus status = new ClusterStatus();
        return status;
    }

    public ProcedureInfo[] listProcedures() throws IOException {
        return new ProcedureInfo[0];
    }

    public String[] getMasterCoprocessors() {
        return new String[0];
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState(TableName tableName) throws IOException {
        return AdminProtos.GetRegionInfoResponse.CompactionState.NONE;
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionStateForRegion(byte[] bytes) throws IOException {
        return AdminProtos.GetRegionInfoResponse.CompactionState.NONE;
    }

    public void snapshot(String s, TableName tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot not supported");
    }

    public void snapshot(HBaseProtos.SnapshotDescription snapshotDescription) throws IOException, SnapshotCreationException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot not supported");
    }

    public MasterProtos.SnapshotResponse takeSnapshotAsync(HBaseProtos.SnapshotDescription snapshotDescription) throws IOException, SnapshotCreationException {
        throw new UnsupportedOperationException("takeSnapshotAsync not supported");
    }

    public boolean isSnapshotFinished(HBaseProtos.SnapshotDescription snapshotDescription) throws IOException, HBaseSnapshotException, UnknownSnapshotException {
        return true;
    }

    public byte[] execProcedureWithRet(String s, String s1, Map<String, String> map) throws IOException {
        throw new UnsupportedOperationException("execProcedureWithRet not supported");
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots() throws IOException {
        throw new UnsupportedOperationException("listSnapshots not supported");
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots(String s) throws IOException {
        throw new UnsupportedOperationException("listSnapshots not supported");
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots(Pattern pattern) throws IOException {
        throw new UnsupportedOperationException("listSnapshots not supported");
    }

    public List<HBaseProtos.SnapshotDescription> listTableSnapshots(String s, String s1) throws IOException {
        throw new UnsupportedOperationException("listTableSnapshots not supported");
    }

    public List<HBaseProtos.SnapshotDescription> listTableSnapshots(Pattern pattern, Pattern pattern1) throws IOException {
        throw new UnsupportedOperationException("listTableSnapshots not supported");
    }

    public int getMasterInfoPort() throws IOException {
        return -1;
    }

    public List<ServerName> listDeadServers() throws IOException {
        return new ArrayList<ServerName>();
    }

    public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
        return true;
    }

    public String[] getTableNames() throws IOException {
        TableName[] tableNames = this.listTableNames();
        String[] tables = new String[tableNames.length];
        for (int i = 0; i < tableNames.length; ++i) {
            tables[i] = tableNames[i].toString();
        }
        return tables;
    }

    public String[] getTableNames(Pattern pattern) throws IOException {
        return this.getTableNames();
    }

    public String[] getTableNames(String regex) throws IOException {
        return this.getTableNames();
    }

    public HTableDescriptor getTableDescriptor(byte[] tableName) throws TableNotFoundException, IOException {
        return this.getTableDescriptor(TableName.valueOf((byte[])tableName));
    }

    public void enableTableAsync(byte[] tableName) throws IOException {
        this.enableTable(TableName.valueOf((byte[])tableName));
    }

    public void enableTableAsync(String tableName) throws IOException {
        this.enableTable(TableName.valueOf((String)tableName));
    }

    public void disableTableAsync(byte[] tableName) throws IOException {
        this.disableTable(TableName.valueOf((byte[])tableName));
    }

    public void disableTableAsync(String tableName) throws IOException {
        this.disableTable(TableName.valueOf((String)tableName));
    }

    public boolean isTableAvailable(byte[] tableName, byte[][] splitKeys) throws IOException {
        return this.isTableAvailable(TableName.valueOf((byte[])tableName), splitKeys);
    }

    public boolean isTableAvailable(String tableName, byte[][] splitKeys) throws IOException {
        return this.isTableAvailable(TableName.valueOf((String)tableName), splitKeys);
    }

    public void split(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.proxy.split(tableNameOrRegionName, null);
    }

    public void split(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        this.proxy.split(Bytes.toString((byte[])tableNameOrRegionName), null);
    }

    public void split(String tableNameOrRegionName, String splitPoint) throws IOException {
        this.proxy.split(tableNameOrRegionName, splitPoint == null ? null : Bytes.toBytes((String)splitPoint));
    }

    public void split(byte[] tableNameOrRegionName, byte[] splitPoint) throws IOException {
        this.proxy.split(Bytes.toString((byte[])tableNameOrRegionName), splitPoint);
    }

    public void split(ServerName sn, HRegionInfo hri, byte[] splitPoint) throws IOException {
        throw new UnsupportedOperationException("split not supported");
    }

    public List<HRegionInfo> getTableRegions(byte[] tableName) throws IOException {
        return this.getTableRegions(TableName.valueOf((byte[])tableName));
    }

    public synchronized byte[][] rollHLogWriter(String serverName) throws IOException, FailedLogCloseException {
        return null;
    }

    public void snapshot(String snapshotName, String tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot not supported");
    }

    public void snapshot(byte[] snapshotName, byte[] tableName, HBaseProtos.SnapshotDescription.Type flushType) throws IOException, SnapshotCreationException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot not supported");
    }

    public void snapshot(byte[] snapshotName, byte[] tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot not supported");
    }

    public void snapshot(String snapshotName, String tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot not supported");
    }

    public void snapshot(String snapshotName, byte[] tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot not supported");
    }

    public void cloneSnapshot(byte[] snapshotName, byte[] tableName) throws IOException, TableExistsException, RestoreSnapshotException {
        throw new UnsupportedOperationException("cloneSnapshot not supported");
    }

    public void cloneSnapshot(String snapshotName, String tableName) throws IOException, TableExistsException, RestoreSnapshotException, InterruptedException {
        throw new UnsupportedOperationException("cloneSnapshot not supported");
    }

    @Override
    public List<AliHBaseIndexDescriptor> describeIndex(TableName dataTableName) throws IOException {
        return this.proxy.describeIndex(dataTableName);
    }

    @Override
    public void createIndex(AliHBaseIndexDescriptor indexDescriptor) throws IOException {
        this.proxy.createIndex(indexDescriptor);
    }

    @Override
    public void createIndex(AliHBaseIndexDescriptor indexDescriptor, byte[][] splitKeys) throws IOException {
        this.proxy.createIndex(indexDescriptor, splitKeys);
    }

    @Override
    public void createIndex(AliHBaseIndexDescriptor index, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        this.proxy.createIndex(index, startKey, endKey, numRegions);
    }

    @Override
    public void deleteIndex(String indexName, TableName dataTable) throws IOException {
        this.proxy.deleteIndex(indexName, dataTable);
    }

    @Override
    public void offlineIndex(String indexName, TableName dataTable) throws IOException {
        this.proxy.offlineIndex(indexName, dataTable);
    }

    @Override
    public void registerBDSCluster(String hbaseSourceName, String bdsClusterkey, String hbaseConnectionString, String username, String password) throws IOException {
        this.proxy.registerBDSCluster(hbaseSourceName, bdsClusterkey, hbaseConnectionString, username, password);
    }

    @Override
    public void registerSolrCluster(String solrSourceName, String solrConnectionStr) throws IOException {
        this.proxy.registerSolrCluster(solrSourceName, solrConnectionStr);
    }

    @Override
    public void registerESCluster(String esSourceName, String esConnectionStr, String userName, String password) throws IOException {
        this.proxy.registerESCluster(esSourceName, esConnectionStr, userName, password);
    }

    @Override
    public void unregisterSolrCluster(boolean force) throws IOException {
        this.proxy.unregisterSolrCluster(force);
    }

    @Override
    public void unregisterESCluster(boolean force) throws IOException {
        this.proxy.unregisterESCluster(force);
    }

    @Override
    public void unregisterBDSCluster(boolean force) throws IOException {
        this.proxy.unregisterBDSCluster(force);
    }
}

