/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.index;

import java.util.Arrays;
import org.apache.hadoop.hbase.util.Bytes;

public class AliHBaseColumn {
    public static AliHBaseColumn COVER_ALL = new AliHBaseColumn();
    private final byte[] family;
    private final byte[] qualifier;
    private final SortOrder sortOrder;
    private int hashCode = 0;

    public static AliHBaseColumn createCoveredColumn(byte[] family, byte[] qualifier) {
        return new AliHBaseColumn(family, qualifier, null);
    }

    public static AliHBaseColumn createIndexedColumn(byte[] family, byte[] qualifier) {
        return new AliHBaseColumn(family, qualifier, SortOrder.getDefault());
    }

    public static AliHBaseColumn createIndexedColumn(byte[] family, byte[] qualifier, SortOrder sortOrder) {
        if (sortOrder == null) {
            throw new IllegalArgumentException("SortOrder must not be null.");
        }
        return new AliHBaseColumn(family, qualifier, sortOrder);
    }

    private AliHBaseColumn(byte[] family, byte[] qualifier) {
        this(family, qualifier, null);
    }

    private AliHBaseColumn() {
        this.family = null;
        this.qualifier = null;
        this.sortOrder = null;
    }

    private AliHBaseColumn(byte[] family, byte[] qualifier, SortOrder sortOrder) {
        AliHBaseColumn.checkNotNull(qualifier, "qualifier name");
        if (!Bytes.equals((byte[])qualifier, (byte[])Bytes.toBytes((String)"ROW"))) {
            AliHBaseColumn.checkNotNull(family, "family name");
        }
        this.family = family;
        this.qualifier = qualifier;
        this.sortOrder = sortOrder;
    }

    public byte[] getFamily() {
        return this.family;
    }

    public byte[] getQualifier() {
        return this.qualifier;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String toString() {
        if (this == COVER_ALL) {
            return "@@ALL@@";
        }
        String column = (this.getFamily() != null ? Bytes.toString((byte[])this.getFamily()) + "." : "") + Bytes.toString((byte[])this.getQualifier());
        if (this.sortOrder == null) {
            return column;
        }
        return column + " " + (Object)((Object)this.sortOrder);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Arrays.hashCode(this.family) * 31 + Arrays.hashCode(this.qualifier);
            if (this.sortOrder != null) {
                this.hashCode += this.sortOrder.hashCode();
            }
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AliHBaseColumn)) {
            return false;
        }
        AliHBaseColumn other = (AliHBaseColumn)obj;
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        if (!Bytes.equals((byte[])this.qualifier, (byte[])other.qualifier)) {
            return false;
        }
        if (!Bytes.equals((byte[])this.family, (byte[])other.family)) {
            return false;
        }
        return this.sortOrder == other.sortOrder;
    }

    private static void checkNotNull(byte[] value, String msg) {
        if (value == null || value.length == 0) {
            throw new IllegalArgumentException(msg + " must not be null or empty");
        }
    }

    public static enum SortOrder {
        ASC(com.alibaba.lindorm.client.schema.SortOrder.ASC),
        DESC(com.alibaba.lindorm.client.schema.SortOrder.DESC);

        private com.alibaba.lindorm.client.schema.SortOrder impl;

        private SortOrder(com.alibaba.lindorm.client.schema.SortOrder impl) {
            this.impl = impl;
        }

        public com.alibaba.lindorm.client.schema.SortOrder getImplSortOrder() {
            return this.impl;
        }

        public static SortOrder fromImplSortOrder(com.alibaba.lindorm.client.schema.SortOrder so) {
            if (so == com.alibaba.lindorm.client.schema.SortOrder.ASC) {
                return ASC;
            }
            return DESC;
        }

        public static SortOrder getDefault() {
            return ASC;
        }
    }
}

