/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.index;

import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.index.AliHBaseColumn;
import org.apache.hadoop.hbase.util.Bytes;

public class AliHBaseIndexDescriptor {
    private String indexName;
    private TableName dataTable;
    private List<AliHBaseColumn> indexedColumns = new ArrayList<AliHBaseColumn>();
    private List<AliHBaseColumn> coveredColumns = new ArrayList<AliHBaseColumn>();
    private HColumnDescriptor familyDescriptor;

    public AliHBaseIndexDescriptor(String indexName, TableName dataTable) {
        this.indexName = indexName;
        this.dataTable = dataTable;
        this.familyDescriptor = new HColumnDescriptor(SchemaUtils.DEFAULT_FAMILY_NAME_BYTES);
    }

    public AliHBaseIndexDescriptor(String indexName, TableName dataTable, HColumnDescriptor familyDesc) {
        this.indexName = indexName;
        this.dataTable = dataTable;
        if (familyDesc == null) {
            throw new IllegalArgumentException("Index column family must not be null");
        }
        this.familyDescriptor = familyDesc;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public TableName getDataTable() {
        return this.dataTable;
    }

    public List<AliHBaseColumn> getIndexedColumns() {
        return this.indexedColumns;
    }

    public List<AliHBaseColumn> getCoveredColumns() {
        return this.coveredColumns;
    }

    public HColumnDescriptor getFamilyDescriptor() {
        return this.familyDescriptor;
    }

    public void setFamilyDescriptor(HColumnDescriptor familyDescriptor) {
        this.familyDescriptor = familyDescriptor;
    }

    public void addIndexedColumn(byte[] family, byte[] qualifier) {
        this.addIndexedColumn(family, qualifier, AliHBaseColumn.SortOrder.getDefault());
    }

    public void addIndexedColumn(String family, String qualifier) {
        this.addIndexedColumn(Bytes.toBytes((String)family), Bytes.toBytes((String)qualifier));
    }

    public void addIndexedColumn(byte[] family, byte[] qualifier, AliHBaseColumn.SortOrder sortOrder) {
        if (this.indexedColumns == null) {
            this.indexedColumns = new ArrayList<AliHBaseColumn>();
        }
        this.indexedColumns.add(AliHBaseColumn.createIndexedColumn(family, qualifier, sortOrder));
    }

    public void addIndexedColumn(String family, String qualifier, AliHBaseColumn.SortOrder sortOrder) {
        this.addIndexedColumn(Bytes.toBytes((String)family), Bytes.toBytes((String)qualifier), sortOrder);
    }

    public void addCoveredColumn(byte[] family, byte[] qualifier) {
        if (this.coveredColumns == null) {
            this.coveredColumns = new ArrayList<AliHBaseColumn>();
        }
        this.coveredColumns.add(AliHBaseColumn.createCoveredColumn(family, qualifier));
    }

    public void addCoveredColumn(String family, String qualifier) {
        this.addCoveredColumn(Bytes.toBytes((String)family), Bytes.toBytes((String)qualifier));
    }

    public void setCoveredAllColumns() {
        if (this.coveredColumns == null) {
            this.coveredColumns = new ArrayList<AliHBaseColumn>();
        }
        this.coveredColumns.clear();
        this.coveredColumns.add(AliHBaseColumn.COVER_ALL);
    }

    public String getSchema() {
        StringBuilder str = new StringBuilder();
        str.append("Index [");
        str.append(this.indexName);
        str.append("] on [");
        str.append(this.dataTable);
        str.append("] (");
        if (this.indexedColumns != null && this.indexedColumns.size() > 0) {
            for (AliHBaseColumn ic : this.indexedColumns) {
                str.append(ic.toString());
                str.append(",");
            }
            str.setLength(str.length() - 1);
        }
        str.append(")");
        if (this.coveredColumns != null && this.coveredColumns.size() > 0) {
            str.append(" includes (");
            for (AliHBaseColumn key : this.coveredColumns) {
                str.append(key);
                str.append(",");
            }
            str.setLength(str.length() - 1);
            str.append(")");
        }
        return str.toString();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getSchema());
        str.append(", INDEX_FAMILY_ATTR: ");
        str.append(this.getFamilyDescriptor().toString());
        return str.toString();
    }
}

