/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.lightapi;

import com.taobao.hsf.lightapi.ConsumerService;
import com.taobao.hsf.lightapi.ProviderService;
import com.taobao.hsf.lightapi.report.LightApiReporter;
import com.taobao.hsf.lightapi.util.LightConstant;
import com.taobao.hsf.standalone.HSFEasyStarter;
import com.taobao.hsf.standalone.util.Constant;
import com.taobao.middleware.pandora.toolkit.SarFetcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ServiceFactory {
    private static String sarPath = HSFEasyStarter.DEFAULT_RELEASE_PATH;
    private static ConcurrentHashMap<String, String> systemProps = new ConcurrentHashMap();
    private static HashMap<String, ProviderService> providers = new HashMap();
    private static HashMap<String, ConsumerService> consumers = new HashMap();
    private static volatile ServiceFactory factory;
    private static LightApiReporter reporter;

    private ServiceFactory() {
        this(null);
    }

    private ServiceFactory(String id) {
        this(id, -1, null);
    }

    private ServiceFactory(String id, String downloadURL) {
        this(id, -1, downloadURL);
    }

    private ServiceFactory(String id, int port, String downloadURL) {
        if (ServiceFactory.isPandoraInited()) {
            LightConstant.pandoraInited = true;
        } else {
            this.startPandora(id, port, downloadURL);
            LightConstant.pandoraInited = true;
        }
        reporter.doReport();
    }

    private void startPandora(String uniqueId, int port, String downloadURL) {
        ServiceFactory.addJVMProperties();
        String version = SarFetcher.getDefaultSarVersion();
        if (version == null) {
            version = "";
        }
        if (downloadURL != null) {
            Constant.perferDownloadUrl.set(downloadURL);
        }
        if (uniqueId == null) {
            HSFEasyStarter.start(sarPath, version);
        } else {
            HSFEasyStarter.startWithVersionAndIdentifier(version, uniqueId, port);
        }
    }

    public List<ProviderService> providers() {
        return new ArrayList<ProviderService>(providers.values());
    }

    public List<ConsumerService> consumers() {
        return new ArrayList<ConsumerService>(consumers.values());
    }

    public synchronized ProviderService provider(String id) {
        if (providers.get(id) == null) {
            providers.put(id, new ProviderService().newProvider());
            return providers.get(id);
        }
        return providers.get(id);
    }

    public synchronized ConsumerService consumer(String id) {
        if (consumers.get(id) == null) {
            consumers.put(id, new ConsumerService().newConsumer());
            return consumers.get(id);
        }
        if (!consumers.get(id).isConsumed()) {
            throw new RuntimeException(LightConstant.NOT_CONS);
        }
        return consumers.get(id);
    }

    public synchronized void destroy(String id) {
        ProviderService provider = providers.get(id);
        if (provider != null) {
            provider.offline();
            this.clearProvider(id);
        }
    }

    public synchronized void clearConsumer(String id) {
        consumers.remove(id);
    }

    @Deprecated
    public synchronized void clearProvider(String id) {
        providers.remove(id);
    }

    public static synchronized ServiceFactory getInstance() {
        return ServiceFactory.getInstance(null);
    }

    public static synchronized ServiceFactory getInstance(String uniqueId) {
        return ServiceFactory.getInstance(uniqueId, -1, null);
    }

    public static synchronized ServiceFactory getInstance(String uniqueId, int port) {
        return ServiceFactory.getInstance(uniqueId, port, null);
    }

    public static synchronized ServiceFactory getInstance(String uniqueId, String downloadURL) {
        return ServiceFactory.getInstance(uniqueId, -1, downloadURL);
    }

    public static synchronized ServiceFactory getInstance(String uniqueId, int port, String downloadURL) {
        if (factory == null) {
            factory = new ServiceFactory(uniqueId, port, downloadURL);
        }
        return factory;
    }

    public static synchronized ServiceFactory getInstanceWithPath(String sarPath) {
        ServiceFactory.sarPath = sarPath;
        return ServiceFactory.getInstance();
    }

    public static void addJVMProperty(String key, String value) {
        systemProps.put(key, value);
    }

    public static void addJVMProperty(Map<String, String> props) {
        systemProps.putAll(props);
    }

    private static boolean isPandoraInited() {
        Class<?> HSFClazz;
        try {
            HSFClazz = Class.forName("com.taobao.hsf.globalrule.GlobalRule", false, ServiceFactory.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        if (HSFClazz != null) {
            String loader = HSFClazz.getClassLoader().getClass().getName().toLowerCase();
            return loader.contains("pandora");
        }
        return false;
    }

    private static void addJVMProperties() {
        for (Map.Entry<String, String> propEntry : systemProps.entrySet()) {
            System.setProperty(propEntry.getKey(), propEntry.getValue());
        }
    }

    static {
        reporter = new LightApiReporter();
        System.out.println("LightApi is starting.");
    }
}

