/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.lightapi.mock;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MethodUtil {
    public static Method getMethodByName(Class<?> targetClazz, String methodName) throws NoSuchMethodException {
        assert (targetClazz != null && methodName != null);
        ArrayList<Method> methodsMatched = new ArrayList<Method>();
        Method[] allMethods = targetClazz.getMethods();
        if (allMethods != null && allMethods.length > 0) {
            for (Method method : allMethods) {
                if (!method.getName().startsWith(methodName)) continue;
                methodsMatched.add(method);
            }
        }
        if (methodsMatched.size() > 1) {
            throw new UnsupportedOperationException("There are more than one Method startWith methodName[" + methodName + "],please use getMethodByNameAndTypes()");
        }
        if (methodsMatched.size() == 1) {
            return (Method)methodsMatched.get(0);
        }
        throw new NoSuchMethodException("There is no method which name startWith [" + methodName + "].");
    }

    public static Method getMethodByNameAndTypes(Class<?> targetClazz, String methodName, String[] argsType) throws NoSuchMethodException {
        assert (targetClazz != null && methodName != null);
        Method[] allMethods = targetClazz.getMethods();
        if (allMethods != null && allMethods.length > 0) {
            for (Method method : allMethods) {
                Object[] methodArgTypes;
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (parameterTypes.length > 0) {
                    methodArgTypes = new String[parameterTypes.length];
                    int index = 0;
                    for (Class<?> paramType : parameterTypes) {
                        methodArgTypes[index++] = paramType.getName();
                    }
                } else {
                    methodArgTypes = new String[]{};
                }
                if (!methodName.equals(method.getName()) || !Arrays.equals(methodArgTypes, argsType)) continue;
                return method;
            }
        }
        throw new NoSuchMethodException("There is no method which name is [" + methodName + "] and arguments types are [" + argsType + "]");
    }

    public static List<Method> getMethodsStartWithNamePattern(Class<?> targetClazz, String methodNamePattern) throws NoSuchMethodException {
        assert (targetClazz != null && methodNamePattern != null);
        ArrayList<Method> methodsMatched = new ArrayList<Method>();
        Method[] allMethods = targetClazz.getMethods();
        if (allMethods != null && allMethods.length > 0) {
            for (Method method : allMethods) {
                if (!method.getName().startsWith(methodNamePattern)) continue;
                methodsMatched.add(method);
            }
        }
        if (methodsMatched.isEmpty()) {
            new NoSuchMethodException("There is no method which name is startWith[" + methodNamePattern + "]");
        }
        return methodsMatched;
    }
}

