/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.lightapi.report;

import com.taobao.hsf.lightapi.util.LightConstant;
import com.taobao.hsf.lightapi.util.ReportUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public class LightApiReporter {
    private ExecutorService reporter = Executors.newSingleThreadExecutor();
    private AtomicBoolean reportSuccess = new AtomicBoolean(false);

    public void doReport() {
        this.reporter.execute(new ReportTask());
    }

    public boolean isReportSuccess() {
        return this.reportSuccess.get();
    }

    class ReportTask
    implements Runnable {
        ReportTask() {
        }

        @Override
        public void run() {
            String ip = ReportUtil.getIP();
            String version = ReportUtil.getVersion();
            if (version.equals("unknown") || ip == null) {
                return;
            }
            try {
                for (int retryTimes = 0; !this.report(ip, version) && retryTimes < 3; ++retryTimes) {
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean report(String ip, String version) {
            String reportUrl = LightConstant.reportUrl + "?ip=" + ip + "&version=" + version;
            URL url = null;
            InputStream in = null;
            try {
                int i;
                url = new URL(reportUrl);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setConnectTimeout(3000);
                conn.connect();
                conn.setReadTimeout(3000);
                in = conn.getInputStream();
                byte[] resultBytes = new byte[128];
                int count = 0;
                int temp = 0;
                while ((temp = in.read(resultBytes)) != -1) {
                    count += temp;
                }
                StringBuilder sb = new StringBuilder(new String(resultBytes, 0, count));
                char[] resultChars = new char[128];
                sb.getChars(0, sb.length(), resultChars, 0);
                for (i = 0; i < resultChars.length && Character.isISOControl(resultChars[i]); ++i) {
                }
                String trueResult = sb.substring(i, sb.length()).toString().trim();
                if (trueResult.contains("success")) {
                    LightApiReporter.this.reportSuccess.compareAndSet(false, true);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }
}

