/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.lightapi.util;

import com.taobao.hsf.app.spring.util.HSFSpringConsumerBean;
import com.taobao.hsf.app.spring.util.SuperHSFSpringConsumerBeanTop;
import com.taobao.hsf.lightapi.util.ReflectionUtil;
import com.taobao.hsf.standalone.util.Constant;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class Partner {
    public static void waitServiceReady(Object ... serviceList) {
        int timePerSleep = 5;
        int totalTimeout = 15000;
        int sleepTime = 0;
        try {
            for (Object service : serviceList) {
                if (sleepTime > totalTimeout) {
                    System.out.println("Service : configServer pushing address timeout: " + totalTimeout + "ms");
                    break;
                }
                while (!Partner.isServiceAddressReadyFromHSFSpringConsumerBean(service)) {
                    Thread.sleep(timePerSleep);
                    if ((sleepTime += timePerSleep) <= totalTimeout) continue;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isServiceAddressReadyForTop(SuperHSFSpringConsumerBeanTop service) throws Exception {
        ClassLoader loader = SuperHSFSpringConsumerBeanTop.class.getClassLoader();
        if (Constant.main_version == 1) {
            Class<?> serviceHolderClazz = Class.forName("com.taobao.hsf.app.spring.util.HSFServiceHolderComponent", true, loader);
            Object metaService = ReflectionUtil.staticInvoke(serviceHolderClazz, "getMetadataService");
            Object addrService = ReflectionUtil.getField(metaService, "addressService");
            Object metadata = ReflectionUtil.getField(service, "metadata");
            String serviceUniqueName = (String)ReflectionUtil.invoke(metadata, "getUniqueName");
            Object routeResultCache = ReflectionUtil.invoke(addrService, "getRouteResultCache", serviceUniqueName);
            Object addrList = ReflectionUtil.invoke(routeResultCache, "getInterfaceAddresses");
            int size = (Integer)ReflectionUtil.invoke(addrList, "size");
            return size > 0;
        }
        Class<?> serviceHolderClazz = Class.forName("com.taobao.hsf.util.HSFServiceContainer", true, loader);
        Object addressComponent = ReflectionUtil.staticInvoke(serviceHolderClazz, "getInstance", Class.forName("com.taobao.hsf.address.AddressService", true, loader));
        Object addressPool = ReflectionUtil.getField(addressComponent, "addressPool");
        Method m1 = service.getClass().getMethod("getInterfaceName", new Class[0]);
        Method m2 = service.getClass().getMethod("getVersion", new Class[0]);
        String uniqueName = m1.invoke((Object)service, null) + ":" + m2.invoke((Object)service, null);
        Object addressBucket = ReflectionUtil.invoke(addressPool, "getAddressBucket", uniqueName);
        Object addrList = ReflectionUtil.invoke(addressBucket, "getAllAddresses");
        int size = (Integer)ReflectionUtil.invoke(addrList, "size");
        return size > 0;
    }

    private static boolean isServiceAddressReadyFromHSFSpringConsumerBean(Object service) throws Exception {
        ClassLoader loader = HSFSpringConsumerBean.class.getClassLoader();
        if (Constant.main_version == 1) {
            Class<?> serviceHolderClazz = Class.forName("com.taobao.hsf.app.spring.util.HSFServiceHolderComponent", true, loader);
            Object metaService = ReflectionUtil.staticInvoke(serviceHolderClazz, "getMetadataService");
            Object addrService = ReflectionUtil.getField(metaService, "addressService");
            Object routeResultCache = ReflectionUtil.invoke(addrService, "getRouteResultCache", Partner.serviceName(service));
            Object addrList = ReflectionUtil.invoke(routeResultCache, "getInterfaceAddresses");
            int size = (Integer)ReflectionUtil.invoke(addrList, "size");
            return size > 0;
        }
        Class<?> serviceHolderClazz = Class.forName("com.taobao.hsf.util.HSFServiceContainer", true, loader);
        Object addressComponent = ReflectionUtil.staticInvoke(serviceHolderClazz, "getInstance", Class.forName("com.taobao.hsf.address.AddressService", true, loader));
        Object addressPool = ReflectionUtil.getField(addressComponent, "addressPool");
        Object addressBucket = ReflectionUtil.invoke(addressPool, "getAddressBucket", Partner.serviceName(service));
        Object addrList = ReflectionUtil.invoke(addressBucket, "getAllAddresses");
        int size = (Integer)ReflectionUtil.invoke(addrList, "size");
        return size > 0;
    }

    public static List<String> allAddresses(String serviceName) {
        ClassLoader loader = HSFSpringConsumerBean.class.getClassLoader();
        Object addrList = null;
        try {
            Class<?> serviceHolderClazz = Class.forName("com.taobao.hsf.util.HSFServiceContainer", true, loader);
            Object addressComponent = ReflectionUtil.staticInvoke(serviceHolderClazz, "getInstance", Class.forName("com.taobao.hsf.address.AddressService", true, loader));
            Object addressPool = ReflectionUtil.getField(addressComponent, "addressPool");
            Object addressBucket = ReflectionUtil.invoke(addressPool, "getAddressBucket", serviceName);
            addrList = ReflectionUtil.invoke(addressBucket, "getAllAddresses");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return addrList == null ? new ArrayList() : (List)addrList;
    }

    public static void setRunModeToTest() {
        ClassLoader loader = HSFSpringConsumerBean.class.getClassLoader();
        try {
            Class<?> serviceHolderClazz = Class.forName("com.taobao.hsf.util.HSFServiceContainer", true, loader);
            Object configurationService = ReflectionUtil.staticInvoke(serviceHolderClazz, "getInstance", Class.forName("com.taobao.hsf.configuration.service.ConfigurationService", true, loader));
            Field runModeFiled = configurationService.getClass().getDeclaredField("runmode");
            runModeFiled.setAccessible(true);
            runModeFiled.set(configurationService, 0);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean publishSuccess(Object providerBean) {
        try {
            Object apiBean = ReflectionUtil.getField(providerBean, "providerBean");
            Object metadata = ReflectionUtil.getField(apiBean, "metadata");
            AtomicBoolean readyToPublish = (AtomicBoolean)ReflectionUtil.getField(metadata, "readyToPublish");
            return readyToPublish.get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    private static String serviceName(Object serviceProxy) throws Exception {
        InvocationHandler hsfProxy = Proxy.getInvocationHandler(serviceProxy);
        Object metadata = ReflectionUtil.getField(hsfProxy, "serviceConsumerMetadata");
        String uniqueName = (String)ReflectionUtil.invoke(metadata, "getUniqueName");
        return uniqueName;
    }
}

