/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.standalone;

import com.taobao.hsf.standalone.HSFStarter;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class HSFMiniContainer {
    private static Map<String, Class<?>> exportedClassMap;
    private static AtomicBoolean isPandoraStarted;

    public static void start(String sarPath) throws Exception {
        if (isPandoraStarted.compareAndSet(false, true)) {
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            HSFStarter.start(sarPath);
            Field exportedClassMapField = HSFStarter.class.getDeclaredField("exportedClassMap");
            exportedClassMapField.setAccessible(true);
            exportedClassMap = (Map)exportedClassMapField.get(null);
            Thread.currentThread().setContextClassLoader(oldLoader);
            URLClassLoader hsfClassLoader = new URLClassLoader(new URL[0], null){

                @Override
                protected Class<?> findClass(String name) throws ClassNotFoundException {
                    Class clazz = (Class)exportedClassMap.get(name);
                    if (clazz != null) {
                        return clazz;
                    }
                    throw new ClassNotFoundException(name);
                }
            };
            HSFMiniContainer.changeCurrentCloasLoaderParent(hsfClassLoader);
        }
    }

    private static void changeCurrentCloasLoaderParent(ClassLoader parent) throws Exception {
        Class<URLClassLoader> sysClass = URLClassLoader.class;
        Field parentField = sysClass.getSuperclass().getSuperclass().getDeclaredField("parent");
        parentField.setAccessible(true);
        parentField.set(HSFMiniContainer.getExtClassLoader(), parent);
    }

    private static ClassLoader getExtClassLoader() {
        ClassLoader currentClassLoader = HSFMiniContainer.class.getClassLoader();
        while (currentClassLoader.getParent() != null) {
            currentClassLoader = currentClassLoader.getParent();
        }
        return currentClassLoader;
    }

    public static Set<String> getExportedClassNameList() {
        return exportedClassMap.keySet();
    }

    static {
        isPandoraStarted = new AtomicBoolean(false);
    }
}

