/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.standalone.sar;

import com.taobao.hsf.standalone.util.Constant;
import com.taobao.middleware.pandora.toolkit.SarExtractor;
import com.taobao.middleware.pandora.toolkit.SarFetcher;
import com.taobao.middleware.pandora.toolkit.commons.HttpUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class HSFSarUtil {
    private static final String libPath = "lib";
    public static String[] jarFolders = new String[]{"lib"};

    public static URL[] listSarJar(String sarPath) {
        if (sarPath == null) {
            throw new IllegalArgumentException("sarPath[" + sarPath + "] can't be null");
        }
        File sarDir = new File(sarPath);
        if (!sarDir.exists() | !sarDir.isDirectory()) {
            throw new IllegalArgumentException("sarPath[" + sarPath + "] must be a folder");
        }
        URL[] allUrls = null;
        for (String jarFolder : jarFolders) {
            URL[] urls = HSFSarUtil.addJar(sarPath, jarFolder);
            if (urls == null) continue;
            if (allUrls == null) {
                allUrls = urls;
                continue;
            }
            URL[] tempAllUrls = allUrls;
            allUrls = new URL[tempAllUrls.length + urls.length];
            System.arraycopy(tempAllUrls, 0, allUrls, 0, tempAllUrls.length);
            System.arraycopy(urls, 0, allUrls, tempAllUrls.length, urls.length);
        }
        return allUrls;
    }

    private static URL[] addJar(String hsfJarRootPath, String jarFolder) {
        File folder = new File(hsfJarRootPath + File.separator + jarFolder);
        if (!folder.exists() | !folder.isDirectory()) {
            return null;
        }
        File[] jarList = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") | name.endsWith(".jar.plugin");
            }
        });
        URL[] urls = new URL[jarList.length];
        for (int i = 0; i < jarList.length; ++i) {
            try {
                URL jarUrl;
                urls[i] = jarUrl = new URL("file:" + jarList[i].getAbsoluteFile());
                continue;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return urls;
    }

    public static String prepareHSFSar(String destSarPath, String sarVersion) throws IOException {
        if (sarVersion == null) {
            throw new IllegalArgumentException("parameter 'sarVersion' can not be null.");
        }
        if (destSarPath == null || destSarPath.trim().length() == 0) {
            throw new IllegalArgumentException("parameter 'destSarPath' can not be null or empty.");
        }
        File basePath = new File(destSarPath);
        if (!(basePath.exists() && basePath.isDirectory() || basePath.mkdirs())) {
            throw new RuntimeException("Can not create base path of taobao-hsf.sar: " + destSarPath);
        }
        File lockFile = new File(basePath, "prepare-sar.lock");
        lockFile.createNewFile();
        AbstractInterruptibleChannel channel = null;
        FileLock lock = null;
        RandomAccessFile raf = null;
        try {
            File sarFile;
            File decompressedSar;
            raf = new RandomAccessFile(lockFile, "rw");
            channel = raf.getChannel();
            lock = ((FileChannel)channel).lock();
            File localSarFile = new File(basePath, "taobao-hsf.sar");
            if (localSarFile.exists() && localSarFile.isDirectory()) {
                String string = localSarFile.getCanonicalPath();
                return string;
            }
            File localTgzFile = new File(basePath, "taobao-hsf.tgz");
            if (localTgzFile.exists() && localTgzFile.isFile() && (decompressedSar = SarExtractor.decompressSar(localTgzFile)) != null) {
                String string = decompressedSar.getCanonicalPath();
                return string;
            }
            String originSarVersion = sarVersion;
            if ((sarVersion = HSFSarUtil.decideSarVersion(sarVersion)) == null) {
                throw new RuntimeException("Can not decide a valid sar version to use.");
            }
            File tgzSarFile = HSFSarUtil.downloadTgzSar(sarVersion, basePath);
            if (tgzSarFile == null) {
                String nonDotSarVersion = HSFSarUtil.convertSarVersion(sarVersion);
                if (!nonDotSarVersion.equals(sarVersion)) {
                    System.out.println("[HSF-LightApi] >> Can not download taobao-hsf.tgz by sarVersion[" + sarVersion + "]. Try to download taobao-hsf.tgz by sarVersion[" + nonDotSarVersion + "]");
                    tgzSarFile = HSFSarUtil.downloadTgzSar(nonDotSarVersion, basePath);
                }
                if (tgzSarFile == null) {
                    throw new RuntimeException("Download taobao-hsf.tgz failed. sarVersion may not be right: " + originSarVersion);
                }
            }
            if ((sarFile = SarExtractor.decompressSar(tgzSarFile)) != null && sarFile.exists() && sarFile.isDirectory()) {
                String string = sarFile.getCanonicalPath();
                return string;
            }
            throw new RuntimeException("Decompress taobao-hsf.tgz failed.");
        }
        finally {
            if (lock != null) {
                lock.release();
            }
            if (channel != null) {
                channel.close();
            }
            if (raf != null) {
                raf.close();
            }
        }
    }

    private static String decideSarVersion(String sarVersion) {
        String decidedVersion = sarVersion;
        if ((decidedVersion == null || decidedVersion.trim().length() == 0) && (decidedVersion = Constant.version.get()).equals("")) {
            decidedVersion = SarFetcher.getDefaultSarVersion();
        }
        return decidedVersion;
    }

    private static String convertSarVersion(String sarVersion) {
        if (sarVersion != null && Character.isDigit(sarVersion.charAt(0))) {
            return sarVersion.replace(".", "_");
        }
        return sarVersion;
    }

    private static File downloadTgzSar(String sarVersion, File basePath) {
        File tgzSarFile;
        File exsitedTgzFile = new File(basePath, "taobao-hsf.tgz");
        if (exsitedTgzFile.exists() && exsitedTgzFile.isFile()) {
            exsitedTgzFile.delete();
        }
        if ((tgzSarFile = HSFSarUtil.downloadPreferSar(basePath)) != null) {
            System.out.println("[HSF-LightApi] >> Downloaded taobao-hsf.tgz from " + Constant.perferDownloadUrl.get());
            return tgzSarFile;
        }
        tgzSarFile = SarFetcher.downloadSar(sarVersion, basePath.getPath());
        if (tgzSarFile != null) {
            System.out.println("[HSF-LightApi] >> Downloaded taobao-hsf.tgz from pandora-web");
            return tgzSarFile;
        }
        tgzSarFile = HSFSarUtil.downloadOldSar(sarVersion, basePath);
        if (tgzSarFile != null) {
            System.out.println("[HSF-LightApi] >> Downloaded taobao-hsf.tgz from http://hsf.taobao.net/hsfversion/hsf");
            return tgzSarFile;
        }
        return null;
    }

    private static File downloadPreferSar(File baseFile) {
        String preferDownloadUrl = Constant.perferDownloadUrl.get();
        if ("".equals(preferDownloadUrl)) {
            return null;
        }
        File tgzFile = new File(baseFile, "taobao-hsf.tgz");
        String downloadUrl = preferDownloadUrl + "/taobao-hsf.tgz";
        if (HttpUtils.downloadFile(downloadUrl, tgzFile.getPath()) && tgzFile.exists() && tgzFile.isFile() && tgzFile.length() > (long)Constant.MIN_TGZ_SAR_SIZE) {
            return tgzFile;
        }
        return null;
    }

    private static File downloadOldSar(String sarVersion, File baseFile) {
        File tgzFile = new File(baseFile, "taobao-hsf.tgz");
        String downloadUrl = "http://hsf.taobao.net/hsfversion/hsf" + sarVersion + "/taobao-hsf.tgz";
        if (HttpUtils.downloadFile(downloadUrl, tgzFile.getPath()) && tgzFile.exists() && tgzFile.isFile() && tgzFile.length() > (long)Constant.MIN_TGZ_SAR_SIZE) {
            return tgzFile;
        }
        return null;
    }
}

