/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.middleware.pandora.toolkit.commons;

import com.taobao.middleware.pandora.toolkit.commons.compress.archivers.tar.TarArchiveEntry;
import com.taobao.middleware.pandora.toolkit.commons.compress.archivers.tar.TarArchiveInputStream;
import com.taobao.middleware.pandora.toolkit.commons.compress.compressors.gzip.GzipCompressorInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtils {
    public static void close(InputStream inStream) {
        if (inStream != null) {
            try {
                inStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void close(BufferedReader br) {
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void close(OutputStream outStream) {
        if (outStream != null) {
            try {
                outStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void deleteDir(File dir) {
        if (dir != null && dir.exists()) {
            if (dir.isDirectory()) {
                if (dir.listFiles().length == 0) {
                    dir.delete();
                } else {
                    File[] files = dir.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        if (files[i].isDirectory()) {
                            FileUtils.deleteDir(files[i]);
                        }
                        files[i].delete();
                    }
                }
            }
            dir.delete();
        }
    }

    public static String getAbsolutePath(File file) {
        if (file == null) {
            return null;
        }
        String path = null;
        try {
            path = file.getCanonicalPath();
        }
        catch (Exception e) {
            path = file.getAbsolutePath();
        }
        return path;
    }

    public static void decompressTgzFile(String tgzFilePath, boolean deleteAfterDecompress) {
        File tgzFile = new File(tgzFilePath);
        if (tgzFile != null && tgzFile.exists() && tgzFile.isFile()) {
            File tarFile = FileUtils.decompressGz2Tar(tgzFile);
            FileUtils.decompressTarFile(tarFile);
            if (deleteAfterDecompress) {
                tgzFile.delete();
            }
        } else {
            throw new IllegalArgumentException("File[" + tgzFilePath + "] does not exist, or is not a file.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File decompressGz2Tar(File gzFile) {
        if (gzFile == null) {
            return null;
        }
        if (gzFile.exists() && gzFile.isFile()) {
            File file;
            FileOutputStream out = null;
            FileInputStream in = null;
            GzipCompressorInputStream gzIn = null;
            try {
                File outFile = new File(gzFile.getAbsoluteFile().getParent() + File.separator + gzFile.getName() + ".tar");
                in = new FileInputStream(gzFile);
                out = new FileOutputStream(outFile);
                gzIn = new GzipCompressorInputStream(in);
                byte[] buffer = new byte[2048];
                int n = 0;
                while (-1 != (n = gzIn.read(buffer))) {
                    out.write(buffer, 0, n);
                }
                file = outFile;
                FileUtils.close(out);
            }
            catch (Exception e) {
                e.printStackTrace();
                File file2 = null;
                return file2;
            }
            finally {
                FileUtils.close(out);
                FileUtils.close(in);
                FileUtils.close(gzIn);
            }
            FileUtils.close(in);
            FileUtils.close(gzIn);
            return file;
        }
        throw new IllegalArgumentException("File[" + gzFile.getAbsolutePath() + "] does not exist, or is not a file.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void decompressTarFile(File tarFile) {
        block14: {
            block15: {
                if (tarFile == null) {
                    return;
                }
                if (!tarFile.exists() || !tarFile.isFile()) break block15;
                String basePath = tarFile.getParent() + File.separator;
                TarArchiveInputStream is = null;
                FileInputStream in = null;
                try {
                    in = new FileInputStream(tarFile);
                    is = new TarArchiveInputStream(in);
                    TarArchiveEntry entry = null;
                    while ((entry = is.getNextTarEntry()) != null) {
                        if (entry.isDirectory()) continue;
                        FileOutputStream os = null;
                        try {
                            File f = new File(basePath + entry.getName());
                            if (!f.getParentFile().exists()) {
                                f.getParentFile().mkdirs();
                            }
                            if (!f.exists()) {
                                f.createNewFile();
                            }
                            os = new FileOutputStream(f);
                            byte[] bs = new byte[2048];
                            int len = -1;
                            while ((len = is.read(bs)) != -1) {
                                os.write(bs, 0, len);
                            }
                            os.flush();
                            FileUtils.close(os);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            FileUtils.close(os);
                        }
                    }
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        FileUtils.close(in);
                        FileUtils.close(is);
                        tarFile.delete();
                        throw throwable;
                    }
                    FileUtils.close(in);
                    FileUtils.close(is);
                    tarFile.delete();
                    break block14;
                }
                FileUtils.close(in);
                FileUtils.close(is);
                tarFile.delete();
                break block14;
            }
            throw new IllegalArgumentException("File[" + tarFile.getAbsolutePath() + "] does not exist, or is not a file.");
        }
    }
}

