/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.metrics.common;

import com.alibaba.metrics.BucketCounter;
import com.alibaba.metrics.Compass;
import com.alibaba.metrics.Counter;
import com.alibaba.metrics.Gauge;
import com.alibaba.metrics.Histogram;
import com.alibaba.metrics.Meter;
import com.alibaba.metrics.MetricFilter;
import com.alibaba.metrics.MetricName;
import com.alibaba.metrics.Snapshot;
import com.alibaba.metrics.Timer;
import com.alibaba.metrics.common.MetricObject;
import com.alibaba.metrics.common.MetricsCollector;
import java.util.Map;

public class NormalMetricsCollector
extends MetricsCollector {
    NormalMetricsCollector(Map<String, String> globalTags, double rateFactor, double durationFactor, MetricFilter filter) {
        super(globalTags, rateFactor, durationFactor, filter);
    }

    public void collect(MetricName name, Timer timer, long timestamp) {
        Snapshot snapshot = timer.getSnapshot();
        this.addMetric(name, "count", (Object)timer.getCount(), timestamp, MetricObject.MetricType.COUNTER).addMetric(name, "m1", this.convertRate(timer.getOneMinuteRate()), timestamp).addMetric(name, "m5", this.convertRate(timer.getFiveMinuteRate()), timestamp).addMetric(name, "m15", this.convertRate(timer.getFifteenMinuteRate()), timestamp).addMetric(name, "max", this.convertDuration(snapshot.getMax()), timestamp).addMetric(name, "min", this.convertDuration(snapshot.getMin()), timestamp).addMetric(name, "mean", this.convertDuration(snapshot.getMean()), timestamp).addMetric(name, "rt", this.convertDuration(snapshot.getMean()), timestamp).addMetric(name, "stddev", this.convertDuration(snapshot.getStdDev()), timestamp).addMetric(name, "median", this.convertDuration(snapshot.getMedian()), timestamp).addMetric(name, "p75", this.convertDuration(snapshot.get75thPercentile()), timestamp).addMetric(name, "p95", this.convertDuration(snapshot.get95thPercentile()), timestamp).addMetric(name, "p99", this.convertDuration(snapshot.get99thPercentile()), timestamp);
        this.addInstantCountMetric(timer.getInstantCount(), name, timer.getInstantCountInterval(), timestamp);
    }

    public void collect(MetricName name, Histogram histogram, long timestamp) {
        Snapshot snapshot = histogram.getSnapshot();
        this.addMetric(name, "count", (Object)histogram.getCount(), timestamp, MetricObject.MetricType.COUNTER).addMetric(name, "max", snapshot.getMax(), timestamp).addMetric(name, "min", snapshot.getMin(), timestamp).addMetric(name, "mean", snapshot.getMean(), timestamp).addMetric(name, "stddev", snapshot.getStdDev(), timestamp).addMetric(name, "median", snapshot.getMedian(), timestamp).addMetric(name, "p75", snapshot.get75thPercentile(), timestamp).addMetric(name, "p95", snapshot.get95thPercentile(), timestamp).addMetric(name, "p99", snapshot.get99thPercentile(), timestamp);
    }

    public void collect(MetricName name, Compass compass, long timestamp) {
        Snapshot snapshot = compass.getSnapshot();
        this.addMetric(name, "count", (Object)compass.getCount(), timestamp, MetricObject.MetricType.COUNTER).addMetric(name, "m1", this.convertRate(compass.getOneMinuteRate()), timestamp).addMetric(name, "m5", this.convertRate(compass.getFiveMinuteRate()), timestamp).addMetric(name, "m15", this.convertRate(compass.getFifteenMinuteRate()), timestamp).addMetric(name, "max", this.convertDuration(snapshot.getMax()), timestamp).addMetric(name, "min", this.convertDuration(snapshot.getMin()), timestamp).addMetric(name, "mean", this.convertDuration(snapshot.getMean()), timestamp).addMetric(name, "rt", this.convertDuration(snapshot.getMean()), timestamp).addMetric(name, "stddev", this.convertDuration(snapshot.getStdDev()), timestamp).addMetric(name, "median", this.convertDuration(snapshot.getMedian()), timestamp).addMetric(name, "p75", this.convertDuration(snapshot.get75thPercentile()), timestamp).addMetric(name, "p95", this.convertDuration(snapshot.get95thPercentile()), timestamp).addMetric(name, "p99", this.convertDuration(snapshot.get99thPercentile()), timestamp);
        this.addInstantCountMetric(compass.getInstantCount(), name, compass.getInstantCountInterval(), timestamp);
        this.addInstantSuccessCount(name, compass, timestamp);
        this.addCompassErrorCode(name, compass, timestamp);
        this.addAddonMetric(name, compass, timestamp);
    }

    public void collect(MetricName name, Meter meter, long timestamp) {
        this.addMetric(name, "count", (Object)meter.getCount(), timestamp, MetricObject.MetricType.COUNTER).addMetric(name, "m1", this.convertRate(meter.getOneMinuteRate()), timestamp).addMetric(name, "m5", this.convertRate(meter.getFiveMinuteRate()), timestamp).addMetric(name, "m15", this.convertRate(meter.getFifteenMinuteRate()), timestamp);
        this.addInstantCountMetric(meter.getInstantCount(), name, meter.getInstantCountInterval(), timestamp);
    }

    public void collect(MetricName name, Counter counter, long timestamp) {
        MetricName normalizedName = name.getKey().endsWith("count") ? name : name.resolve("count");
        this.addMetric(normalizedName, counter.getCount(), timestamp, MetricObject.MetricType.COUNTER, this.metricsCollectPeriodConfig.period(name.getMetricLevel()));
        if (counter instanceof BucketCounter) {
            int countInterval = ((BucketCounter)counter).getBucketInterval();
            this.addInstantCountMetric(((BucketCounter)counter).getBucketCounts(), name, countInterval, timestamp);
        }
    }

    public void collect(MetricName name, Gauge gauge, long timestamp) {
        this.addMetric(name, gauge.getValue(), timestamp, MetricObject.MetricType.GAUGE, this.metricsCollectPeriodConfig.period(name.getMetricLevel()));
    }
}

