/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.datasource.impl.mysql;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.datasource.mapper.AbstractMapper;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigInfoMapper;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ConfigInfoMapperByMySql
extends AbstractMapper
implements ConfigInfoMapper {
    private static final String DATA_ID = "dataId";
    private static final String GROUP = "group";
    private static final String APP_NAME = "appName";
    private static final String CONTENT = "content";
    private static final String TENANT = "tenant";

    @Override
    public String findConfigMaxId() {
        return "SELECT MAX(id) FROM config_info";
    }

    @Override
    public String findAllDataIdAndGroup() {
        return "SELECT DISTINCT data_id, group_id FROM config_info";
    }

    @Override
    public String findConfigInfoByAppCountRows() {
        return "SELECT count(*) FROM config_info WHERE tenant_id LIKE ? AND app_name= ?";
    }

    @Override
    public String findConfigInfoByAppFetchRows(int startRow, int pageSize) {
        return "SELECT id,data_id,group_id,tenant_id,app_name,content FROM config_info WHERE tenant_id LIKE ? AND app_name= ? LIMIT " + startRow + "," + pageSize;
    }

    @Override
    public String configInfoLikeTenantCount() {
        return "SELECT count(*) FROM config_info WHERE tenant_id LIKE ?";
    }

    @Override
    public String getTenantIdList(int startRow, int pageSize) {
        return "SELECT tenant_id FROM config_info WHERE tenant_id != '' GROUP BY tenant_id LIMIT " + startRow + "," + pageSize;
    }

    @Override
    public String getGroupIdList(int startRow, int pageSize) {
        return "SELECT group_id FROM config_info WHERE tenant_id ='' GROUP BY group_id LIMIT " + startRow + "," + pageSize;
    }

    @Override
    public String findAllConfigKey(int startRow, int pageSize) {
        return " SELECT data_id,group_id,app_name  FROM (  SELECT id FROM config_info WHERE tenant_id LIKE ? ORDER BY id LIMIT " + startRow + "," + pageSize + " ) g, config_info t WHERE g.id = t.id  ";
    }

    @Override
    public String findAllConfigInfoBaseFetchRows(int startRow, int pageSize) {
        return "SELECT t.id,data_id,group_id,content,md5 FROM ( SELECT id FROM config_info ORDER BY id LIMIT ?,?  )  g, config_info t  WHERE g.id = t.id ";
    }

    @Override
    public String findAllConfigInfoFragment(int startRow, int pageSize) {
        return "SELECT id,data_id,group_id,tenant_id,app_name,content,md5,gmt_modified,type,encrypted_data_key FROM config_info WHERE id > ? ORDER BY id ASC LIMIT " + startRow + "," + pageSize;
    }

    @Override
    public String findChangeConfig() {
        return "SELECT data_id, group_id, tenant_id, app_name, content, gmt_modified,encrypted_data_key FROM config_info WHERE gmt_modified >= ? AND gmt_modified <= ?";
    }

    @Override
    public String findChangeConfigCountRows(Map<String, String> params, Timestamp startTime, Timestamp endTime) {
        String tenant = params.get(TENANT);
        String dataId = params.get(DATA_ID);
        String group = params.get(GROUP);
        String appName = params.get(APP_NAME);
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sqlCountRows = "SELECT count(*) FROM config_info WHERE ";
        String where = " 1=1 ";
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where = where + " AND data_id LIKE ? ";
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where = where + " AND group_id LIKE ? ";
        }
        if (!StringUtils.isBlank((CharSequence)tenantTmp)) {
            where = where + " AND tenant_id = ? ";
        }
        if (!StringUtils.isBlank((CharSequence)appName)) {
            where = where + " AND app_name = ? ";
        }
        if (startTime != null) {
            where = where + " AND gmt_modified >=? ";
        }
        if (endTime != null) {
            where = where + " AND gmt_modified <=? ";
        }
        return "SELECT count(*) FROM config_info WHERE " + where;
    }

    @Override
    public String findChangeConfigFetchRows(Map<String, String> params, Timestamp startTime, Timestamp endTime, int startRow, int pageSize, long lastMaxId) {
        String tenant = params.get(TENANT);
        String dataId = params.get(DATA_ID);
        String group = params.get(GROUP);
        String appName = params.get(APP_NAME);
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sqlFetchRows = "SELECT id,data_id,group_id,tenant_id,app_name,content,type,md5,gmt_modified FROM config_info WHERE ";
        String where = " 1=1 ";
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where = where + " AND data_id LIKE ? ";
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where = where + " AND group_id LIKE ? ";
        }
        if (!StringUtils.isBlank((CharSequence)tenantTmp)) {
            where = where + " AND tenant_id = ? ";
        }
        if (!StringUtils.isBlank((CharSequence)appName)) {
            where = where + " AND app_name = ? ";
        }
        if (startTime != null) {
            where = where + " AND gmt_modified >=? ";
        }
        if (endTime != null) {
            where = where + " AND gmt_modified <=? ";
        }
        return "SELECT id,data_id,group_id,tenant_id,app_name,content,type,md5,gmt_modified FROM config_info WHERE " + where + " AND id > " + lastMaxId + " ORDER BY id ASC LIMIT " + 0 + "," + pageSize;
    }

    @Override
    public String listGroupKeyMd5ByPageFetchRows(int startRow, int pageSize) {
        return "SELECT t.id,data_id,group_id,tenant_id,app_name,md5,type,gmt_modified,encrypted_data_key FROM ( SELECT id FROM config_info ORDER BY id LIMIT " + startRow + "," + pageSize + " ) g, config_info t WHERE g.id = t.id";
    }

    @Override
    public String findAllConfigInfo4Export(List<Long> ids, Map<String, String> params) {
        String tenant = params.get(TENANT);
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sql = "SELECT id,data_id,group_id,tenant_id,app_name,content,type,md5,gmt_create,gmt_modified,src_user,src_ip,c_desc,c_use,effect,c_schema,encrypted_data_key FROM config_info";
        StringBuilder where = new StringBuilder(" WHERE ");
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (!CollectionUtils.isEmpty(ids)) {
            where.append(" id IN (");
            for (int i = 0; i < ids.size(); ++i) {
                if (i != 0) {
                    where.append(", ");
                }
                where.append('?');
                paramList.add(ids.get(i));
            }
            where.append(") ");
        } else {
            where.append(" tenant_id= ? ");
            paramList.add(tenantTmp);
            if (!StringUtils.isBlank((CharSequence)params.get(DATA_ID))) {
                where.append(" AND data_id LIKE ? ");
            }
            if (StringUtils.isNotBlank((String)params.get(GROUP))) {
                where.append(" AND group_id= ? ");
            }
            if (StringUtils.isNotBlank((String)params.get(APP_NAME))) {
                where.append(" AND app_name= ? ");
            }
        }
        return sql + where;
    }

    @Override
    public String findConfigInfoBaseLikeCountRows(Map<String, String> params) {
        String sqlCountRows = "SELECT count(*) FROM config_info WHERE ";
        String where = " 1=1 AND tenant_id='' ";
        if (!StringUtils.isBlank((CharSequence)params.get(DATA_ID))) {
            where = where + " AND data_id LIKE ? ";
        }
        if (!StringUtils.isBlank((CharSequence)params.get(GROUP))) {
            where = where + " AND group_id LIKE ";
        }
        if (!StringUtils.isBlank((CharSequence)params.get(CONTENT))) {
            where = where + " AND content LIKE ? ";
        }
        return "SELECT count(*) FROM config_info WHERE " + where;
    }

    @Override
    public String findConfigInfoBaseLikeFetchRows(Map<String, String> params, int startRow, int pageSize) {
        String sqlFetchRows = "SELECT id,data_id,group_id,tenant_id,content FROM config_info WHERE ";
        String where = " 1=1 AND tenant_id='' ";
        if (!StringUtils.isBlank((CharSequence)params.get(DATA_ID))) {
            where = where + " AND data_id LIKE ? ";
        }
        if (!StringUtils.isBlank((CharSequence)params.get(GROUP))) {
            where = where + " AND group_id LIKE ";
        }
        if (!StringUtils.isBlank((CharSequence)params.get(CONTENT))) {
            where = where + " AND content LIKE ? ";
        }
        return "SELECT id,data_id,group_id,tenant_id,content FROM config_info WHERE " + where + " LIMIT " + startRow + "," + pageSize;
    }

    @Override
    public String findConfigInfo4PageCountRows(Map<String, String> params) {
        String appName = params.get(APP_NAME);
        String dataId = params.get(DATA_ID);
        String group = params.get(GROUP);
        String sqlCount = "SELECT count(*) FROM config_info";
        StringBuilder where = new StringBuilder(" WHERE ");
        where.append(" tenant_id=? ");
        if (StringUtils.isNotBlank((String)dataId)) {
            where.append(" AND data_id=? ");
        }
        if (StringUtils.isNotBlank((String)group)) {
            where.append(" AND group_id=? ");
        }
        if (StringUtils.isNotBlank((String)appName)) {
            where.append(" AND app_name=? ");
        }
        return "SELECT count(*) FROM config_info" + where;
    }

    @Override
    public String findConfigInfo4PageFetchRows(Map<String, String> params, int startRow, int pageSize) {
        String appName = params.get(APP_NAME);
        String dataId = params.get(DATA_ID);
        String group = params.get(GROUP);
        String sql = "SELECT id,data_id,group_id,tenant_id,app_name,content,type,encrypted_data_key FROM config_info";
        StringBuilder where = new StringBuilder(" WHERE ");
        where.append(" tenant_id=? ");
        if (StringUtils.isNotBlank((String)dataId)) {
            where.append(" AND data_id=? ");
        }
        if (StringUtils.isNotBlank((String)group)) {
            where.append(" AND group_id=? ");
        }
        if (StringUtils.isNotBlank((String)appName)) {
            where.append(" AND app_name=? ");
        }
        return "SELECT id,data_id,group_id,tenant_id,app_name,content,type,encrypted_data_key FROM config_info" + where + " LIMIT " + startRow + "," + pageSize;
    }

    @Override
    public String findConfigInfoBaseByGroupFetchRows(int startRow, int pageSize) {
        return "SELECT id,data_id,group_id,content FROM config_info WHERE group_id=? AND tenant_id=? LIMIT " + startRow + "," + pageSize;
    }

    @Override
    public String findConfigInfoLike4PageCountRows(Map<String, String> params) {
        String dataId = params.get(DATA_ID);
        String group = params.get(GROUP);
        String appName = params.get(APP_NAME);
        String content = params.get(CONTENT);
        String sqlCountRows = "SELECT count(*) FROM config_info";
        StringBuilder where = new StringBuilder(" WHERE ");
        where.append(" tenant_id LIKE ? ");
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where.append(" AND data_id LIKE ? ");
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where.append(" AND group_id LIKE ? ");
        }
        if (!StringUtils.isBlank((CharSequence)appName)) {
            where.append(" AND app_name = ? ");
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            where.append(" AND content LIKE ? ");
        }
        return "SELECT count(*) FROM config_info" + where;
    }

    @Override
    public String findConfigInfoLike4PageFetchRows(Map<String, String> params, int startRow, int pageSize) {
        String dataId = params.get(DATA_ID);
        String group = params.get(GROUP);
        String appName = params.get(APP_NAME);
        String content = params.get(CONTENT);
        String sqlFetchRows = "SELECT id,data_id,group_id,tenant_id,app_name,content,encrypted_data_key FROM config_info";
        StringBuilder where = new StringBuilder(" WHERE ");
        where.append(" tenant_id LIKE ? ");
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where.append(" AND data_id LIKE ? ");
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where.append(" AND group_id LIKE ? ");
        }
        if (!StringUtils.isBlank((CharSequence)appName)) {
            where.append(" AND app_name = ? ");
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            where.append(" AND content LIKE ? ");
        }
        return "SELECT id,data_id,group_id,tenant_id,app_name,content,encrypted_data_key FROM config_info" + where + " LIMIT " + startRow + "," + pageSize;
    }

    @Override
    public String findAllConfigInfoFetchRows(int startRow, int pageSize) {
        return "SELECT t.id,data_id,group_id,tenant_id,app_name,content,md5  FROM (  SELECT id FROM config_info WHERE tenant_id LIKE ? ORDER BY id LIMIT ?,? ) g, config_info t  WHERE g.id = t.id ";
    }

    @Override
    public String findConfigInfosByIds(int idSize) {
        StringBuilder sql = new StringBuilder("SELECT ID,data_id,group_id,tenant_id,app_name,content,md5 FROM config_info WHERE ");
        sql.append("id IN (");
        for (int i = 0; i < idSize; ++i) {
            if (i != 0) {
                sql.append(", ");
            }
            sql.append('?');
        }
        sql.append(") ");
        return sql.toString();
    }

    @Override
    public String removeConfigInfoByIdsAtomic(int size) {
        StringBuilder sql = new StringBuilder("DELETE FROM config_info WHERE ");
        sql.append("id IN (");
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sql.append(", ");
            }
            sql.append('?');
        }
        sql.append(") ");
        return sql.toString();
    }

    @Override
    public String getTableName() {
        return "config_info";
    }

    @Override
    public String getDataSource() {
        return "mysql";
    }

    @Override
    public String updateConfigInfoAtomicCas() {
        return "UPDATE config_info SET content=?, md5 = ?, src_ip=?,src_user=?,gmt_modified=?, app_name=?,c_desc=?,c_use=?,effect=?,type=?,c_schema=? WHERE data_id=? AND group_id=? AND tenant_id=? AND (md5=? OR md5 IS NULL OR md5='')";
    }
}

