/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.context.annotation.config;

import com.alibaba.nacos.api.annotation.NacosProperties;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.annotation.NacosConfigListener;
import com.alibaba.nacos.api.config.convert.NacosConfigConverter;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.spring.beans.factory.annotation.ConfigServiceBeanBuilder;
import com.alibaba.nacos.spring.context.event.AnnotationListenerMethodProcessor;
import com.alibaba.nacos.spring.context.event.config.NacosConfigMetadataEvent;
import com.alibaba.nacos.spring.context.event.config.TimeoutNacosConfigListener;
import com.alibaba.nacos.spring.convert.converter.config.DefaultNacosConfigConverter;
import com.alibaba.nacos.spring.factory.NacosServiceFactory;
import com.alibaba.nacos.spring.util.GlobalNacosPropertiesSource;
import com.alibaba.nacos.spring.util.NacosBeanUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.env.Environment;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class NacosConfigListenerMethodProcessor
extends AnnotationListenerMethodProcessor<NacosConfigListener>
implements ApplicationContextAware,
ApplicationEventPublisherAware,
EnvironmentAware {
    public static final String BEAN_NAME = "nacosConfigListenerMethodProcessor";
    public static final String NACOS_CONFIG_CONVERSION_SERVICE_BEAN_NAME = "nacosConfigConversionService";
    private Properties globalNacosProperties;
    private NacosServiceFactory nacosServiceFactory;
    private ConversionService conversionService;
    private ConfigServiceBeanBuilder configServiceBeanBuilder;
    private Environment environment;
    private ApplicationEventPublisher applicationEventPublisher;

    @Override
    protected void processListenerMethod(String beanName, final Object bean, Class<?> beanClass, final NacosConfigListener listener, final Method method, ApplicationContext applicationContext) {
        String groupId;
        String dataId;
        block2: {
            dataId = listener.dataId();
            groupId = listener.groupId();
            long timeout = listener.timeout();
            Assert.isTrue((boolean)StringUtils.hasText((String)dataId), (String)"dataId must have content");
            Assert.isTrue((boolean)StringUtils.hasText((String)groupId), (String)"groupId must have content");
            Assert.isTrue((timeout > 0L ? 1 : 0) != 0, (String)"timeout must be greater than zero");
            ConfigService configService = (ConfigService)this.configServiceBeanBuilder.build(listener.properties());
            try {
                configService.addListener(dataId, groupId, (Listener)new TimeoutNacosConfigListener(dataId, groupId, timeout){

                    @Override
                    protected void onReceived(String config) {
                        Class<?> targetType = method.getParameterTypes()[0];
                        NacosConfigConverter configConverter = NacosConfigListenerMethodProcessor.this.determineNacosConfigConverter(targetType, listener);
                        Object parameterValue = configConverter.convert(config);
                        ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{parameterValue});
                    }
                });
            }
            catch (NacosException e) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error((Object)("ConfigService can't add Listener for dataId : " + dataId + " , groupId : " + groupId), (Throwable)e);
            }
        }
        this.publishMetadataEvent(beanName, bean, beanClass, dataId, groupId, listener, method);
    }

    private void publishMetadataEvent(String beanName, Object bean, Class<?> beanClass, String dataId, String groupId, NacosConfigListener listener, Method method) {
        NacosProperties nacosProperties = listener.properties();
        Properties resolvedNacosProperties = this.configServiceBeanBuilder.resolveProperties(nacosProperties);
        NacosConfigMetadataEvent metadataEvent = new NacosConfigMetadataEvent(listener);
        metadataEvent.setDataId(dataId);
        metadataEvent.setGroupId(groupId);
        Map nacosPropertiesAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)nacosProperties);
        metadataEvent.setNacosPropertiesAttributes(nacosPropertiesAttributes);
        metadataEvent.setNacosProperties(resolvedNacosProperties);
        metadataEvent.setBeanName(beanName);
        metadataEvent.setBean(bean);
        metadataEvent.setBeanType(beanClass);
        metadataEvent.setAnnotatedElement(method);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)metadataEvent);
    }

    private ConfigService resolveConfigService(Properties nacosProperties, ApplicationContext applicationContext) throws BeansException {
        ConfigService configService = null;
        try {
            configService = this.nacosServiceFactory.createConfigService(nacosProperties);
        }
        catch (NacosException e) {
            throw new BeanCreationException(e.getErrMsg(), (Throwable)e);
        }
        return configService;
    }

    @Override
    protected boolean isCandidateMethod(Object bean, Class<?> beanClass, NacosConfigListener listener, Method method, ApplicationContext applicationContext) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Listener method [" + method + "] parameters' count must be one !"));
            }
            return false;
        }
        Class<?> targetType = parameterTypes[0];
        NacosConfigConverter configConverter = this.determineNacosConfigConverter(targetType, listener);
        if (!configConverter.canConvert(targetType) && this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Listener method [" + method + "] is not a candidate , thus its parameter type [" + targetType + "] can't be converted , please check NacosConfigConverter implementation : " + configConverter.getClass().getName()));
        }
        return true;
    }

    private NacosConfigConverter determineNacosConfigConverter(Class<?> targetType, NacosConfigListener listener) {
        Class converterClass = listener.converter();
        DefaultNacosConfigConverter configConverter = null;
        configConverter = NacosConfigConverter.class.equals((Object)converterClass) ? new DefaultNacosConfigConverter(targetType, this.conversionService) : (DefaultNacosConfigConverter)BeanUtils.instantiateClass((Class)converterClass);
        return configConverter;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.globalNacosProperties = GlobalNacosPropertiesSource.CONFIG.getMergedGlobalProperties((BeanFactory)applicationContext);
        this.nacosServiceFactory = NacosBeanUtils.getNacosServiceFactoryBean((BeanFactory)applicationContext);
        this.conversionService = this.determineConversionService(applicationContext);
        this.configServiceBeanBuilder = NacosBeanUtils.getConfigServiceBeanBuilder((BeanFactory)applicationContext);
    }

    private ConversionService determineConversionService(ApplicationContext applicationContext) {
        ConversionService conversionService;
        String beanName = NACOS_CONFIG_CONVERSION_SERVICE_BEAN_NAME;
        ConversionService conversionService2 = conversionService = applicationContext.containsBean(beanName) ? (ConversionService)applicationContext.getBean(beanName, ConversionService.class) : null;
        if (conversionService == null) {
            conversionService = new DefaultFormattingConversionService();
        }
        return conversionService;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

