/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.context.event;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;

public class DeferredApplicationEventPublisher
implements ApplicationEventPublisher,
ApplicationListener<ContextRefreshedEvent> {
    private final ConfigurableApplicationContext context;
    private final List<ApplicationEvent> deferredEvents = new LinkedList<ApplicationEvent>();

    public DeferredApplicationEventPublisher(ConfigurableApplicationContext context) {
        this.context = context;
        this.context.addApplicationListener((ApplicationListener)this);
    }

    public void publishEvent(ApplicationEvent event) {
        if (this.context.isRunning()) {
            this.context.publishEvent(event);
        } else {
            this.deferredEvents.add(event);
        }
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext currentContext = event.getApplicationContext();
        if (!currentContext.equals(this.context)) {
            return;
        }
        this.replayDeferredEvents();
    }

    private void replayDeferredEvents() {
        Iterator<ApplicationEvent> iterator = this.deferredEvents.iterator();
        while (iterator.hasNext()) {
            ApplicationEvent event = iterator.next();
            this.publishEvent(event);
            iterator.remove();
        }
    }
}

